/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz.strategy.alignment;

import fr.unicaen.measure.glozz.model.UnitaryAlignment;
import fr.unicaen.measure.glozz.model.UnitaryAlignmentSet;
import fr.unicaen.measure.glozz.strategy.alignment.IPossibleAlignmentComputer;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.IUnit;
import java.util.List;
import scpsolver.constraints.LinearConstraint;
import scpsolver.constraints.LinearEqualsConstraint;
import scpsolver.lpsolver.LinearProgramSolver;
import scpsolver.lpsolver.SolverFactory;
import scpsolver.problems.LinearProgram;

public class LinearProgrammingAlignmentComputer
implements IPossibleAlignmentComputer {
    private long total = 0L;
    private ICorpus corpus;

    public LinearProgrammingAlignmentComputer(ICorpus corpus) {
        this.corpus = corpus;
    }

    @Override
    public UnitaryAlignmentSet calculate(UnitaryAlignmentSet unitaryAlignmentSet) {
        long time = System.currentTimeMillis();
        List units = this.corpus.getUnitSet().getAnnotations();
        List<UnitaryAlignment> alignments = unitaryAlignmentSet.getList();
        double[] weights = new double[alignments.size()];
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = alignments.get(i).getWeight();
        }
        LinearProgram lp = new LinearProgram(weights);
        lp.setMinProblem(true);
        for (int i = 0; i < weights.length; ++i) {
            lp.setBinary(i);
        }
        double[] presenceDuneUnitDansUnUniaryAlignment = new double[weights.length];
        int cpt = 0;
        for (IUnit unit : units) {
            for (int i = 0; i < weights.length; ++i) {
                presenceDuneUnitDansUnUniaryAlignment[i] = alignments.get(i).contains(unit) ? 1 : 0;
            }
            lp.addConstraint((LinearConstraint)new LinearEqualsConstraint(presenceDuneUnitDansUnUniaryAlignment, 1.0, "c" + cpt++));
        }
        LinearProgramSolver solver = SolverFactory.newDefault();
        double[] sol = solver.solve(lp);
        UnitaryAlignmentSet resultSet = new UnitaryAlignmentSet();
        for (int i = 0; i < sol.length; ++i) {
            if (!(sol[i] > 0.0)) continue;
            resultSet.add(alignments.get(i));
        }
        return resultSet;
    }
}

