/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz.strategy.alignment;

import fr.unicaen.measure.glozz.GlozzConstants;
import fr.unicaen.measure.glozz.GlozzLogger;
import fr.unicaen.measure.glozz.model.EmptyUnit;
import fr.unicaen.measure.glozz.model.UnitaryAlignment;
import fr.unicaen.measure.glozz.model.UnitaryAlignmentSet;
import fr.unicaen.measure.glozz.strategy.alignment.IAlignmentComputer;
import fr.unicaen.measure.glozz.strategy.dissimilarity.IDissimilarityComputer;
import fr.unicaen.measure.model.IAnnotation;
import fr.unicaen.measure.model.IAnnotationSet;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.IUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class AlignmentComputerSimple
implements IAlignmentComputer,
GlozzConstants {
    public static final int NO_THRESHOLD_IN_RECURSION = -1;
    private double thresholdInRecursion;
    private boolean reinforcement = false;
    private double mutualReinforcementMinCoefficient = 0.5;
    private int iteration;
    private int ignored;
    private int number;
    private long duration;
    private double weightTwoVoidUnits = 1.0;

    public AlignmentComputerSimple(double threshold, boolean mutualReinforcement, double mutualReinforcementMinCoefficient) {
        GlozzLogger.debug("___________________Threshold=" + threshold);
        this.thresholdInRecursion = threshold;
        this.reinforcement = mutualReinforcement;
        this.mutualReinforcementMinCoefficient = mutualReinforcementMinCoefficient;
    }

    public AlignmentComputerSimple() {
        this(-1.0);
    }

    public AlignmentComputerSimple(double threshold) {
        this(threshold, false, 0.5);
    }

    public double getThresholdInRecursion() {
        return this.thresholdInRecursion;
    }

    public void setThresholdInRecursion(double thresholdInRecursion) {
        this.thresholdInRecursion = thresholdInRecursion;
    }

    public double getWeightTwoVoidUnits() {
        return this.weightTwoVoidUnits;
    }

    public void setWeightTwoVoidUnits(double weightTwoVoidUnits) {
        this.weightTwoVoidUnits = weightTwoVoidUnits;
    }

    public boolean isReinforcement() {
        return this.reinforcement;
    }

    public void setReinforcement(boolean reinforcement) {
        this.reinforcement = reinforcement;
    }

    public double getMutualReinforcementMinCoefficient() {
        return this.mutualReinforcementMinCoefficient;
    }

    public void setMutualReinforcementMinCoefficient(double mutualReinforcementMinCoefficient) {
        this.mutualReinforcementMinCoefficient = mutualReinforcementMinCoefficient;
    }

    protected UnitaryAlignmentSet getCombinationOfUnits(ICorpus corpus, IDissimilarityComputer dissimilarityComputer) {
        Collection<IAnnotationSet<IUnit>> annotationsSetByAnnotators = corpus.getUnitSet().getAnnotationSetByAuthor().values();
        return this.getCombinationOfUnits(annotationsSetByAnnotators, dissimilarityComputer);
    }

    protected UnitaryAlignmentSet getCombinationOfUnits(Collection<IAnnotationSet<IUnit>> setByAnnotators, IDissimilarityComputer dissimilarityComputer) {
        this.iteration = 0;
        this.ignored = 0;
        this.number = 0;
        UnitaryAlignmentSet result = new UnitaryAlignmentSet();
        ArrayList<IAnnotationSet<IUnit>> sets = new ArrayList<IAnnotationSet<IUnit>>();
        for (IAnnotationSet<IUnit> set : setByAnnotators) {
            if (!set.getAnnotations().contains(EmptyUnit.getInstance())) {
                set.addAnnotation((IAnnotation)EmptyUnit.getInstance());
            }
            sets.add(set);
        }
        UnitaryAlignment ua = new UnitaryAlignment(sets.size(), this.isReinforcement(), this.getMutualReinforcementMinCoefficient());
        ua.setWeightTwoVoidUnits(this.weightTwoVoidUnits);
        long before = new Date().getTime();
        this.getRecursiveCombinationOfUnits(0, sets, result, new UnitaryAlignment(sets.size(), this.isReinforcement(), this.getMutualReinforcementMinCoefficient()), this.getThresholdInRecursion(), dissimilarityComputer);
        GlozzLogger.debug("------------------------------------ Done \n\t\t > " + result.size() + " alignments created in " + (new Date().getTime() - before) + " milliseconde(s)" + " \n\t\t > " + this.iteration + " iteration / Ignored alignments (due to Threshold) :  " + this.ignored);
        GlozzLogger.debug("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n");
        return result;
    }

    protected void getRecursiveCombinationOfUnits(int currentSetIndex, List<IAnnotationSet<IUnit>> sets, UnitaryAlignmentSet destination, UnitaryAlignment units, double threshold, IDissimilarityComputer dissimilarityComputer) {
        ++this.iteration;
        if (units.isFull()) {
            destination.add(units);
            return;
        }
        IAnnotationSet<IUnit> currentSet = sets.get(currentSetIndex);
        for (IUnit unit : currentSet.getAnnotations()) {
            UnitaryAlignment alignment = new UnitaryAlignment(units);
            alignment.addUnit(unit, dissimilarityComputer);
            ++this.number;
            if (threshold > -1.0 && alignment.getWeight() > this.getThresholdInRecursion()) {
                ++this.ignored;
                continue;
            }
            this.getRecursiveCombinationOfUnits(currentSetIndex + 1, sets, destination, alignment, threshold, dissimilarityComputer);
        }
    }

    @Override
    public UnitaryAlignmentSet getUnitaryAlignmentSet(ICorpus corpus, IDissimilarityComputer dissimilarityComputer) {
        return this.getCombinationOfUnits(corpus, dissimilarityComputer);
    }
}

