/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz.model;

import fr.unicaen.measure.glozz.GlozzConstants;
import fr.unicaen.measure.glozz.model.EmptyUnit;
import fr.unicaen.measure.glozz.strategy.calculator.ArithmeticAverage;
import fr.unicaen.measure.glozz.strategy.calculator.IAverageCalculatorStrategy;
import fr.unicaen.measure.glozz.strategy.calculator.ReinforcingAverage;
import fr.unicaen.measure.glozz.strategy.dissimilarity.IDissimilarityComputer;
import fr.unicaen.measure.model.IUnit;
import java.text.DecimalFormat;
import java.util.Arrays;

public class UnitaryAlignment
implements Comparable<UnitaryAlignment>,
GlozzConstants {
    public static final String REINFORCEMENT_NORMAL = "Reinforced";
    public static final String REINFORCEMENT_WORTHLESS = "Worthless";
    public static final String REINFORCEMENT_BETTER = "Better";
    public static final String REINFORCEMENT_NONE = "None";
    public static final boolean DEFAULT_REINFORCEMENT = true;
    public static final String DEFAULT_REINFORCEMENT_STRATEGY = "Better";
    public static final double DEFAULT_REINFOCEMENT_MIN_WEIGHT_COEFFICIENT = 0.5;
    private static IAverageCalculatorStrategy averageReinforcement = new ReinforcingAverage();
    private static IAverageCalculatorStrategy averageStandard = new ArithmeticAverage();
    private IUnit[] units;
    private double[] weights;
    private int currentIndex;
    private int currentIndexWeights;
    private double weight = -1.0;
    private double weightReinforced;
    private boolean reinforcement;
    private double threshold;
    private String reinforcementStrategy;
    private double reinforcementMinCoefficient;
    private double weightTwoVoidUnits;
    private int numberOfTrueSubAlignments = 0;
    private int numberOfFalseSubAlignments = 0;
    private DecimalFormat format = new DecimalFormat("0.0000000000");

    public UnitaryAlignment(int numberOfUnits, boolean reinforcement, double reinforcementMinCoefficient) {
        this(numberOfUnits, 2.0, reinforcement, "Better", reinforcementMinCoefficient, 1.0);
    }

    public UnitaryAlignment(int numberOfUnits, double threshold) {
        this(numberOfUnits, threshold, true, "Better", 0.5, 1.0);
    }

    public UnitaryAlignment(int numberOfUnits) {
        this(numberOfUnits, 2.0, true, "Better", 0.5, 1.0);
    }

    public UnitaryAlignment(int numberOfUnits, double threshold, boolean reinforcement, String reinforcementStrategy, double reinforcementMinCoefficient, double weightTwoVoidUnits) {
        this.units = new IUnit[numberOfUnits];
        this.currentIndex = 0;
        this.currentIndexWeights = 0;
        this.weight = -1.0;
        this.weightReinforced = -1.0;
        this.weights = new double[numberOfUnits * (numberOfUnits - 1) / 2];
        this.weightTwoVoidUnits = weightTwoVoidUnits;
        this.reinforcementStrategy = reinforcementStrategy;
        this.reinforcementMinCoefficient = reinforcementMinCoefficient;
        this.reinforcement = reinforcement;
        this.threshold = threshold;
    }

    public UnitaryAlignment(UnitaryAlignment original) {
        this.units = (IUnit[])original.units.clone();
        this.currentIndex = original.currentIndex;
        this.currentIndexWeights = original.currentIndexWeights;
        this.weight = original.weight;
        this.weightReinforced = original.weightReinforced;
        this.weights = (double[])original.weights.clone();
        this.threshold = original.threshold;
        this.reinforcement = original.reinforcement;
        this.reinforcementMinCoefficient = original.reinforcementMinCoefficient;
        this.reinforcementStrategy = original.reinforcementStrategy;
        this.weightTwoVoidUnits = original.weightTwoVoidUnits;
        this.numberOfFalseSubAlignments = original.numberOfFalseSubAlignments;
        this.numberOfTrueSubAlignments = original.numberOfTrueSubAlignments;
    }

    public void addUnit(IUnit addedUnit, IDissimilarityComputer dissimilarityComputer) {
        this.units[this.currentIndex] = addedUnit;
        ++this.currentIndex;
        if (this.currentIndex == 1) {
            return;
        }
        for (int i = 0; i < this.currentIndex - 1; ++i) {
            double distanceUnits;
            IUnit previous = this.units[i];
            this.weights[this.currentIndexWeights] = distanceUnits = this.distanceBetweenUnits(addedUnit, previous, dissimilarityComputer, this.weightTwoVoidUnits);
            ++this.currentIndexWeights;
            String s1 = addedUnit.getId();
            s1 = s1.substring(s1.lastIndexOf(95) + 1, s1.length());
            String s2 = previous.getId();
            s2 = s2.substring(s2.lastIndexOf(95) + 1, s2.length());
            if (s1.isEmpty() || addedUnit == EmptyUnit.getInstance() || previous == EmptyUnit.getInstance()) continue;
            if (s1.equals(s2)) {
                ++this.numberOfTrueSubAlignments;
                continue;
            }
            ++this.numberOfFalseSubAlignments;
        }
    }

    protected double distanceBetweenUnits(IUnit u, IUnit v, IDissimilarityComputer dissimilarityComputer, double weightTwoVoidUnits) {
        return dissimilarityComputer.measure(u, v, weightTwoVoidUnits);
    }

    public boolean contains(IUnit unit) {
        for (IUnit u : this.units) {
            if (unit != u) continue;
            return true;
        }
        return false;
    }

    public boolean isFull() {
        return this.givenSize() == this.waitedSize();
    }

    public int givenSize() {
        return this.currentIndex;
    }

    public int waitedSize() {
        return this.units.length;
    }

    public boolean isEmpty() {
        for (IUnit u : this.units) {
            if (u == EmptyUnit.getInstance()) continue;
            return false;
        }
        return true;
    }

    public boolean isRelevant(double threshold) {
        return this.getWeight() <= threshold || threshold == -1.0;
    }

    public double getWeight() {
        double result = this.reinforcement ? averageReinforcement.avg(this.weights, this.reinforcementMinCoefficient) : averageStandard.avg(this.weights);
        return result;
    }

    public double getWeight(IDissimilarityComputer dissimilarityWeightComputer) {
        return this.getWeight(dissimilarityWeightComputer, true);
    }

    public double getWeight(IDissimilarityComputer dissimilarityWeightComputer, boolean withEmptyUnits) {
        double t;
        IUnit[] usedUnits;
        int compteur = 0;
        System.out.println("Nbr of 'real' unit : " + (this.units.length - this.getEmptyCount()));
        if (this.getEmptyCount() != 0 && !withEmptyUnits) {
            IUnit[] unitsWithoutEmpty = new IUnit[this.units.length - this.getEmptyCount()];
            int j = 0;
            for (int i = 0; i < this.units.length; ++i) {
                if (this.units[i] == EmptyUnit.getInstance()) continue;
                unitsWithoutEmpty[j++] = this.units[i];
            }
            usedUnits = unitsWithoutEmpty;
        } else {
            usedUnits = this.units;
        }
        if (usedUnits.length < 2) {
            return 0.0;
        }
        double[] recalculateWeights = new double[usedUnits.length * (usedUnits.length - 1)];
        int k = 0;
        for (int i = 0; i < usedUnits.length; ++i) {
            IUnit u1 = usedUnits[i];
            int j = i + 1;
            while (j < usedUnits.length) {
                ++compteur;
                IUnit u2 = usedUnits[j];
                double dis = this.distanceBetweenUnits(u1, u2, dissimilarityWeightComputer, this.weightTwoVoidUnits);
                System.out.println("dis(" + u1 + "," + u2 + ") = " + dis);
                recalculateWeights[k] = dis;
                ++j;
                ++k;
            }
        }
        System.out.println(Arrays.toString(recalculateWeights));
        double result = this.reinforcement ? averageReinforcement.avg(recalculateWeights, this.reinforcementMinCoefficient) : averageStandard.avg(recalculateWeights);
        double d = t = compteur > 0 ? result / (double)compteur : result;
        if (Double.isNaN(t)) {
            // empty if block
        }
        return t;
    }

    public double getSortWeight() {
        return this.getWeight();
    }

    public double getWeightTwoVoidUnits() {
        return this.weightTwoVoidUnits;
    }

    public void setWeightTwoVoidUnits(double weightTwoVoidUnits) {
        this.weightTwoVoidUnits = weightTwoVoidUnits;
    }

    public String toString() {
        String s = this.format.format(this.getWeight()) + " \t ";
        for (IUnit u : this.units) {
            if (u == null) continue;
            s = s + u.getId() + " \t ";
        }
        return s;
    }

    @Override
    public int compareTo(UnitaryAlignment t) {
        double weightThis;
        double weightOther = t.getWeight();
        if (weightOther == (weightThis = this.getWeight())) {
            int other;
            int self = this.getEmptyCount();
            if (self == (other = t.getEmptyCount())) {
                return 0;
            }
            return self < other ? -1 : 1;
        }
        return weightThis < weightOther ? -1 : 1;
    }

    public IUnit[] getUnits() {
        return this.units;
    }

    public int getEmptyCount() {
        int empty = 0;
        for (IUnit u : this.units) {
            if (u != EmptyUnit.getInstance()) continue;
            ++empty;
        }
        return empty;
    }

    public String asString() {
        StringBuilder s = new StringBuilder();
        s.append(this.getWeight());
        for (IUnit u : this.units) {
            if (u == null) continue;
            s.append('\t').append(u.getId());
        }
        return s.toString();
    }

    public int getNumberOfFalseSubAlignments() {
        return this.numberOfFalseSubAlignments;
    }

    public int getNumberOfTrueSubAlignments() {
        return this.numberOfTrueSubAlignments;
    }
}

