/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz.model;

import fr.unicaen.measure.glozz.model.CorpusSet;
import fr.unicaen.measure.model.ICorpus;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Observable;

public class CorpusSetObservable
extends Observable {
    public static final int EVENT_CORPUS_SET_CHANGE = 1;
    private CorpusSet corpusSet;
    private boolean loaded = false;

    public CorpusSetObservable() {
        this(new CorpusSet());
    }

    public CorpusSetObservable(CorpusSet corpusSet) {
        this.corpusSet = corpusSet;
    }

    public void loadFromPath(File path) throws FileNotFoundException, IOException {
        this.corpusSet = CorpusSet.parseRichterDirectory(path, -1, 0);
        this.loaded = true;
        this.setChanged();
        this.notifyObservers(1);
    }

    public String[] getCorpusNames() {
        return this.corpusSet.corpusNames.toArray(new String[0]);
    }

    public CorpusSet getCorpusSet() {
        return this.corpusSet;
    }

    public ICorpus getCorpus(String name) {
        return this.corpusSet.getCorpusByName(name);
    }

    public boolean isLoaded() {
        return this.loaded;
    }
}

