/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz.model;

import fr.unicaen.measure.glozz.GlozzLogger;
import fr.unicaen.measure.model.CorpusImpl;
import fr.unicaen.measure.model.IAnnotationSet;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.IUnit;
import fr.unicaen.measure.utils.CSVToAnnotationSetAdapter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

public class CorpusSet
extends ArrayList<ICorpus> {
    public static final int AUTO_TEXT_SIZE = -1;
    public static final int DEFAULT_TEXT_TYPE = 0;
    public ArrayList<String> corpusNames = new ArrayList();

    public static CorpusSet parseRichterDirectory(File directory, int textSize, int textType) throws FileNotFoundException, IOException {
        GlozzLogger.debug("Parse richter directory {0}", directory);
        CorpusSet corpusSet = new CorpusSet();
        File[] texts = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String path = file.getAbsolutePath().toLowerCase();
                return path.endsWith(".txt") || path.endsWith(".csv");
            }
        });
        GlozzLogger.prod("{0} file(s) loaded.", texts.length);
        for (File file : texts) {
            CorpusImpl c = new CorpusImpl(textSize, textType);
            c.getUnitSet().addAnnotationsFrom(CorpusSet.getAnnotationsFromRichterFile(file));
            if (textSize == -1) {
                int lastEndUnit = 0;
                for (IUnit u : c.getUnitSet().getAnnotations()) {
                    lastEndUnit = Math.max(lastEndUnit, u.getEndIndex());
                }
                c.setTextSize(lastEndUnit);
            }
            corpusSet.addCorpus((ICorpus)c, file.getName());
        }
        return corpusSet;
    }

    public void addCorpus(ICorpus c, String name) {
        GlozzLogger.debug(name);
        this.add(c);
        this.corpusNames.add(name);
    }

    public ICorpus getCorpusByName(String name) {
        int index = this.corpusNames.indexOf(name);
        return (ICorpus)this.get(index);
    }

    public static CorpusSet parseRichterDirectory(String directory, int textSize, int textType) throws FileNotFoundException, IOException {
        return CorpusSet.parseRichterDirectory(new File(directory), textSize, textType);
    }

    public static CorpusSet parseRichterDirectory(String directory, int textType) throws FileNotFoundException, IOException {
        return CorpusSet.parseRichterDirectory(new File(directory), -1, textType);
    }

    public static IAnnotationSet<IUnit> getAnnotationsFromRichterFile(File corpusFile) throws FileNotFoundException, IOException {
        CSVToAnnotationSetAdapter adapter = new CSVToAnnotationSetAdapter(corpusFile.getAbsolutePath());
        return adapter.convert();
    }

    @Override
    public String toString() {
        String s = "CorpusSet {";
        for (ICorpus c : this) {
            s = s + c + "\n---\n";
        }
        s = s + "}";
        return s;
    }
}

