/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz.gui.views;

import fr.unicaen.measure.glozz.model.EmptyUnit;
import fr.unicaen.measure.glozz.model.UnitaryAlignment;
import fr.unicaen.measure.glozz.model.UnitaryAlignmentSet;
import fr.unicaen.measure.glozz.strategy.alignment.AlignmentComputerSimple;
import fr.unicaen.measure.glozz.strategy.alignment.PossibleAlignmentComputerNibbler;
import fr.unicaen.measure.glozz.strategy.dissimilarity.DissimilarityComputerCategorialNominal;
import fr.unicaen.measure.glozz.strategy.dissimilarity.DissimilarityComputerCombi;
import fr.unicaen.measure.glozz.strategy.dissimilarity.DissimilarityComputerPositionalSporadic;
import fr.unicaen.measure.glozz.strategy.dissimilarity.IDissimilarityComputer;
import fr.unicaen.measure.gui.views.STCorpusViewPreview;
import fr.unicaen.measure.model.IUnit;
import fr.unicaen.measure.sufflingplugin.ICorpusObservable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;

public class UnitaryAlignmentSetPreview
extends STCorpusViewPreview {
    private UnitaryAlignmentSet unitaryAlignmentSet;
    private PossibleAlignmentComputerNibbler nibbler;
    private IDissimilarityComputer dissimilarityComputer;
    protected JButton caclulerBouton;
    private Stroke alignmentLine = new BasicStroke(2.0f);
    private Color alignmentColor = Color.BLACK;
    private Color alignmentLineColor = new Color(0, 0, 0, 150);
    private NumberFormat formatNumber = new DecimalFormat("0.0000");

    public UnitaryAlignmentSetPreview(ICorpusObservable corpus) {
        super(corpus);
        this.caclulerBouton = new JButton(new AbstractAction("calculer"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                UnitaryAlignmentSetPreview.this.calculateAlignment();
            }
        });
        this.add(this.caclulerBouton, "Last");
        DissimilarityComputerPositionalSporadic position = new DissimilarityComputerPositionalSporadic(4.0);
        DissimilarityComputerCategorialNominal cat = new DissimilarityComputerCategorialNominal();
        this.dissimilarityComputer = new DissimilarityComputerCombi(position, cat);
        this.nibbler = new PossibleAlignmentComputerNibbler();
    }

    public void calculateAlignment() {
        UnitaryAlignmentSet all = new AlignmentComputerSimple().getUnitaryAlignmentSet(this.corpus.getCorpus(), this.dissimilarityComputer);
        this.unitaryAlignmentSet = this.nibbler.calculate(all);
    }

    protected void drawAfter(Graphics2D g) {
        if (this.unitaryAlignmentSet == null) {
            return;
        }
        this.calculateAlignment();
        for (UnitaryAlignment ua : this.unitaryAlignmentSet) {
            IUnit[] units = ua.getUnits();
            for (int i = 0; i < units.length - 1; ++i) {
                IUnit a = units[i];
                if (a == EmptyUnit.getInstance()) continue;
                for (int j = i + 1; j < units.length; ++j) {
                    IUnit b = units[j];
                    g.setStroke(this.alignmentLine);
                    g.setColor(this.alignmentLineColor);
                    if (b == EmptyUnit.getInstance()) continue;
                    STCorpusViewPreview.DrawedUnit2D dA = this.getDrawedUnitById(a.getId());
                    STCorpusViewPreview.DrawedUnit2D dB = this.getDrawedUnitById(b.getId());
                    int x1 = (int)(dA.getX() + dA.getWidth() / 2.0);
                    int x2 = (int)(dB.getX() + dB.getWidth() / 2.0);
                    int y1 = (int)(dA.getY() + dA.getHeight() / 2.0);
                    int y2 = (int)(dB.getY() + dB.getHeight() / 2.0);
                    g.drawLine(x1, y1, x2, y2);
                    int xMax = Math.max(x1, x2);
                    int xMin = Math.min(x1, x2);
                    int yMax = Math.max(y1, y2);
                    int yMin = Math.min(y1, y2);
                    g.setColor(this.alignmentColor);
                    g.setFont(this.fontAnnotatorLabel);
                }
            }
        }
    }

    public void displayAlignmentSet(UnitaryAlignmentSet uas) {
        this.unitaryAlignmentSet = uas;
        for (UnitaryAlignment unitaryAlignment : uas) {
        }
        this.repaint();
    }

    public class DissimilarityWatcher {
        private List<IUnit> units;
    }
}

