/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz.gui.views;

import fr.unicaen.measure.glozz.gui.actions.ComputeCorpusSetExpectedAction;
import fr.unicaen.measure.glozz.gui.model.ProjectModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CorpusSetView
extends JPanel
implements Observer,
ListSelectionListener {
    private ProjectModel model;
    private JList corpus;
    private ComputeCorpusSetExpectedAction computeExpected;
    private JTextField expected;

    public CorpusSetView(ProjectModel model, ComputeCorpusSetExpectedAction computeAction) {
        this.computeExpected = computeAction;
        this.model = model;
        this.model.addObserver(this);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Corpus loaded"));
        this.corpus = new JList();
        this.corpus.addListSelectionListener(this);
        this.add((Component)this.corpus, "Center");
        Box toolbar = Box.createHorizontalBox();
        toolbar.add(new JLabel("Exp : "));
        this.expected = new JTextField(model.getDisplayableExpected());
        toolbar.add(this.expected);
        this.expected.setEditable(false);
        this.expected.setColumns(6);
        JButton b = new JButton(computeAction);
        toolbar.add(b);
        b.setText("Calculate");
        this.add((Component)toolbar, "Last");
    }

    @Override
    public void update(Observable o, Object o1) {
        if (o1 == "EVENT_CORPUS_SET_CHANGED") {
            this.corpus.setListData(this.model.getCorpusSet().getCorpusNames());
        }
        if (o1 == "EVENT_EXPECTED_CHANGE") {
            this.expected.setText(this.model.getDisplayableExpected());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        String corpusName = this.corpus.getSelectedValue().toString();
        if (corpusName == null) {
            return;
        }
        this.model.setSelectedCorpusName(corpusName);
    }
}

