/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz.gui.views;

import fr.unicaen.measure.glozz.GlozzGammaCat;
import fr.unicaen.measure.glozz.GlozzGammaMobius;
import fr.unicaen.measure.glozz.GlozzLogger;
import fr.unicaen.measure.glozz.MyFormat;
import fr.unicaen.measure.glozz.MyFormat2;
import fr.unicaen.measure.glozz.gui.model.ProjectModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class ConfigurationPaneView
extends JPanel
implements Observer,
ActionListener {
    private ProjectModel model;
    private JComboBox comboPositionnal;
    private JComboBox comboCategorial;
    private JComboBox comboMeasure;
    private JComboBox comboPrecision;
    private JTextField textEmptyDelta;
    private JLabel result;

    public ConfigurationPaneView(ProjectModel model) {
        this.model = model;
        this.model.addObserver(this);
        this.drawComponements();
    }

    private void drawComponements() {
        this.setLayout(new BorderLayout());
        JPanel mainOptions = new JPanel(new GridLayout(1, 2));
        mainOptions.setBorder(BorderFactory.createTitledBorder("Settings"));
        JPanel pMeasure = new JPanel(new FlowLayout());
        pMeasure.add(new JLabel("Measure : "));
        this.comboMeasure = new JComboBox<String>(this.model.getMeasuresName());
        this.comboMeasure.setSelectedItem(this.model.getActiveMeasure());
        this.comboMeasure.addActionListener(this);
        pMeasure.add(this.comboMeasure);
        mainOptions.add(pMeasure);
        JPanel pPrecision = new JPanel(new FlowLayout());
        JLabel l = new JLabel("<html>Precision of expected computation : </html>");
        this.comboPrecision = new JComboBox<String>(ProjectModel.PRECISIONS_LABELS);
        this.comboPrecision.setSelectedItem("" + this.model.getExpectedPrecision() + "%");
        this.comboPrecision.addActionListener(this);
        pPrecision.add(l);
        pPrecision.add(this.comboPrecision);
        mainOptions.add(pPrecision);
        Box.Filler glue = (Box.Filler)Box.createHorizontalGlue();
        glue.changeShape(glue.getMinimumSize(), new Dimension(500, 0), glue.getMaximumSize());
        this.add((Component)mainOptions, "North");
        JTabbedPane pane = new JTabbedPane(1);
        this.add((Component)pane, "Center");
        this.result = new JLabel("<html>no result yet</html>");
        this.model.addObserver(this);
        pane.add("Results", new JScrollPane(this.getResultScreen()));
    }

    private JPanel getExpectedScreen() {
        JPanel panel = new JPanel();
        return panel;
    }

    private JPanel getResultScreen() {
        JPanel panel = new JPanel();
        panel.add(this.result);
        return panel;
    }

    private JPanel getObservedScreen() {
        JPanel panel = new JPanel();
        return panel;
    }

    @Override
    public void update(Observable o, Object o1) {
        System.out.println("o:" + o1.toString());
        if (o1 == "EVENT_MEASURE_STARTS") {
            this.result.setText("Please wait...");
        }
        if (o1 == "EVENT_MESURE_COMPLETED") {
            MyFormat df = new MyFormat();
            MyFormat2 df2 = new MyFormat2();
            String retour = "<html><span style='font-size:18px'>";
            String cat = this.model.getMeasure() instanceof GlozzGammaCat ? "<sub><span style='font-size:12px'>cat</span></sub>" : "";
            retour = retour + "&gamma;" + cat + " &#x2243; " + df.format(this.model.getResult()) + "  (" + df.format(this.model.getResultInf()) + " &le; &gamma;" + cat + " &le; " + df.format(this.model.getResultSup()) + ")</span>";
            if (this.model.getMeasure() instanceof GlozzGammaMobius) {
                GlozzGammaMobius mobius = (GlozzGammaMobius)this.model.getMeasure();
                retour = retour + "<br><span style='font-size:12px'>";
                retour = retour + "observed disagreement=" + df2.format(mobius.getObservedTmp()) + "<br>";
                retour = retour + "expected disagreement=" + df2.format(mobius.getExpectedTmp()) + " &plusmn;" + mobius.getPrecision() + "%<br>";
                retour = retour + "number of resulting alignments=" + mobius.getNbrAlignements();
            }
            if (this.model.getMeasure() instanceof GlozzGammaCat) {
                GlozzGammaCat gammaCat = (GlozzGammaCat)this.model.getMeasure();
                retour = retour + "<br><span style='font-size:12px'>";
                retour = retour + "observed disagreement=" + df2.format(gammaCat.getObservedTmp()) + "<br>";
                retour = retour + "expected disagreement=" + df2.format(gammaCat.getExpectedTmp()) + " &plusmn;" + gammaCat.getPrecision() + "%<br>";
                retour = retour + "number of resulting alignments=" + gammaCat.getNbrAlignements();
                for (int i = 0; i < gammaCat.getCategories().size(); ++i) {
                    String c = gammaCat.getCategories().get(i);
                    double resK = gammaCat.getResultK()[i];
                    retour = retour + "<br>&gamma;<sub><span style='font-size:10px'>k(" + c + ")</span></sub> &#x2243; " + df2.format(resK);
                }
            }
            retour = retour + "</span></html>";
            this.result.setText(retour);
        }
        if (o1 != "EVENT_SELECTED_CORPUS_CHANGED" || this.model.getSelectedCorpus() == null) {
            // empty if block
        }
        if (o1 == "EVENT_EMPTY_DELTA_CHANGE") {
            this.textEmptyDelta.setText(this.model.getDeltaEmpty() + "");
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.comboPositionnal) {
            GlozzLogger.debug("Select positional {0}", this.comboPositionnal.getSelectedItem());
            this.model.setDissimilarityPositionnalName(this.comboPositionnal.getSelectedItem().toString());
            return;
        }
        if (ae.getSource() == this.comboMeasure) {
            this.model.setActiveMeasure(this.comboMeasure.getSelectedItem().toString());
            this.model.compute();
            return;
        }
        if (ae.getSource() == this.textEmptyDelta) {
            this.model.setDeltaEmpty(Double.parseDouble(this.textEmptyDelta.getText()));
            GlozzLogger.debug("Modification de DeltaVide");
        }
        if (ae.getSource() == this.comboPrecision) {
            this.model.setExpectedPrecision(ProjectModel.PRECISIONS[this.comboPrecision.getSelectedIndex()]);
            this.model.compute();
            return;
        }
    }
}

