/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz.gui.model;

import fr.unicaen.measure.core.IMeasure;
import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.glozz.GlozzEntropyMeasure;
import fr.unicaen.measure.glozz.GlozzExpectedCorpusSet;
import fr.unicaen.measure.glozz.GlozzGamma;
import fr.unicaen.measure.glozz.GlozzGammaCat;
import fr.unicaen.measure.glozz.GlozzGammaMobius;
import fr.unicaen.measure.glozz.GlozzLogger;
import fr.unicaen.measure.glozz.model.CorpusSetObservable;
import fr.unicaen.measure.glozz.strategy.contingency.CategorialContingencyMatrixComputerImpl;
import fr.unicaen.measure.glozz.strategy.contingency.ICategorialContingencyMatrixComputer;
import fr.unicaen.measure.glozz.strategy.dissimilarity.DissimilarityComputerCategorialNominal;
import fr.unicaen.measure.glozz.strategy.dissimilarity.DissimilarityComputerCombi;
import fr.unicaen.measure.glozz.strategy.dissimilarity.DissimilarityComputerPositionalSporadic;
import fr.unicaen.measure.glozz.strategy.dissimilarity.DissimilarityComputerPositionalSymetric;
import fr.unicaen.measure.glozz.strategy.dissimilarity.IDissimilarityComputer;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.sufflingplugin.CorpusObservableImpl;
import fr.unicaen.measure.sufflingplugin.ICorpusListenner;
import fr.unicaen.measure.sufflingplugin.ICorpusObservable;
import fr.unicaen.measure.utils.CorpusUtil;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProjectModel
extends Observable
implements ICorpusObservable {
    public static final int UNCALCULATED = -2;
    public static final int DEFAULT_EXPECTED_ITERATION = 10;
    public static final String NO_CORPUS_SELECTED = "";
    public static final String NO_CORPUS_SET_PATH = "";
    public static final String NO_DISSIMILARITY = "";
    public static final String DISSIMILARITY_CATEGORIAL_NOMINAL = "Nominal";
    public static final String DISSIMILARITY_CATEGORIAL_INTERVAL = "Interval";
    public static final String DISSIMILARITY_CATEGORIAL_DATA_DRIVEN = "Data driven";
    public static final String DISSIMILARITY_POSITIONAL_SPORADIC = "Sporadic";
    public static final String DISSIMILARITY_POSITIONAL_SYMETRIC = "Symetric";
    public static final String EVENT_CORPUS_SET_CHANGED = "EVENT_CORPUS_SET_CHANGED";
    public static final String EVENT_SELECTED_CORPUS_CHANGED = "EVENT_SELECTED_CORPUS_CHANGED";
    public static final String EVENT_DISSIMILARITY_CHANGE = "EVENT_DISSIMILARITY_CHANGE";
    public static final String EVENT_EXPECTED_CHANGE = "EVENT_EXPECTED_CHANGE";
    public static final String EVENT_EMPTY_DELTA_CHANGE = "EVENT_EMPTY_DELTA_CHANGE";
    public static final String EVENT_MESURE_COMPLETED = "EVENT_MESURE_COMPLETED";
    public static final String EVENT_MEASURE_STARTS = "EVENT_MEASURE_STARTS";
    public static final String MODE_DIRECTORY = "CALCULATE_DIRECTORY";
    public static final String MODE_SINGLE_RICHTER = "SINGLE_RIGHTER";
    public static final String MEASURE_GAMMA = "Gamma at corpus level";
    public static final String MEASURE_MOBIUS = "Gamma";
    public static final String MEASURE_GAMMA_CAT = "GammaCat";
    public static final String EVENT_ERROR_THROW = "EVENT_ERROR_THROW";
    private GlozzEntropyMeasure computeEntropy;
    private GlozzExpectedCorpusSet computeExpected;
    private IDissimilarityComputer positionnal;
    private IDissimilarityComputer categorial;
    private int expectedPrecision = 5;
    private GlozzGamma glozzGamma;
    private GlozzGammaMobius glozzMobius;
    private GlozzGammaCat glozzGammaCat;
    private String activeMeasure = "Gamma";
    private IMeasure measure = this.glozzMobius;
    private double result;
    private double resultInf;
    private double resultSup;
    private String resultMsg = "waiting";
    private CorpusSetObservable corpusSet;
    private CorpusObservableImpl selectedCorpusObservable;
    private String mode = "SINGLE_RIGHTER";
    private String[] dissimilarityPositional = new String[]{"Symetric", "Sporadic"};
    private String[] dissimilarityCategorial = new String[]{"Nominal", "Data driven"};
    private String[] measures = new String[]{"Gamma", "GammaCat"};
    public static final int[] PRECISIONS = new int[]{1, 2, 5, 10};
    public static final String[] PRECISIONS_LABELS = new String[PRECISIONS.length];
    private ICategorialContingencyMatrixComputer contingencyMatrixComputer;
    private String corpusSetPath = "";
    private double deltaEmpty = 1.0;
    private double computedExpected = -2.0;
    private Map<String, Double> computedObserved = null;
    private String selectedCorpusName = "";
    private String dissimilarityPositionalName = "Sporadic";
    private String dissimilarityCategorialName = "Nominal";
    private boolean autoCompute = false;
    private NumberFormat formatDoubleLong = new DecimalFormat("0.0000");
    private List<Exception> exceptions;
    private int expectedIterations = 10;
    private List<ICorpusListenner> corpusListenners = new ArrayList<ICorpusListenner>();

    public String getActiveMeasure() {
        return this.activeMeasure;
    }

    public void setActiveMeasure(String measureName) {
        this.activeMeasure = measureName;
        if (this.activeMeasure == MEASURE_GAMMA) {
            this.measure = this.glozzGamma;
        }
        if (this.activeMeasure == MEASURE_MOBIUS) {
            this.measure = this.glozzMobius;
        }
        if (this.activeMeasure == MEASURE_GAMMA_CAT) {
            this.measure = this.glozzGammaCat;
        }
    }

    public ProjectModel() {
        this.corpusSet = new CorpusSetObservable();
        this.computeEntropy = new GlozzEntropyMeasure();
        this.computeExpected = new GlozzExpectedCorpusSet();
        this.exceptions = new ArrayList<Exception>();
        this.selectedCorpusObservable = new CorpusObservableImpl(-1);
        this.glozzGamma = new GlozzGamma();
        this.glozzMobius = new GlozzGammaMobius();
        this.glozzGammaCat = new GlozzGammaCat();
        this.measure = this.glozzMobius;
        this.contingencyMatrixComputer = new CategorialContingencyMatrixComputerImpl();
    }

    public int getExpectedIterations() {
        return this.expectedIterations;
    }

    public void setExpectedIterations(int expectedIterations) {
        this.expectedIterations = expectedIterations;
    }

    public void setDeltaEmpty(double deltaEmpty) {
        this.deltaEmpty = deltaEmpty;
        this.fireChange(EVENT_EMPTY_DELTA_CHANGE);
    }

    public ICorpus getSelectedCorpus() {
        if (this.selectedCorpusName.equals("")) {
            return null;
        }
        return this.corpusSet.getCorpus(this.selectedCorpusName);
    }

    public void setSelectedCorpusName(String corpusName) {
        System.out.println(corpusName);
        if (!this.selectedCorpusName.equals(corpusName)) {
            this.selectedCorpusName = corpusName;
            if (this.getSelectedCorpus() != null) {
                this.selectedCorpusObservable = new CorpusObservableImpl(-1);
                this.selectedCorpusObservable.loadAnnotations(this.getSelectedCorpus().getUnitSet());
                try {
                    this.result = this.measure.measure(this.getSelectedCorpus());
                    this.fireChange(EVENT_MESURE_COMPLETED);
                }
                catch (MeasureException ex) {
                    Logger.getLogger(ProjectModel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.fireCorpusChange();
        }
    }

    public String[] getDissimilaritiesCategorial() {
        return this.dissimilarityCategorial;
    }

    public String[] getDissimilaritiesPositionalName() {
        return this.dissimilarityPositional;
    }

    public String[] getMeasuresName() {
        return this.measures;
    }

    public void setDissimilarityCategorialName(String dissimilarityName) {
        this.dissimilarityCategorialName = dissimilarityName;
        if (this.dissimilarityCategorialName.equals(DISSIMILARITY_CATEGORIAL_NOMINAL)) {
            this.categorial = new DissimilarityComputerCategorialNominal();
        } else {
            if (this.dissimilarityCategorialName.equals(DISSIMILARITY_CATEGORIAL_DATA_DRIVEN)) {
                throw new RuntimeException("Pas encore impl\u00e9ment\u00e9e");
            }
            if (this.dissimilarityCategorialName.equals("")) {
                this.categorial = null;
            } else {
                this.categorial = null;
                this.addException(new Exception("Dissimilarity categorial error"));
                this.fireChange(EVENT_ERROR_THROW);
            }
        }
        this.fireChange(EVENT_DISSIMILARITY_CHANGE);
    }

    public String getDissimilarityCategorialName() {
        return this.dissimilarityCategorialName;
    }

    public void calculateContingencyMatrix() {
        try {
            this.contingencyMatrixComputer.getCategorialContingencyMatrix(this.corpusSet.getCorpusSet(), this.getDissimilarityStrategy());
        }
        catch (Exception ex) {
            this.addException(ex);
        }
    }

    public void setDissimilarityPositionnalName(String dissimilarityName) {
        this.dissimilarityPositionalName = dissimilarityName;
        if (this.dissimilarityPositionalName.equals(DISSIMILARITY_POSITIONAL_SYMETRIC)) {
            this.positionnal = new DissimilarityComputerPositionalSymetric();
        } else if (this.dissimilarityPositionalName.equals(DISSIMILARITY_POSITIONAL_SPORADIC)) {
            this.positionnal = new DissimilarityComputerPositionalSporadic();
        } else if (this.dissimilarityPositionalName.equals("")) {
            this.positionnal = null;
        } else {
            this.positionnal = null;
            this.addException(new Exception("Dissimilarity computer error"));
            this.fireChange(EVENT_ERROR_THROW);
        }
        this.fireChange(EVENT_DISSIMILARITY_CHANGE);
    }

    protected void fireChange(Object o) {
        this.setChanged();
        this.notifyObservers(o);
    }

    public String getDisplayableExpected() {
        if (this.computedExpected == -2.0) {
            return "Uncalculated";
        }
        return this.formatDoubleLong.format(this.computedExpected);
    }

    public void setCorpusSetPath(File path) throws Exception {
        GlozzLogger.prod("Corpus location : {0}", path);
        this.corpusSetPath = path.getAbsolutePath();
        this.corpusSet.loadFromPath(path);
        this.glozzGamma.setCorpusSet(this.corpusSet.getCorpusSet());
        this.selectedCorpusName = "";
        this.setChanged();
        this.notifyObservers(EVENT_CORPUS_SET_CHANGED);
        this.notifyObservers(EVENT_SELECTED_CORPUS_CHANGED);
    }

    public void calculateExpected(boolean force) {
        if (!this.corpusSet.isLoaded()) {
            this.addException(new Exception("No corpus set selected"));
        }
        if (force || this.computedExpected == -2.0) {
            try {
                this.computeEntropy.setDissimilarityComputer(this.getDissimilarityStrategy());
                this.computeEntropy.setEmptyDelta(this.deltaEmpty);
                this.computeExpected.setCorpusSet(this.getCorpusSet().getCorpusSet());
                this.computedExpected = this.computeExpected.measure(this.computeEntropy, this.getExpectedIterations());
                this.fireChange(EVENT_EXPECTED_CHANGE);
            }
            catch (Exception ex) {
                this.addException(ex);
            }
        }
    }

    protected IDissimilarityComputer getDissimilarityStrategy() throws Exception {
        if (this.positionnal != null && this.categorial != null) {
            return new DissimilarityComputerCombi(this.positionnal, this.categorial);
        }
        if (this.positionnal == null && this.categorial == null) {
            throw new Exception("Configure dissimilarity for calculate expected");
        }
        if (this.positionnal != null) {
            // empty if block
        }
        return this.positionnal == null ? this.categorial : this.positionnal;
    }

    public void addException(Exception ex) {
        this.exceptions.add(ex);
        this.setChanged();
        this.notifyObservers(EVENT_ERROR_THROW);
    }

    public Exception getLastException() {
        return this.exceptions.get(this.exceptions.size() - 1);
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public CorpusSetObservable getCorpusSet() {
        return this.corpusSet;
    }

    public String getCorpusSetPath() {
        return this.corpusSetPath;
    }

    public double getDeltaEmpty() {
        return this.deltaEmpty;
    }

    public double getComputedExpected() {
        return this.computedExpected;
    }

    public ICorpusObservable getSelectedCorpusObservable() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void addCorpusListener(ICorpusListenner listenner) {
        this.corpusListenners.add(listenner);
    }

    public void removeCorpusListener(ICorpusListenner listenner) {
        this.corpusListenners.remove(listenner);
    }

    public void fireCorpusChange() {
        this.fireChange(EVENT_SELECTED_CORPUS_CHANGED);
        for (ICorpusListenner l : this.corpusListenners) {
            l.onCorpusChanged(this.getCorpus());
        }
    }

    public ICorpus getCorpus() {
        return this.getSelectedCorpus();
    }

    public void loadCorpus(ICorpus c, String name) {
        this.corpusSet = new CorpusSetObservable();
        this.corpusSet.getCorpusSet().addCorpus(c, name);
        this.selectedCorpusObservable.loadAnnotations(c.getUnitSet());
        this.selectedCorpusName = name;
        this.compute();
        this.fireCorpusChange();
    }

    public void setAnnotationFile(File path) {
        try {
            ICorpus c = CorpusUtil.loadFromRichterFile((File)path);
            this.loadCorpus(c, path.getName());
        }
        catch (Exception ex) {
            Logger.getLogger(ProjectModel.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println(path.getAbsoluteFile());
    }

    public double getResult() {
        return this.result;
    }

    public int getExpectedPrecision() {
        return this.expectedPrecision;
    }

    public void setExpectedPrecision(int expectedPrecision) {
        this.expectedPrecision = expectedPrecision;
        this.glozzMobius.setPrecision(expectedPrecision);
        this.glozzGammaCat.setPrecision(expectedPrecision);
    }

    public double getResultInf() {
        return this.resultInf;
    }

    public double getResultSup() {
        return this.resultSup;
    }

    public void compute() {
        this.fireChange(EVENT_MEASURE_STARTS);
        try {
            this.result = this.measure.measure(this.getSelectedCorpus());
            if (this.measure instanceof GlozzGammaMobius) {
                this.resultInf = ((GlozzGammaMobius)this.measure).getResultInf();
                this.resultSup = ((GlozzGammaMobius)this.measure).getResultSup();
            }
            if (this.measure instanceof GlozzGammaCat) {
                this.resultInf = ((GlozzGammaCat)this.measure).getResultInf();
                this.resultSup = ((GlozzGammaCat)this.measure).getResultSup();
            }
            this.fireChange(EVENT_MESURE_COMPLETED);
        }
        catch (MeasureException ex) {
            Logger.getLogger(ProjectModel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public IMeasure getMeasure() {
        return this.measure;
    }

    public void loadCorpus(ICorpus corpusLoaded) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getSelectedCorpusName() {
        return this.selectedCorpusName;
    }

    static {
        for (int i = 0; i < PRECISIONS.length; ++i) {
            ProjectModel.PRECISIONS_LABELS[i] = "" + PRECISIONS[i] + "%";
        }
    }
}

