/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz.gui.actions;

import com.jacksay.sgarnish.assets.JckIconProvider;
import com.jacksay.sgarnish.components.JckFileChooserFactory;
import com.jacksay.sgarnish.i18n.JckResourceBundle;
import fr.unicaen.measure.glozz.GlozzLogger;
import fr.unicaen.measure.glozz.gui.model.ProjectModel;
import fr.unicaen.measure.glozz.gui.preferences.GlozzGuiPreferences;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;

public class ConfigureCorpusSetDirectoryAction
extends AbstractAction {
    private ProjectModel model;

    public ConfigureCorpusSetDirectoryAction(ProjectModel model) {
        super(JckResourceBundle.get((String)"action.corpussetdirectory"), JckIconProvider.getIcon((String)"folder_page"));
        this.model = model;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        JFileChooser fc = JckFileChooserFactory.createJFileChooserDirectory((File)GlozzGuiPreferences.getCorpusPath());
        if (fc.showOpenDialog(null) == 1) {
            return;
        }
        File path = fc.getSelectedFile();
        GlozzGuiPreferences.setCorpusPath(path);
        this.loadCorpusSetFromPath(path);
    }

    public void loadCorpusSetFromPath(String path) {
        this.loadCorpusSetFromPath(new File(path));
    }

    public void loadCorpusSetFromPath(File path) {
        GlozzLogger.prod("Open {0}", path);
        try {
            this.model.setCorpusSetPath(path);
        }
        catch (Exception ex) {
            Logger.getLogger(ConfigureCorpusSetDirectoryAction.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

