/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz;

import fr.unicaen.measure.core.IMeasure;
import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.glozz.GlozzConstants;
import fr.unicaen.measure.glozz.GlozzEntropyMeasure;
import fr.unicaen.measure.glozz.model.UnitaryAlignmentSet;
import fr.unicaen.measure.glozz.strategy.alignment.AlignmentComputerSimple;
import fr.unicaen.measure.glozz.strategy.alignment.PossibleAlignmentComputerNibbler;
import fr.unicaen.measure.glozz.strategy.dissimilarity.DissimilarityComputerSER;
import fr.unicaen.measure.glozz.strategy.dissimilarity.IDissimilarityComputer;
import fr.unicaen.measure.model.ICorpus;

public class GlozzSER
implements IMeasure,
GlozzConstants {
    private GlozzEntropyMeasure observed;
    private double observedTmp;
    private double averageUnits;
    private double numberOfUnits;
    private IDissimilarityComputer ser = new DissimilarityComputerSER();

    public double getExpectedTmp() {
        return 0.0;
    }

    public double getObservedTmp() {
        return this.observedTmp;
    }

    public double measure(ICorpus corpus) throws MeasureException {
        AlignmentComputerSimple alignmentComputer = new AlignmentComputerSimple(1.0, false, 8.0);
        UnitaryAlignmentSet all = alignmentComputer.getUnitaryAlignmentSet(corpus, this.ser);
        PossibleAlignmentComputerNibbler nibbler = new PossibleAlignmentComputerNibbler();
        UnitaryAlignmentSet allAlignments = nibbler.calculate(all);
        this.observedTmp = allAlignments.getWeight();
        this.numberOfUnits = corpus.getUnitSet().getAnnotations().size();
        this.averageUnits = this.numberOfUnits / (double)corpus.getUnitSet().getAnnotationSetByAuthor().keySet().size();
        double val = 1.0 - this.observedTmp / this.averageUnits;
        return val;
    }

    public double getObserved() {
        return this.observedTmp;
    }

    public double getAverageUnits() {
        return this.averageUnits;
    }

    public boolean checkCorpus(ICorpus corpus) {
        return true;
    }
}

