/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz;

import com.jacksay.matrix.MatrixNumeric;
import fr.unicaen.measure.core.IMeasure;
import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.glozz.GlozzConstants;
import fr.unicaen.measure.glozz.GlozzEntropyMeasure;
import fr.unicaen.measure.glozz.GlozzExpectedCorpusSet;
import fr.unicaen.measure.glozz.GlozzLogger;
import fr.unicaen.measure.glozz.model.CorpusSet;
import fr.unicaen.measure.glozz.strategy.contingency.CategorialContingencyMatrixComputerImpl;
import fr.unicaen.measure.glozz.strategy.contingency.ComputeCategorialDistanceForBinominal;
import fr.unicaen.measure.glozz.strategy.dissimilarity.DissimilarityComputerCategorialBinomiale;
import fr.unicaen.measure.glozz.strategy.dissimilarity.DissimilarityComputerCategorialBinomialeCorrected;
import fr.unicaen.measure.glozz.strategy.dissimilarity.DissimilarityComputerCategorialCorpusDriven;
import fr.unicaen.measure.glozz.strategy.dissimilarity.DissimilarityComputerCategorialNearButPreferSame;
import fr.unicaen.measure.glozz.strategy.dissimilarity.DissimilarityComputerCategorialNominal;
import fr.unicaen.measure.glozz.strategy.dissimilarity.DissimilarityComputerCombi;
import fr.unicaen.measure.glozz.strategy.dissimilarity.DissimilarityComputerPositionalSporadic;
import fr.unicaen.measure.glozz.strategy.dissimilarity.DissimilarityComputerPositionalSporadic2;
import fr.unicaen.measure.glozz.strategy.dissimilarity.DissimilarityComputerPositionalSymetric;
import fr.unicaen.measure.glozz.strategy.dissimilarity.IDissimilarityComputer;
import fr.unicaen.measure.model.ICorpus;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GlozzGamma
implements IMeasure,
GlozzConstants {
    public static final String DISSIMILARITY_POSITIONNAL_SPORADIC = "Sporadic";
    public static final String DISSIMILARITY_POSITIONNAL_SPORADIC2 = "Sporadic 2";
    public static final String DISSIMILARITY_POSITIONNAL_SYMETRIC = "Symetric";
    public static final String DISSIMILARITY_CATEGORIAL_NOMINAL = "Norminal";
    public static final String DISSIMILARITY_CATEGORIAL_CORPUS_DRIVEN = "Corpus driven";
    public static final String DISSIMILARITY_CATEGORIAL_BINOMIAL = "Binomial rule";
    public static final String DISSIMILARITY_CATEGORIAL_BINOMIAL_CORRECTED = "Binomial corrected";
    public static final String DISSIMILARITY_CATEGORIAL_EPSILON = "Epsilon";
    public static final String DISSIMILARITY_MEASURED_SAME_AS_ALIGNEMENT = "Like alignement";
    public static final String DISSIMILARITY_MEASURED_POSITIONNAL = "Positionnal";
    public static final String DISSIMILARITY_MEASURED_CATEGORIAL = "Categorial";
    public static final String[] DISSIMILARITIES_POSITIONNAL = new String[]{"Sporadic", "Sporadic 2", "Symetric"};
    public static final String[] DISSIMILARITIES_MESURED = new String[]{"Like alignement", "Positionnal", "Categorial"};
    public static final String[] DISSIMILARITIES_CATEGORIAL = new String[]{"Norminal", "Corpus driven", "Binomial rule", "Binomial corrected", "Epsilon"};
    private GlozzEntropyMeasure observed = new GlozzEntropyMeasure();
    private GlozzExpectedCorpusSet expected;
    private double expectedTmp;
    private double observedTmp;
    private String dissimilarityPositionnalName = "Sporadic";
    private String dissimilarityCategorialName = "Norminal";
    private String dissimilarityMeasured = "Like alignement";
    private ComputeCategorialDistanceForBinominal binomial;
    private MatrixNumeric<String> matrixCorpusDriven;
    private double binomialAgreement;

    public GlozzGamma() {
        this.updateDissimilarity();
        this.observed.setThreshold(2.0);
        this.expected = new GlozzExpectedCorpusSet();
        GlozzLogger.level = 0;
    }

    private void updateDissimilarity() {
        try {
            this.observed.setDissimilarityComputer(new DissimilarityComputerCombi(this.getDissimilarity(this.dissimilarityCategorialName), this.getDissimilarity(this.dissimilarityPositionnalName)));
        }
        catch (MeasureException ex) {
            Logger.getLogger(GlozzGamma.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private IDissimilarityComputer getDissimilarity(String dissimilarityName) throws MeasureException {
        if (DISSIMILARITY_POSITIONNAL_SPORADIC.equals(dissimilarityName)) {
            return new DissimilarityComputerPositionalSporadic();
        }
        if (DISSIMILARITY_POSITIONNAL_SPORADIC2.equals(dissimilarityName)) {
            return new DissimilarityComputerPositionalSporadic2();
        }
        if (DISSIMILARITY_POSITIONNAL_SYMETRIC.equals(dissimilarityName)) {
            return new DissimilarityComputerPositionalSymetric();
        }
        if (DISSIMILARITY_CATEGORIAL_NOMINAL.equals(dissimilarityName)) {
            return new DissimilarityComputerCategorialNominal();
        }
        if (DISSIMILARITY_CATEGORIAL_EPSILON.equals(dissimilarityName)) {
            return new DissimilarityComputerCategorialNearButPreferSame();
        }
        if (DISSIMILARITY_CATEGORIAL_BINOMIAL.equals(dissimilarityName)) {
            DissimilarityComputerCategorialBinomiale dis = new DissimilarityComputerCategorialBinomiale();
            dis.setBinomial(this.binomial);
            return dis;
        }
        if (DISSIMILARITY_CATEGORIAL_BINOMIAL_CORRECTED.equals(dissimilarityName)) {
            DissimilarityComputerCategorialBinomialeCorrected dis = new DissimilarityComputerCategorialBinomialeCorrected();
            dis.setBinomial(this.binomial);
            dis.setAgreement(this.binomialAgreement);
            return dis;
        }
        if (DISSIMILARITY_CATEGORIAL_CORPUS_DRIVEN.equals(dissimilarityName)) {
            DissimilarityComputerCategorialCorpusDriven dis = new DissimilarityComputerCategorialCorpusDriven();
            dis.setContingency(this.matrixCorpusDriven);
            return dis;
        }
        throw new MeasureException("Unknow dissimilarity " + dissimilarityName);
    }

    public void setCorpusSet(CorpusSet cs) {
        if (this.dissimilarityCategorialName.equals(DISSIMILARITY_CATEGORIAL_CORPUS_DRIVEN)) {
            CategorialContingencyMatrixComputerImpl calculateContingency = new CategorialContingencyMatrixComputerImpl();
            DissimilarityComputerCombi dissimilarityComputer = new DissimilarityComputerCombi(new DissimilarityComputerCategorialNearButPreferSame(), new DissimilarityComputerPositionalSporadic());
            this.matrixCorpusDriven = calculateContingency.getCategorialContingencyMatrix(cs, dissimilarityComputer);
            System.out.println(this.matrixCorpusDriven);
            this.updateDissimilarity();
        } else if (this.dissimilarityCategorialName.equals(DISSIMILARITY_CATEGORIAL_BINOMIAL)) {
            this.binomial = new ComputeCategorialDistanceForBinominal();
            this.binomial.addCorpusSet(cs, new DissimilarityComputerCombi(new DissimilarityComputerCategorialNearButPreferSame(), new DissimilarityComputerPositionalSporadic()));
            this.updateDissimilarity();
        } else if (this.dissimilarityCategorialName.equals(DISSIMILARITY_CATEGORIAL_BINOMIAL_CORRECTED)) {
            DissimilarityComputerCombi combi = new DissimilarityComputerCombi(new DissimilarityComputerCategorialNominal(), new DissimilarityComputerPositionalSporadic());
            this.binomial = new ComputeCategorialDistanceForBinominal();
            this.binomial.addCorpusSet(cs, combi);
            GlozzGamma agree = new GlozzGamma();
            agree.setCorpusSet(cs);
            double agreement = 0.0;
            for (ICorpus c : cs) {
                try {
                    this.binomialAgreement = (agreement += agree.measure(c)) / (double)cs.size();
                }
                catch (MeasureException ex) {
                    Logger.getLogger(GlozzGamma.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.updateDissimilarity();
        }
        this.expected.setCorpusSet(cs);
        try {
            this.expectedTmp = this.expected.measure(this.observed, 50);
        }
        catch (MeasureException ex) {
            Logger.getLogger(GlozzGamma.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public double getExpectedTmp() {
        return this.expectedTmp;
    }

    public double getObservedTmp() {
        return this.observedTmp;
    }

    public double getNbrAlignements() {
        return this.observed.getNumberOfAlignment();
    }

    public double getMutualReinforcementMinCoefficient() {
        return this.observed.getMutualReinforcementMinCoefficient();
    }

    public void setMutualReinforcementMinCoefficient(double d) {
        this.observed.setMutualReinforcementMinCoefficient(d);
    }

    public double measure(ICorpus corpus) throws MeasureException {
        this.observedTmp = this.observed.measure(corpus);
        System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
        System.out.println("Number of true sub-alignments=" + this.observed.getNumberOfTrueSubAlignments());
        System.out.println("Number of false sub-alignments=" + this.observed.getNumberOfFalseSubAlignments());
        System.out.println("-------------------------------------------------------------");
        double val = this.observedTmp == 0.0 ? 1.0 : 1.0 - this.observedTmp / this.expectedTmp;
        GlozzLogger.prod(" # Agreement : " + val);
        return val;
    }

    public boolean checkCorpus(ICorpus corpus) {
        return true;
    }

    public void setMutualReinforcement(boolean b) {
        this.observed.setMutualReinforcement(b);
    }

    public boolean isWeightWithEmptyUnits() {
        return this.observed.isWeightWithEmptyUnits();
    }

    public void setWeightWithEmptyUnits(boolean b) {
        this.observed.setWeightWithEmptyUnits(b);
    }

    public boolean getMutualReinforcement() {
        return this.observed.isMutualReinforcement();
    }

    public double getThreshold() {
        return this.observed.getThreshold();
    }

    public void setThreshold(double d) {
        this.observed.setThreshold(d);
    }

    public void setDissimilarityPositionnal(String s) {
        this.dissimilarityPositionnalName = s;
        this.updateDissimilarity();
    }

    public String getDissimilarityPositionnal() {
        return this.dissimilarityPositionnalName;
    }

    public void setDissimilarityCategorial(String s) {
        this.dissimilarityCategorialName = s;
        this.updateDissimilarity();
    }

    public String getDissimilarityCategorial() {
        return this.dissimilarityCategorialName;
    }

    public String getDissimilarityMeasured() {
        return this.dissimilarityMeasured;
    }

    public void setDissimilarityMeasured(String dissimilarityMeasured) throws MeasureException {
        this.dissimilarityMeasured = dissimilarityMeasured;
        if (dissimilarityMeasured.equals(DISSIMILARITY_MEASURED_SAME_AS_ALIGNEMENT)) {
            this.observed.setDissimilarityWeightComputer(null);
        } else if (dissimilarityMeasured.equals(DISSIMILARITY_MEASURED_CATEGORIAL)) {
            this.observed.setDissimilarityWeightComputer(this.getDissimilarity(this.dissimilarityCategorialName));
        } else if (dissimilarityMeasured.equals(DISSIMILARITY_MEASURED_POSITIONNAL)) {
            this.observed.setDissimilarityWeightComputer(this.getDissimilarity(this.dissimilarityPositionnalName));
        }
    }
}

