/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz;

import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.glozz.GlozzEntropyMeasure;
import fr.unicaen.measure.glozz.GlozzLogger;
import fr.unicaen.measure.glozz.model.CorpusSet;
import fr.unicaen.measure.model.CorpusImpl;
import fr.unicaen.measure.model.IAnnotationSet;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.IUnit;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class GlozzExpectedCorpusSet {
    private CorpusSet corpusSet;
    private double expected = -1.0;
    private int numberOfBlinkText;

    public GlozzExpectedCorpusSet(CorpusSet corpusSet) {
        this.corpusSet = corpusSet;
    }

    public GlozzExpectedCorpusSet() {
        this(new CorpusSet());
    }

    public void setCorpusSet(CorpusSet corpusSet) {
        this.corpusSet = corpusSet;
    }

    public void loadCorpusSet(String directory) throws FileNotFoundException, IOException {
        this.loadCorpusSet(directory, -1, 0);
    }

    public void loadCorpusSet(String directory, int textSize, int textType) throws FileNotFoundException, IOException {
        this.corpusSet = CorpusSet.parseRichterDirectory(directory, 0);
    }

    public double measure(GlozzEntropyMeasure entropyMeasure, int amount) throws MeasureException {
        double observersAverageSize = this.computeObserverAverageSize();
        double total = 0.0;
        System.out.println("Calcul de l'expected -----------------");
        System.out.println("amount=" + amount);
        double sommePourVariance = 0.0;
        GlozzLogger.prod("-");
        GlozzLogger.prod("### EXPECTED ,Generate" + amount + " text(s) for expected computation.");
        for (int i = 0; i < amount; ++i) {
            ICorpus generated = this.generateMixedText(1000, (int)observersAverageSize);
            try {
                double entropy = entropyMeasure.measure(generated);
                total += entropy;
                sommePourVariance += entropy * entropy;
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.printf(generated.toString(), new Object[0]);
            }
        }
        double result = total / (double)amount;
        double variance = sommePourVariance / (double)amount - result * result;
        System.out.println("Moyenne = " + result + "  Ecart type=" + Math.sqrt(variance));
        System.out.println("Variance = " + variance);
        GlozzLogger.prod("Expected {0}/{1} = {2}\n", total, amount, result);
        if (Double.isNaN(result)) {
            throw new RuntimeException("Expected null !!!!");
        }
        this.expected = result;
        return result;
    }

    public double getExpected() {
        return this.expected;
    }

    public ICorpus generateMixedText(int size, int observers) {
        CorpusImpl corpus = new CorpusImpl(size, 0);
        boolean[] drawed = new boolean[this.corpusSet.size()];
        int annotatorID = 0;
        for (int i = 0; i < observers; ++i) {
            int random = (int)(Math.random() * (double)this.corpusSet.size());
            if (drawed[random]) {
                --i;
                continue;
            }
            drawed[random] = true;
            ICorpus corpusSelected = (ICorpus)this.corpusSet.get(random);
            String virtualObserverName = "A" + annotatorID++;
            Map observersAnnotations = corpusSelected.getUnitSet().getAnnotationSetByAuthor();
            String selectedObserver = (String)new ArrayList(observersAnnotations.keySet()).get((int)(Math.random() * (double)observersAnnotations.keySet().size()));
            IAnnotationSet annotations = ((IAnnotationSet)observersAnnotations.get(selectedObserver)).clone();
            for (IUnit u : annotations.getAnnotations()) {
                u.setAuthor(virtualObserverName);
            }
            corpus.getUnitSet().addAnnotationsFrom(annotations);
        }
        return corpus;
    }

    private double computeObserverAverageSize() {
        double total = 0.0;
        for (ICorpus c : this.corpusSet) {
            total += (double)c.getUnitSet().getAnnotationSetByAuthor().keySet().size();
        }
        return total / (double)this.corpusSet.size();
    }
}

