/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz;

import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.glozz.GlozzEntropyMeasure;
import fr.unicaen.measure.model.CorpusImpl;
import fr.unicaen.measure.model.IAnnotation;
import fr.unicaen.measure.model.IAnnotationSet;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.IUnit;

public class GlozzExpectedCorpusRandom {
    double weight;
    double unitsLenght;
    double alignmentsLength;
    int cross = 0;
    int[] moved;

    public double calculate(GlozzEntropyMeasure entropy, ICorpus c) throws MeasureException {
        return this.calculate(entropy, c, c.getTextSize() / 10);
    }

    public double calculate(GlozzEntropyMeasure entropy, ICorpus c, int magnitude) throws MeasureException {
        int pas = c.getTextSize() / magnitude;
        double entropyTotal = 0.0;
        this.moved = new int[magnitude];
        this.cross = 0;
        ICorpus shuffledCorpus = c.clone();
        for (int i = 0; i < magnitude; ++i) {
            CorpusImpl generated = new CorpusImpl(c.getTextSize(), c.getCorpusType());
            for (IAnnotationSet annotationsAuthor : shuffledCorpus.getUnitSet().getAnnotationSetByAuthor().values()) {
                int moving = (int)(Math.random() * (double)c.getTextSize());
                for (IUnit u : annotationsAuthor.getAnnotations()) {
                    u.setStartIndex(u.getStartIndex() + moving);
                    u.setEndIndex(u.getEndIndex() + moving);
                    if (u.getStartIndex() > c.getTextSize()) {
                        u.setStartIndex(u.getStartIndex() - c.getTextSize());
                        u.setEndIndex(u.getEndIndex() - c.getTextSize());
                    }
                    generated.getUnitSet().addAnnotation((IAnnotation)u);
                }
            }
            double thatEntropy = entropy.measure((ICorpus)generated);
            entropyTotal += thatEntropy;
        }
        return entropyTotal / (double)magnitude;
    }

    public double expByUnits() {
        return this.weight / this.unitsLenght;
    }

    public double expByAlignments() {
        return this.weight / this.alignmentsLength;
    }
}

