/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz;

import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.glozz.GlozzEntropyMeasure;
import fr.unicaen.measure.glozz.model.UnitaryAlignment;
import fr.unicaen.measure.glozz.model.UnitaryAlignmentSet;
import fr.unicaen.measure.glozz.strategy.alignment.AlignmentComputerSimple;
import fr.unicaen.measure.glozz.strategy.alignment.LinearProgrammingAlignmentComputer;
import fr.unicaen.measure.glozz.strategy.dissimilarity.IDissimilarityComputer;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.IUnit;
import java.util.ArrayList;

public class GlozzEntropyMeasureSpecialPurePos
extends GlozzEntropyMeasure {
    @Override
    public double measure(ICorpus corpus) throws MeasureException {
        if (corpus == null) {
            throw new MeasureException("No corpus given !");
        }
        this.observerLength = corpus.getUnitSet().getAnnotationSetByAuthor().keySet().size();
        this.categories = new ArrayList(corpus.getUnitSet().getAnnotationSetByCategory().keySet());
        this.unitsLength = corpus.getUnitSet().getAnnotations().size();
        AlignmentComputerSimple alignmentComputer = new AlignmentComputerSimple(this.getThreshold(), this.mutualReinforcement, this.mutualReinforcementMinCoefficient);
        UnitaryAlignmentSet all = alignmentComputer.getUnitaryAlignmentSet(corpus, this.getDissimilarityComputer());
        this.numberOfPossibleAlignment = all.size();
        LinearProgrammingAlignmentComputer nibbler = new LinearProgrammingAlignmentComputer(corpus);
        this.allAlignments = nibbler.calculate(all);
        this.numberOfAlignment = this.allAlignments.size();
        this.entropy = this.computeSpecialForFalsePosNeg(this.dissimilarityWeightComputer, this.allAlignments);
        if (Double.isNaN(this.entropy)) {
            throw new MeasureException("Entropy is NAN !");
        }
        this.numberOfTrueSubAlignments = 0;
        this.numberOfFalseSubAlignments = 0;
        for (UnitaryAlignment a : this.allAlignments) {
            this.numberOfTrueSubAlignments += a.getNumberOfTrueSubAlignments();
            this.numberOfFalseSubAlignments += a.getNumberOfFalseSubAlignments();
        }
        return this.entropy;
    }

    private double computeSpecialForFalsePosNeg(IDissimilarityComputer dissimilarityWeightComputer, UnitaryAlignmentSet allAlignments) {
        double total = 0.0;
        int count = 0;
        for (UnitaryAlignment ua : allAlignments) {
            IUnit[] units = ua.getUnits();
            int k = 0;
            for (int i = 0; i < units.length; ++i) {
                IUnit u1 = units[i];
                int j = i + 1;
                while (j < units.length) {
                    IUnit u2 = units[j];
                    double dis = dissimilarityWeightComputer.measure(u1, u2, -1.0);
                    if (dis >= 0.0) {
                        total += dis;
                        ++count;
                    }
                    ++j;
                    ++k;
                }
            }
        }
        return total / (double)count;
    }
}

