/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz;

import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.glozz.GlozzEntropyMeasure;
import fr.unicaen.measure.glozz.GlozzLogger;
import fr.unicaen.measure.glozz.model.EmptyUnit;
import fr.unicaen.measure.glozz.model.UnitaryAlignment;
import fr.unicaen.measure.glozz.model.UnitaryAlignmentSet;
import fr.unicaen.measure.glozz.strategy.alignment.AlignmentComputerSimple;
import fr.unicaen.measure.glozz.strategy.alignment.LinearProgrammingAlignmentComputer;
import fr.unicaen.measure.glozz.strategy.dissimilarity.DissimilarityComputerPositionalSporadic;
import fr.unicaen.measure.glozz.strategy.dissimilarity.IDissimilarityComputer;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.IUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class GlozzEntropyMeasureSpecialPureCat
extends GlozzEntropyMeasure {
    private double[] resultK;
    HashMap<String, Integer> mapCategories;
    private static final boolean computeNumberOfTrueSubAlignments = true;
    private double emptyDelta;
    private IDissimilarityComputer dissimilarityComputer;
    private IDissimilarityComputer dissimilarityWeightComputer;
    private boolean mutualReinforcement;
    private double mutualReinforcementMinCoefficient;
    private ArrayList<String> categories;
    private double threshold;
    private int observerLength;
    private int unitsLength;
    private boolean useCoefUnitLength = true;
    private double entropy;
    private int numberOfPossibleAlignment;
    private int numberOfAlignment;
    private double weightTwoVoidUnits;
    private boolean weightWithEmptyUnits = true;
    public UnitaryAlignmentSet allAlignments;
    private int numberOfTrueSubAlignments = -1;
    private int numberOfFalseSubAlignments = -1;

    @Override
    public int getNumberOfTrueSubAlignments() {
        return this.numberOfTrueSubAlignments;
    }

    @Override
    public int getNumberOfFalseSubAlignments() {
        return this.numberOfFalseSubAlignments;
    }

    @Override
    public void setUseCoefUnitLength(boolean useCoefUnitLength) {
        this.useCoefUnitLength = useCoefUnitLength;
    }

    @Override
    public boolean isWeightWithEmptyUnits() {
        return this.weightWithEmptyUnits;
    }

    @Override
    public void setWeightWithEmptyUnits(boolean weightWithEmptyUnits) {
        this.weightWithEmptyUnits = weightWithEmptyUnits;
    }

    public GlozzEntropyMeasureSpecialPureCat(double emptyDelta, IDissimilarityComputer dissimilarityComputer, boolean mutualReinforcement, double mutualReinforcementMinCoefficient) {
        this.emptyDelta = emptyDelta;
        this.dissimilarityComputer = dissimilarityComputer;
        this.mutualReinforcement = mutualReinforcement;
        this.mutualReinforcementMinCoefficient = mutualReinforcementMinCoefficient;
    }

    public GlozzEntropyMeasureSpecialPureCat(IDissimilarityComputer dissimilarityComputer) {
        this(1.0, dissimilarityComputer, false, 0.5);
    }

    public GlozzEntropyMeasureSpecialPureCat() {
        this(1.0, null, false, 0.5);
    }

    @Override
    public void setDissimilarityComputer(IDissimilarityComputer dissimilarityComputer) {
        this.dissimilarityComputer = dissimilarityComputer;
    }

    @Override
    public double measure(ICorpus corpus) throws MeasureException {
        this.categories = new ArrayList(corpus.getUnitSet().getAnnotationSetByCategory().keySet());
        Collections.sort(this.categories);
        return this.measure(corpus, this.categories);
    }

    public double measure(ICorpus corpus, ArrayList<String> categories) throws MeasureException {
        if (corpus == null) {
            throw new MeasureException("No corpus given !");
        }
        this.observerLength = corpus.getUnitSet().getAnnotationSetByAuthor().keySet().size();
        this.unitsLength = corpus.getUnitSet().getAnnotations().size();
        GlozzLogger.level = -1;
        GlozzLogger.level = -1;
        AlignmentComputerSimple alignmentComputer = new AlignmentComputerSimple(this.getThreshold(), this.mutualReinforcement, this.mutualReinforcementMinCoefficient);
        UnitaryAlignmentSet all = alignmentComputer.getUnitaryAlignmentSet(corpus, this.getDissimilarityComputer());
        this.numberOfPossibleAlignment = all.size();
        GlozzLogger.debug("numberOfPosibleAlignment in GlozzEntropyMeasure=" + this.numberOfPossibleAlignment);
        LinearProgrammingAlignmentComputer nibbler = new LinearProgrammingAlignmentComputer(corpus);
        this.allAlignments = nibbler.calculate(all);
        this.numberOfAlignment = this.allAlignments.size();
        double coeficient = !this.useCoefUnitLength ? (double)(this.unitsLength / this.observerLength) : (double)this.numberOfAlignment;
        if (this.dissimilarityWeightComputer != null) {
            this.entropy = this.computeSpecialForCatLikeCAlphaWithConfidence(this.dissimilarityWeightComputer, this.allAlignments);
            return this.entropy;
        }
        double alignementWeight = this.allAlignments.getWeight();
        this.entropy = alignementWeight / coeficient;
        if (Double.isNaN(this.entropy)) {
            throw new MeasureException("Entropy is NAN !");
        }
        this.numberOfTrueSubAlignments = 0;
        this.numberOfFalseSubAlignments = 0;
        for (UnitaryAlignment a : this.allAlignments) {
            this.numberOfTrueSubAlignments += a.getNumberOfTrueSubAlignments();
            this.numberOfFalseSubAlignments += a.getNumberOfFalseSubAlignments();
        }
        return this.entropy;
    }

    @Override
    public double getEntropy() {
        return this.entropy;
    }

    @Override
    public boolean checkCorpus(ICorpus corpus) {
        return true;
    }

    @Override
    public double getEmptyDelta() {
        return this.emptyDelta;
    }

    @Override
    public void setEmptyDelta(double emptyDelta) {
        this.emptyDelta = emptyDelta;
    }

    @Override
    public double getMutualReinforcementMinCoefficient() {
        return this.mutualReinforcementMinCoefficient;
    }

    @Override
    public void setMutualReinforcementMinCoefficient(double mutualReinforcementMinCoefficient) {
        this.mutualReinforcementMinCoefficient = mutualReinforcementMinCoefficient;
    }

    @Override
    public double getThreshold() {
        return this.threshold;
    }

    @Override
    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    @Override
    public boolean isMutualReinforcement() {
        return this.mutualReinforcement;
    }

    @Override
    public void setMutualReinforcement(boolean mutualReinforcement) {
        this.mutualReinforcement = mutualReinforcement;
    }

    @Override
    public IDissimilarityComputer getDissimilarityComputer() {
        return this.dissimilarityComputer;
    }

    @Override
    public IDissimilarityComputer getDissimilarityWeightComputer() {
        return this.dissimilarityWeightComputer;
    }

    @Override
    public void setDissimilarityWeightComputer(IDissimilarityComputer dissimilarityWeightComputer) {
        this.dissimilarityWeightComputer = dissimilarityWeightComputer;
    }

    @Override
    public int getNumberOfPossibleAlignment() {
        return this.numberOfPossibleAlignment;
    }

    @Override
    public int getNumberOfAlignment() {
        return this.numberOfAlignment;
    }

    private double computeSpecialForCat(IDissimilarityComputer dissimilarityWeightComputer, UnitaryAlignmentSet allAlignments) {
        double total = 0.0;
        int count = 0;
        for (UnitaryAlignment ua : allAlignments) {
            IUnit[] units = ua.getUnits();
            int k = 0;
            for (int i = 0; i < units.length; ++i) {
                IUnit u1 = units[i];
                int j = i + 1;
                while (j < units.length) {
                    IUnit u2 = units[j];
                    double dis = dissimilarityWeightComputer.measure(u1, u2, this.weightTwoVoidUnits);
                    if (dis >= 0.0) {
                        total += dis;
                        ++count;
                    }
                    ++j;
                    ++k;
                }
            }
        }
        System.out.println("total=" + total + " count=" + count);
        if (total == 0.0) {
            return 0.0;
        }
        return total / (double)count;
    }

    private double computeSpecialForCatLikeCAlpha(IDissimilarityComputer dissimilarityWeightComputer, UnitaryAlignmentSet allAlignments) {
        double total = 0.0;
        double totalCoef = 0.0;
        for (UnitaryAlignment ua : allAlignments) {
            IUnit[] units = ua.getUnits();
            int n = 0;
            for (IUnit u : units) {
                if (u == EmptyUnit.getInstance()) continue;
                ++n;
            }
            double coef = n > 1 ? 1.0 / (double)(n - 1) : 0.0;
            int k = 0;
            for (int i = 0; i < units.length; ++i) {
                IUnit u1 = units[i];
                int j = i + 1;
                while (j < units.length) {
                    IUnit u2 = units[j];
                    double dis = dissimilarityWeightComputer.measure(u1, u2, 0.0);
                    if (dis >= 0.0) {
                        total += dis * coef;
                        totalCoef += coef;
                    }
                    ++j;
                    ++k;
                }
            }
        }
        if (total == 0.0) {
            return 0.0;
        }
        return total / totalCoef;
    }

    private double computeSpecialForCatLikeCAlphaWithConfidence(IDissimilarityComputer dissimilarityWeightComputer, UnitaryAlignmentSet allAlignments) {
        System.out.println("+++computeSpecialForCatLikeCAlphaWithConfidence");
        double total = 0.0;
        double totalCoef = 0.0;
        HashMap<String, Integer> mapCategories = new HashMap<String, Integer>();
        this.resultK = new double[this.categories.size()];
        double[] totalK = new double[this.categories.size()];
        double[] weightK = new double[this.categories.size()];
        for (int i = 0; i < this.resultK.length; ++i) {
            this.resultK[i] = 0.0;
            totalK[i] = 0.0;
            weightK[i] = 0.0;
            mapCategories.put(this.categories.get(i), i);
        }
        DissimilarityComputerPositionalSporadic dissimilarityPositional = new DissimilarityComputerPositionalSporadic();
        for (UnitaryAlignment ua : allAlignments) {
            IUnit[] units = ua.getUnits();
            int n = 0;
            for (IUnit u : units) {
                if (u == EmptyUnit.getInstance()) continue;
                ++n;
            }
            double coef = n > 1 ? 1.0 / (double)(n - 1) : 0.0;
            System.out.println(ua);
            System.out.println("coef = " + coef);
            int k = 0;
            for (int i = 0; i < units.length; ++i) {
                IUnit u1 = units[i];
                int j = i + 1;
                while (j < units.length) {
                    IUnit u2 = units[j];
                    System.out.println(u1 + " --- " + u2);
                    double dis = dissimilarityWeightComputer.measure(u1, u2, this.weightTwoVoidUnits);
                    double disPos = dissimilarityPositional.measure(u1, u2, 0.0);
                    double coefPos = Math.max(0.0, 1.0 - disPos);
                    double coefBis = coef * coefPos;
                    System.out.println("disCat = " + dis);
                    if (dis >= 0.0) {
                        total += dis * coefBis;
                        totalCoef += coefBis;
                        int n2 = (Integer)mapCategories.get(u1.getCategory());
                        totalK[n2] = totalK[n2] + dis * coefBis;
                        int n3 = (Integer)mapCategories.get(u1.getCategory());
                        weightK[n3] = weightK[n3] + coefBis;
                        int n4 = (Integer)mapCategories.get(u2.getCategory());
                        totalK[n4] = totalK[n4] + dis * coefBis;
                        int n5 = (Integer)mapCategories.get(u2.getCategory());
                        weightK[n5] = weightK[n5] + coefBis;
                    }
                    ++j;
                    ++k;
                }
            }
        }
        for (String cat : this.categories) {
            int i = (Integer)mapCategories.get(cat);
            if (weightK[i] == 0.0) {
                this.resultK[i] = Double.NaN;
                continue;
            }
            if (totalK[i] == 0.0) {
                this.resultK[i] = 0.0;
                continue;
            }
            this.resultK[i] = totalK[i] / weightK[i];
        }
        if (totalCoef == 0.0) {
            return Double.NaN;
        }
        if (total == 0.0) {
            return 0.0;
        }
        return total / totalCoef;
    }

    public double[] getResultK() {
        return this.resultK;
    }
}

