/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.glozz;

import fr.unicaen.measure.core.IMeasure;
import fr.unicaen.measure.core.MeasureException;
import fr.unicaen.measure.glozz.GlozzConstants;
import fr.unicaen.measure.glozz.GlozzLogger;
import fr.unicaen.measure.glozz.model.UnitaryAlignment;
import fr.unicaen.measure.glozz.model.UnitaryAlignmentSet;
import fr.unicaen.measure.glozz.strategy.alignment.AlignmentComputerSimple;
import fr.unicaen.measure.glozz.strategy.alignment.LinearProgrammingAlignmentComputer;
import fr.unicaen.measure.glozz.strategy.dissimilarity.IDissimilarityComputer;
import fr.unicaen.measure.model.ICorpus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GlozzEntropyMeasure
implements IMeasure,
GlozzConstants {
    protected static final boolean computeNumberOfTrueSubAlignments = true;
    protected double emptyDelta;
    protected IDissimilarityComputer dissimilarityComputer;
    protected IDissimilarityComputer dissimilarityWeightComputer;
    protected boolean mutualReinforcement;
    protected double mutualReinforcementMinCoefficient;
    protected List<String> categories;
    protected double threshold;
    protected int observerLength;
    protected int unitsLength;
    protected boolean useCoefUnitLength = false;
    protected double entropy;
    protected int numberOfPossibleAlignment;
    protected int numberOfAlignment;
    protected double weightTwoVoidUnits;
    protected boolean weightWithEmptyUnits = true;
    public UnitaryAlignmentSet allAlignments;
    protected int numberOfTrueSubAlignments = -1;
    protected int numberOfFalseSubAlignments = -1;

    public int getNumberOfTrueSubAlignments() {
        return this.numberOfTrueSubAlignments;
    }

    public int getNumberOfFalseSubAlignments() {
        return this.numberOfFalseSubAlignments;
    }

    public void setUseCoefUnitLength(boolean useCoefUnitLength) {
        this.useCoefUnitLength = useCoefUnitLength;
    }

    public boolean isWeightWithEmptyUnits() {
        return this.weightWithEmptyUnits;
    }

    public void setWeightWithEmptyUnits(boolean weightWithEmptyUnits) {
        this.weightWithEmptyUnits = weightWithEmptyUnits;
    }

    public GlozzEntropyMeasure(double emptyDelta, IDissimilarityComputer dissimilarityComputer, boolean mutualReinforcement, double mutualReinforcementMinCoefficient) {
        this.emptyDelta = emptyDelta;
        this.dissimilarityComputer = dissimilarityComputer;
        this.mutualReinforcement = mutualReinforcement;
        this.mutualReinforcementMinCoefficient = mutualReinforcementMinCoefficient;
    }

    public GlozzEntropyMeasure(IDissimilarityComputer dissimilarityComputer) {
        this(1.0, dissimilarityComputer, false, 0.5);
    }

    public GlozzEntropyMeasure() {
        this(1.0, null, false, 0.5);
    }

    public void setDissimilarityComputer(IDissimilarityComputer dissimilarityComputer) {
        this.dissimilarityComputer = dissimilarityComputer;
    }

    public double measure(ICorpus corpus) throws MeasureException {
        double coeficient;
        if (corpus == null) {
            throw new MeasureException("No corpus given !");
        }
        this.observerLength = corpus.getUnitSet().getAnnotationSetByAuthor().keySet().size();
        this.categories = new ArrayList(corpus.getUnitSet().getAnnotationSetByCategory().keySet());
        this.unitsLength = corpus.getUnitSet().getAnnotations().size();
        this.threshold = 1.0 * (double)this.observerLength;
        Collections.sort(this.categories);
        GlozzLogger.level = 4;
        GlozzLogger.debug("Corpus loaded : ");
        GlozzLogger.debug(" + observers : " + this.observerLength);
        GlozzLogger.debug(" + categories : " + this.categories.size() + " " + this.categories);
        GlozzLogger.debug(" + empty delta value : " + this.emptyDelta);
        GlozzLogger.debug(" + mutual reinforcement : " + this.mutualReinforcement);
        GlozzLogger.debug(" + threshold : " + this.threshold);
        GlozzLogger.debug(" + dissimilarity computer : " + this.dissimilarityComputer);
        GlozzLogger.debug(" + units : " + this.unitsLength);
        GlozzLogger.level = 4;
        AlignmentComputerSimple alignmentComputer = new AlignmentComputerSimple(this.getThreshold(), this.mutualReinforcement, this.mutualReinforcementMinCoefficient);
        UnitaryAlignmentSet all = alignmentComputer.getUnitaryAlignmentSet(corpus, this.getDissimilarityComputer());
        this.numberOfPossibleAlignment = all.size();
        GlozzLogger.debug("numberOfPosibleAlignment in GlozzEntropyMeasure=" + this.numberOfPossibleAlignment);
        System.out.println("avant alignement:");
        all.sortByWeight();
        System.out.println(all);
        LinearProgrammingAlignmentComputer possibleProvider = new LinearProgrammingAlignmentComputer(corpus);
        UnitaryAlignmentSet best = possibleProvider.calculate(all);
        System.out.println("apr\u00e8s alignement:");
        best.sortByWeight();
        System.out.println(best);
        double meanNumberOfUnits = corpus.getUnitSet().getAnnotations().size() / corpus.getUnitSet().getAnnotationSetByAuthor().keySet().size();
        this.allAlignments = best;
        this.numberOfAlignment = this.allAlignments.size();
        if (!this.useCoefUnitLength) {
            coeficient = (double)this.unitsLength / (double)this.observerLength;
            System.out.println("Use mean number of units : " + coeficient);
        } else {
            System.out.println("Use number of alignment : " + this.numberOfAlignment);
            coeficient = this.numberOfAlignment;
        }
        double alignementWeight = this.dissimilarityWeightComputer == null ? this.allAlignments.getWeight() : this.allAlignments.getWeight(this.dissimilarityWeightComputer, this.weightTwoVoidUnits, true);
        this.entropy = alignementWeight / coeficient;
        GlozzLogger.prod("AlignmentWeight=" + alignementWeight + " Coef=" + coeficient + " - Entropy = " + this.entropy);
        if (Double.isNaN(this.entropy)) {
            throw new MeasureException("Entropy is NAN !");
        }
        this.numberOfTrueSubAlignments = 0;
        this.numberOfFalseSubAlignments = 0;
        for (UnitaryAlignment a : this.allAlignments) {
            this.numberOfTrueSubAlignments += a.getNumberOfTrueSubAlignments();
            this.numberOfFalseSubAlignments += a.getNumberOfFalseSubAlignments();
        }
        return this.entropy;
    }

    public double getEntropy() {
        return this.entropy;
    }

    public boolean checkCorpus(ICorpus corpus) {
        return true;
    }

    public double getEmptyDelta() {
        return this.emptyDelta;
    }

    public void setEmptyDelta(double emptyDelta) {
        this.emptyDelta = emptyDelta;
    }

    public double getMutualReinforcementMinCoefficient() {
        return this.mutualReinforcementMinCoefficient;
    }

    public void setMutualReinforcementMinCoefficient(double mutualReinforcementMinCoefficient) {
        this.mutualReinforcementMinCoefficient = mutualReinforcementMinCoefficient;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public boolean isMutualReinforcement() {
        return this.mutualReinforcement;
    }

    public void setMutualReinforcement(boolean mutualReinforcement) {
        this.mutualReinforcement = mutualReinforcement;
    }

    public IDissimilarityComputer getDissimilarityComputer() {
        return this.dissimilarityComputer;
    }

    public IDissimilarityComputer getDissimilarityWeightComputer() {
        return this.dissimilarityWeightComputer;
    }

    public void setDissimilarityWeightComputer(IDissimilarityComputer dissimilarityWeightComputer) {
        this.dissimilarityWeightComputer = dissimilarityWeightComputer;
    }

    public int getNumberOfPossibleAlignment() {
        return this.numberOfPossibleAlignment;
    }

    public int getNumberOfAlignment() {
        return this.numberOfAlignment;
    }
}

