/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.utils;

import fr.unicaen.measure.model.AnnotationSetImpl;
import fr.unicaen.measure.model.CorpusImpl;
import fr.unicaen.measure.model.IAnnotationSet;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.IUnit;
import fr.unicaen.measure.model.UnitImpl;
import fr.unicaen.measure.utils.CSVToAnnotationSetAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class CorpusUtil {
    public static final int AUTO_TEXT_SIZE = 1;

    public static ICorpus loadFromRichterFile(File richterFile) throws FileNotFoundException, IOException {
        return CorpusUtil.loadFromRichterFile(richterFile, 1, 0);
    }

    public static ICorpus loadFromRichterFile(File richterFile, int textType) throws FileNotFoundException, IOException {
        return CorpusUtil.loadFromRichterFile(richterFile, 1, textType);
    }

    public static ICorpus loadFromPrededinedUnitsFile(File prededinedFile) throws FileNotFoundException, IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(prededinedFile));
        AnnotationSetImpl<IUnit> set = new AnnotationSetImpl<IUnit>();
        int unitIndex = 0;
        String[] coders = reader.readLine().split(",");
        while ((line = reader.readLine()) != null) {
            String[] content = line.split(",");
            for (int i = 0; i < content.length; ++i) {
                String current = content[i].trim();
                if (current.isEmpty()) continue;
                UnitImpl unit = new UnitImpl(coders[i], content[i], unitIndex, unitIndex + 1);
                unit.setId(coders[i] + "_" + unitIndex);
                set.addAnnotation(unit);
            }
            ++unitIndex;
        }
        CorpusImpl c = new CorpusImpl(unitIndex, set, 0);
        return c;
    }

    public static ICorpus loadFromRichterFile(File richterFile, int textSize, int textType) throws FileNotFoundException, IOException {
        BufferedReader reader = new BufferedReader(new FileReader(richterFile));
        String firstLine = reader.readLine();
        int n = firstLine.split(",").length;
        if (textSize == 1) {
            try {
                firstLine = firstLine.split(",")[0];
                int i = firstLine.indexOf("length=");
                if (i >= 0) {
                    firstLine = firstLine.replace("length=", "");
                    textSize = Integer.parseInt(firstLine);
                    System.out.println("found size=" + textSize);
                }
            }
            catch (NumberFormatException e) {
                textSize = 1;
            }
        }
        CorpusImpl c = new CorpusImpl(textSize, textType);
        c.getUnitSet().addAnnotationsFrom(CorpusUtil.getAnnotationsFromRichterFile(richterFile, n));
        if (textSize == 1) {
            int lastEndUnit = 0;
            for (IUnit u : c.getUnitSet().getAnnotations()) {
                lastEndUnit = Math.max(lastEndUnit, u.getEndIndex());
            }
            c.setTextSize(lastEndUnit);
        }
        System.out.println("___________________________text size=" + c.getTextSize() + " firstLine=" + firstLine);
        return c;
    }

    public static IAnnotationSet<IUnit> getAnnotationsFromRichterFile(File corpusFile, int numberOfColumns) throws FileNotFoundException, IOException {
        CSVToAnnotationSetAdapter adapter = new CSVToAnnotationSetAdapter(corpusFile.getAbsolutePath(), numberOfColumns == 4);
        return adapter.convert();
    }
}

