/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.utils;

import fr.unicaen.measure.model.AnnotationSetImpl;
import fr.unicaen.measure.model.IAnnotationSet;
import fr.unicaen.measure.model.IUnit;
import fr.unicaen.measure.model.UnitImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.supercsv.cellprocessor.Optional;
import org.supercsv.cellprocessor.ParseInt;
import org.supercsv.cellprocessor.constraint.NotNull;
import org.supercsv.cellprocessor.constraint.UniqueHashCode;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.CsvMapReader;
import org.supercsv.prefs.CsvPreference;

public class CSVToAnnotationSetAdapter {
    private String csvFilePath;
    private boolean simplified;
    public final String ID = "id";
    public final String OBSERVER = "observer";
    public final String CATEGORY = "category";
    public final String FEATURE = "feature";
    public final String START = "start";
    public final String END = "end";
    public final String[] headers = new String[]{"id", "observer", "category", "feature", "start", "end"};
    public final String[] simplifiedHeaders = new String[]{"observer", "category", "start", "end"};
    public final int DEFAULT_NUMBER_OF_COLUMNS = this.headers.length;

    public static CellProcessor[] getProcessors(boolean simplified) {
        if (simplified) {
            return new CellProcessor[]{new NotNull(), new NotNull(), new ParseInt(), new ParseInt()};
        }
        return new CellProcessor[]{new UniqueHashCode(), new NotNull(), new NotNull(), new Optional(), new ParseInt(), new ParseInt()};
    }

    public CSVToAnnotationSetAdapter(String csvFilePath) {
        this(csvFilePath, false);
    }

    public CSVToAnnotationSetAdapter(String csvFilePath, boolean simplified) {
        this.csvFilePath = csvFilePath;
        this.simplified = simplified;
    }

    protected File getCSV() {
        return new File(this.csvFilePath);
    }

    public IAnnotationSet<IUnit> convert() throws FileNotFoundException, IOException {
        Map datas;
        String[] relevantHeaders;
        int id = 0;
        CsvMapReader reader = new CsvMapReader((Reader)new FileReader(this.getCSV()), CsvPreference.STANDARD_PREFERENCE);
        AnnotationSetImpl<IUnit> set = new AnnotationSetImpl<IUnit>();
        CellProcessor[] processor = CSVToAnnotationSetAdapter.getProcessors(this.simplified);
        String[] stringArray = relevantHeaders = this.simplified ? this.simplifiedHeaders : this.headers;
        while ((datas = reader.read(relevantHeaders, processor)) != null) {
            if (((String)datas.get("observer")).contains("length=")) {
                System.out.println("continue...");
                continue;
            }
            UnitImpl unit = new UnitImpl((String)datas.get("observer"), (String)datas.get("category"), Integer.parseInt(datas.get("start").toString()), Integer.parseInt(datas.get("end").toString()));
            unit.setId("ID_" + ++id);
            set.addAnnotation(unit);
        }
        reader.close();
        return set;
    }
}

