/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.test;

import fr.unicaen.measure.model.IAnnotationSet;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.IUnit;
import java.util.Iterator;
import java.util.Map;

public class PrintAnnotationConsole {
    public static String drawCorpus(ICorpus c) {
        String out = " --- Corpus visual (size = " + c.getTextSize() + ") ---------------------- \n";
        Map<String, IAnnotationSet<IUnit>> byAuthor = c.getUnitSet().getAnnotationSetByAuthor();
        for (int i = 0; i < c.getTextSize(); ++i) {
            out = out + (i % 5 == 0 ? (char)'|' : '.');
        }
        out = out + "\n";
        for (String author : byAuthor.keySet()) {
            Iterator<IUnit> iu = byAuthor.get(author).getAnnotations().iterator();
            int caret = 0;
            for (IUnit u : byAuthor.get(author).getAnnotations()) {
                if (u.getStartIndex() > caret) {
                    out = out + PrintAnnotationConsole.addChar('.', u.getStartIndex() - caret);
                }
                out = out + PrintAnnotationConsole.addChar('|', u.getEndIndex() - u.getStartIndex());
                caret = u.getEndIndex();
            }
            if (caret < c.getTextSize()) {
                out = out + PrintAnnotationConsole.addChar('.', c.getTextSize() - caret);
            }
            out = out + "\t" + author + "\n";
        }
        out = out + " ------------------------------------------------------ \n";
        return out;
    }

    private static String addChar(char c, int nbr) {
        String out = "";
        for (int i = 0; i < nbr; ++i) {
            out = out + c;
        }
        return out;
    }
}

