/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.model;

import fr.unicaen.measure.model.AnnotationSetImpl;
import fr.unicaen.measure.model.CorpusIterator;
import fr.unicaen.measure.model.IAnnotation;
import fr.unicaen.measure.model.IAnnotationSet;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.IUnit;
import java.util.Iterator;

public class CorpusImpl
implements ICorpus {
    public static String[] TYPE_TO_STRING = new String[]{"REGULAR", "SEGMENTATION"};
    private int corpusType;
    private int textSize;
    private IAnnotationSet<IUnit> unitSet;

    public CorpusImpl(int textSize, int corpusType) {
        this(textSize, new AnnotationSetImpl<IUnit>(), corpusType);
    }

    public CorpusImpl(int textSize, IAnnotationSet<IUnit> us, int corpusType) {
        this.textSize = textSize;
        this.unitSet = us;
        this.corpusType = corpusType;
    }

    @Override
    public ICorpus clone() {
        IAnnotationSet<IUnit> uClone = this.unitSet.clone();
        CorpusImpl c = new CorpusImpl(this.textSize, this.corpusType);
        c.setUnitSet(uClone);
        return c;
    }

    @Override
    public int getTextSize() {
        return this.textSize;
    }

    @Override
    public void setTextSize(int textSize) {
        this.textSize = textSize;
    }

    @Override
    public IAnnotationSet<IUnit> getUnitSet() {
        return this.unitSet;
    }

    public void setUnitSet(IAnnotationSet<IUnit> unitSet) {
        this.unitSet = unitSet;
    }

    @Override
    public int getCorpusType() {
        return this.corpusType;
    }

    @Override
    public void setCorpusType(int corpusType) {
        this.corpusType = corpusType;
    }

    public String toString() {
        String s = "#" + TYPE_TO_STRING[this.corpusType] + "\n";
        s = s + "#nb_characters:" + this.textSize + "\n";
        s = s + "#UNITS\n";
        s = s + this.unitSet.toString();
        return s;
    }

    public Iterator<IAnnotation> iterator() {
        return new CorpusIterator(this);
    }

    public void addAnnotation(IAnnotation a) {
        if (a instanceof IUnit) {
            this.unitSet.addAnnotation((IUnit)a);
        }
    }
}

