/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.model;

import fr.unicaen.measure.model.IAnnotation;
import fr.unicaen.measure.model.IAnnotationSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnnotationSetImpl<E extends IAnnotation>
implements IAnnotationSet<E> {
    private static final int BY_AUTHOR = 1;
    private static final int BY_CATEGORY = 2;
    private ArrayList<E> annotations = new ArrayList();

    @Override
    public IAnnotationSet<E> clone() {
        AnnotationSetImpl<E> clone = new AnnotationSetImpl<E>();
        List<IAnnotation> listClone = clone.getAnnotations();
        for (IAnnotation e : this.annotations) {
            listClone.add(e.clone());
        }
        return clone;
    }

    @Override
    public void addAnnotation(E e) {
        this.annotations.add(e);
    }

    @Override
    public List<E> getAnnotations() {
        return this.annotations;
    }

    public String toString() {
        String toReturn = "";
        for (IAnnotation e : this.annotations) {
            toReturn = toReturn + e.toString() + "\n";
        }
        return toReturn;
    }

    @Override
    public void addAnnotationsFrom(IAnnotationSet<E> annotationSet) {
        for (IAnnotation annotation : annotationSet.getAnnotations()) {
            this.annotations.add(annotation);
        }
    }

    @Override
    public Map<String, IAnnotationSet<E>> getAnnotationSetByCategory() {
        return this.getAnnotationSetBy(2);
    }

    @Override
    public Map<String, IAnnotationSet<E>> getAnnotationSetByAuthor() {
        return this.getAnnotationSetBy(1);
    }

    protected Map<String, IAnnotationSet<E>> getAnnotationSetBy(int sortBy) {
        HashMap<String, IAnnotationSet<E>> map = new HashMap<String, IAnnotationSet<E>>();
        for (IAnnotation annotation : this.annotations) {
            String sorter;
            String string = sorter = sortBy == 1 ? annotation.getAuthor() : annotation.getCategory();
            if (!map.containsKey(sorter)) {
                map.put(sorter, new AnnotationSetImpl<E>());
            }
            ((IAnnotationSet)map.get(sorter)).addAnnotation(annotation);
        }
        return map;
    }
}

