/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.model;

import fr.unicaen.measure.model.IAnnotation;
import java.util.Date;
import java.util.HashMap;

public abstract class AnnotationImpl
implements IAnnotation {
    protected String id;
    protected String author;
    protected String category;
    protected HashMap<String, String> featureSet;
    private static long lastDate = 0L;

    public AnnotationImpl(String id, String author, String category, HashMap<String, String> featureSet) {
        this.id = id;
        this.author = author;
        this.category = category;
        this.featureSet = featureSet;
    }

    public AnnotationImpl(String author, String category, HashMap<String, String> featureSet) {
        this("", author, category, featureSet);
        long d = new Date().getTime();
        if (d <= lastDate) {
            d = lastDate + 1L;
        }
        lastDate = d;
        this.id = author + "_" + d;
    }

    public AnnotationImpl(String author, String category) {
        this(author, category, new HashMap<String, String>());
    }

    @Override
    public abstract IAnnotation clone();

    protected void setAsClone(IAnnotation a) {
        this.id = a.getId();
        this.author = a.getAuthor();
        this.category = a.getCategory();
        this.featureSet = (HashMap)a.getFeatureSet().clone();
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public void setAuthor(String author) {
        this.id = this.id.replaceFirst(this.author, author);
        this.author = author;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public HashMap<String, String> getFeatureSet() {
        return this.featureSet;
    }

    public void setFeatureSet(HashMap<String, String> featureSet) {
        this.featureSet = featureSet;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String toString() {
        return this.id + "," + this.author + "," + this.category + "," + this.featureSetToString();
    }

    private String featureSetToString() {
        String toReturn = "";
        return toReturn;
    }

    public void setFeatureSetFromString(String fsString) {
        String[] feature;
        this.featureSet.clear();
        if (fsString == null || fsString.length() == 0) {
            return;
        }
        for (String s : feature = fsString.split("\\.\\.")) {
            String[] fs = s.split(":");
            String name = fs[0];
            String value = fs[1];
            this.featureSet.put(name, value);
        }
    }
}

