/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.gui.views;

import com.jacksay.sgarnish.assets.JckIconProvider;
import fr.unicaen.measure.model.IAnnotationSet;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.IUnit;
import fr.unicaen.measure.sufflingplugin.ICorpusListenner;
import fr.unicaen.measure.sufflingplugin.ICorpusObservable;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class STCorpusViewPreview2
extends JPanel
implements ICorpusListenner,
MouseMotionListener,
MouseListener,
AncestorListener {
    public static final int VIEW_MODE_PREVIEW = 0;
    public static final int VIEW_MODE_EDITION = 1;
    private int viewMode = 0;
    private static final int MIN_POINT_WIDTH = 4;
    private static final int MIN_POINT_HEIGHT = 4;
    private static final int MAX_POINT_WIDTH = 40;
    private static final int MAX_POINT_HEIGHT = 80;
    private int pointWidth = 4;
    private int pointHeight = 20;
    private int leftCorpus = 0;
    private int rightCorpus = 0;
    protected ICorpusObservable corpus;
    private int widthScale;
    private int heightScale;
    private Map<String, List<DrawedUnit2D>> drawedUnit;
    private ArrayList<Rectangle2D> over;
    private ArrayList<Rectangle2D> selected;
    private static int categoryColorIndex = 0;
    private static Map<String, Color> colors = new HashMap<String, Color>();
    private boolean modelHasBeenEdited = false;
    private Map<Rectangle2D, String> annotatorRect;
    public Font fontAnnotatorLabel = new Font("Arial", 1, 12);
    public Color colorAnnotatorLabel = Color.GRAY;
    public List<String> annotators;
    private boolean editable = false;
    public List<String> categories;
    public Font fontUnitInfosLabel = new Font("Arial", 0, 10);
    public Color colorUnitInfosLabel = Color.BLACK;
    Color colorOver = new Color(0, 170, 68);
    BasicStroke lineStyleBase = new BasicStroke(1.0f);
    BasicStroke lineStyleOver = new BasicStroke(2.0f);
    DrawedUnit2D unitMove;
    private static final int MOUSE_NONE = 0;
    private static final int MOUSE_DRAG_VIEW = 1;
    private static final int MOUSE_OVER_UNIT = 2;
    private static final int MOUSE_MOVE_UNIT = 3;
    private static final int MOUSE_MOVE_BOUND_UNIT = 4;
    private int mouseAction = 0;
    private JPopupMenu unitMenu = new JPopupMenu("example");
    private Point mouseDragStart = null;
    public DrawedUnit2D active = null;
    public static final int DRAG_MOVE_ALL = 0;
    public static final int DRAG_MOVE_START = 1;
    public static final int DRAG_MOVE_END = 2;
    public static final int DRAG_DRAW = 3;
    public int dragMode = 0;

    public static Color generateColor() {
        Color c = Color.BLACK;
        int[] rgb = new int[3];
        ArrayList<Integer> availabled = new ArrayList<Integer>();
        availabled.add(42);
        availabled.add(84);
        availabled.add(136);
        availabled.add(170);
        availabled.add(212);
        for (int i = 0; i < 3; ++i) {
            int index = (int)(Math.random() * (double)availabled.size());
            rgb[i] = (Integer)availabled.get(index);
            availabled.remove(index);
        }
        return new Color(rgb[0], rgb[1], rgb[2], 150);
    }

    public static Color getCategoryColor(String category) {
        if (!colors.containsKey(category)) {
            colors.put(category, STCorpusViewPreview2.generateColor());
        }
        return colors.get(category);
    }

    public STCorpusViewPreview2(ICorpusObservable corpus) {
        this(corpus, false);
    }

    public STCorpusViewPreview2(ICorpusObservable corpus, boolean editable) {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.over = new ArrayList();
        this.selected = new ArrayList();
        this.editable = editable;
        this.drawedUnit = new HashMap<String, List<DrawedUnit2D>>();
        this.corpus = corpus;
        this.scaleConfig();
        this.widthScale = 4;
        this.heightScale = 20;
        corpus.addCorpusListener((ICorpusListenner)this);
        this.addAncestorListener(this);
        this.addMouseListener(this);
    }

    public void onCorpusChanged(ICorpus corpus) {
        this.drawedUnit = new HashMap<String, List<DrawedUnit2D>>();
        if (corpus == null) {
            return;
        }
        if (this.drawedUnit == null) {
            this.drawedUnit = new HashMap<String, List<DrawedUnit2D>>();
        }
        if (this.annotatorRect == null) {
            this.annotatorRect = new HashMap<Rectangle2D, String>();
        }
        this.annotators = new ArrayList(corpus.getUnitSet().getAnnotationSetByAuthor().keySet());
        this.categories = new ArrayList(corpus.getUnitSet().getAnnotationSetByCategory().keySet());
        for (Map.Entry ann : corpus.getUnitSet().getAnnotationSetByAuthor().entrySet()) {
            List<Object> unitAnnotator;
            IAnnotationSet setByAnnotators = (IAnnotationSet)ann.getValue();
            String annotatorName = (String)ann.getKey();
            if (!this.drawedUnit.containsKey(annotatorName)) {
                unitAnnotator = new ArrayList();
                this.drawedUnit.put(annotatorName, unitAnnotator);
            } else {
                unitAnnotator = this.drawedUnit.get(annotatorName);
            }
            for (IUnit u : setByAnnotators.getAnnotations()) {
                DrawedUnit2D rect = null;
                for (DrawedUnit2D drawedUnit2D : unitAnnotator) {
                    if (drawedUnit2D.unit != u) continue;
                    rect = drawedUnit2D;
                }
                if (rect != null) continue;
                rect = new DrawedUnit2D(0.0, 0.0, 0.0, 0.0, u);
                unitAnnotator.add(rect);
            }
        }
        this.repaint();
    }

    public void changeScale(int x, int y) {
        int n = x < 4 ? 4 : (this.widthScale = x > 40 ? 40 : x);
        this.heightScale = y < 4 ? 4 : (y > 80 ? 80 : y);
        this.repaint();
    }

    protected void drawAfter(Graphics2D g) {
    }

    @Override
    protected void paintComponent(Graphics gr) {
        super.paintComponent(gr);
        Graphics2D g = (Graphics2D)gr;
        if (this.corpus == null || this.corpus.getCorpus() == null) {
            return;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int yAxis = 0;
        int lineNum = 0;
        int padding = 12;
        g.setColor(Color.LIGHT_GRAY);
        Map annotationsByObservers = this.corpus.getCorpus().getUnitSet().getAnnotationSetByAuthor();
        ArrayList observers = new ArrayList(annotationsByObservers.keySet());
        for (String annotatorName : observers) {
            int baseY = lineNum * (padding + (int)((double)this.heightScale * 1.5));
            g.setColor(this.colorAnnotatorLabel);
            g.setFont(this.fontAnnotatorLabel);
            g.drawString(annotatorName, 0, padding + baseY);
            g.setColor(Color.lightGray);
            g.fillRect(0, padding + baseY, this.getWidth(), (int)((double)this.heightScale * 1.5));
            g.setColor(Color.GRAY);
            g.setStroke(new BasicStroke(1.0f));
            int yLine = baseY + padding + (int)((double)this.heightScale * 0.75);
            int i = 0;
            int j = 0;
            while (i < this.getWidth()) {
                g.setColor(Color.white);
                int size = (int)((double)this.heightScale * 0.67);
                size = (int)((double)size * (j % 5 == 0 ? 1.0 : 0.5));
                g.drawLine(i, yLine - size, i, yLine + size);
                i += this.widthScale;
                ++j;
            }
            g.drawLine(0, yLine, this.getWidth(), yLine);
            g.setColor(Color.DARK_GRAY);
            for (DrawedUnit2D r : this.drawedUnit.get(annotatorName)) {
                r.draw(g, this.widthScale, this.heightScale, baseY + padding);
            }
            ++yAxis;
            ++lineNum;
        }
        this.drawAfter(g);
    }

    public DrawedUnit2D getDrawedUnitById(String id) {
        for (String s : this.drawedUnit.keySet()) {
            for (DrawedUnit2D u : this.drawedUnit.get(s)) {
                if (!u.unit.getId().equals(id)) continue;
                return u;
            }
        }
        return null;
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (this.mouseAction == 1) {
            System.out.println("D\u00e9placement vue");
        }
    }

    protected List<DrawedUnit2D> interactWith(MouseEvent me) {
        return this.interactWith(me.getX(), me.getY());
    }

    protected List<DrawedUnit2D> interactWith(int x, int y) {
        ArrayList<DrawedUnit2D> interact = new ArrayList<DrawedUnit2D>();
        for (List<DrawedUnit2D> byAnn : this.drawedUnit.values()) {
            for (DrawedUnit2D r : byAnn) {
                if (!r.contains(x, y)) continue;
                interact.add(r);
            }
        }
        return interact;
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        switch (this.mouseAction) {
            case 1: {
                System.out.println("Move view");
            }
        }
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (me.getButton() == 1) {
            for (DrawedUnit2D d : this.interactWith(me.getX(), me.getY())) {
                System.out.println(d);
                d.setSelected(!d.isSelected());
            }
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (this.mouseAction != 2 && this.mouseAction == 0) {
            this.mouseAction = 1;
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        System.out.println("Release");
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.mouseAction = 0;
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        System.out.println("MouseEntered : " + me);
        this.addMouseMotionListener(this);
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.removeMouseMotionListener(this);
    }

    private JPopupMenu buildUnitMenu(DrawedUnit2D unit2d) {
        JPopupMenu menu = new JPopupMenu();
        final DrawedUnit2D unit = unit2d;
        JMenuItem item = new JMenuItem(new AbstractAction("Supprimer", JckIconProvider.getIcon((String)"delete")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                System.out.println(unit.unit);
                STCorpusViewPreview2.this.corpus.getCorpus().getUnitSet().getAnnotations().remove(unit.unit);
                ((List)STCorpusViewPreview2.this.drawedUnit.get(unit.unit.getAuthor())).remove(unit);
                STCorpusViewPreview2.this.corpus.fireCorpusChange();
                STCorpusViewPreview2.this.repaint();
            }
        });
        menu.add(item);
        JMenu subMenu = new JMenu("Categories");
        menu.add(subMenu);
        subMenu.setIcon(JckIconProvider.getIcon((String)"three_tags"));
        for (String s : this.categories) {
            JRadioButtonMenuItem cat = new JRadioButtonMenuItem(s);
            subMenu.add(cat);
            cat.setBackground(STCorpusViewPreview2.getCategoryColor(s));
            cat.setName(s);
            cat.setActionCommand(s);
            if (s.equals(unit.unit.getCategory())) {
                cat.setSelected(true);
            }
            cat.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    System.out.print("NAME = " + ae.getActionCommand());
                    unit.unit.setCategory(ae.getActionCommand());
                    STCorpusViewPreview2.this.corpus.fireCorpusChange();
                    STCorpusViewPreview2.this.repaint();
                }
            });
        }
        return menu;
    }

    private void unitInteraction(MouseEvent me, DrawedUnit2D active) {
        int mouseRelative = (int)((double)me.getX() - active.getX());
        double sensibility = 0.1;
        if ((double)mouseRelative < active.getWidth() * sensibility) {
            this.dragMode = 1;
            this.setCursor(Cursor.getPredefinedCursor(10));
        } else if ((double)mouseRelative > active.getWidth() * (1.0 - sensibility)) {
            this.dragMode = 2;
            this.setCursor(Cursor.getPredefinedCursor(11));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(13));
            this.dragMode = 0;
        }
    }

    private void scaleConfig() {
        System.out.println("Panel width : " + this.getWidth());
        System.out.println("Panel height : " + this.getHeight());
    }

    @Override
    public void ancestorAdded(AncestorEvent ae) {
        this.scaleConfig();
    }

    @Override
    public void ancestorRemoved(AncestorEvent ae) {
        System.out.println("ancestorRemoved");
    }

    @Override
    public void ancestorMoved(AncestorEvent ae) {
    }

    public class DrawedUnit2D
    extends Rectangle2D.Double {
        private IUnit unit;
        private Color colorStandard;
        private boolean selected;
        private boolean over;

        public DrawedUnit2D(double x, double y, double w, double h, IUnit unit) {
            super(x, y, w, h);
            this.selected = false;
            this.over = false;
            this.unit = unit;
        }

        public void draw(Graphics2D g, int scaleWidth, int scaleHeight, int y) {
            BasicStroke lineStyle;
            Color line;
            Color fill;
            this.colorStandard = STCorpusViewPreview2.getCategoryColor(this.unit.getCategory());
            this.setRect(this.unit.getStartIndex() * scaleWidth, (double)y + (double)STCorpusViewPreview2.this.heightScale * 0.25, this.unit.getEndIndex() * scaleWidth - this.unit.getStartIndex() * scaleWidth, STCorpusViewPreview2.this.heightScale);
            if (this.over) {
                fill = this.colorStandard.brighter();
                line = this.selected ? this.colorStandard.darker().darker() : this.colorStandard.brighter();
                lineStyle = this.selected ? STCorpusViewPreview2.this.lineStyleOver : STCorpusViewPreview2.this.lineStyleBase;
            } else {
                fill = this.selected ? this.colorStandard.brighter() : this.colorStandard;
                line = this.selected ? this.colorStandard.darker().darker() : this.colorStandard.darker();
                lineStyle = this.selected ? STCorpusViewPreview2.this.lineStyleOver : STCorpusViewPreview2.this.lineStyleBase;
            }
            g.setColor(fill);
            g.fill(this);
            g.setColor(line);
            g.setStroke(lineStyle);
            g.draw(this);
            if (this.over || this.selected) {
                g.setColor(STCorpusViewPreview2.this.colorUnitInfosLabel);
                g.setFont(STCorpusViewPreview2.this.fontUnitInfosLabel);
                FontMetrics metrics = g.getFontMetrics(STCorpusViewPreview2.this.fontUnitInfosLabel);
                String x = "" + this.unit.getStartIndex();
                String ny = "" + this.unit.getEndIndex();
                String textCat = this.unit.getId();
                int textHeight = metrics.getHeight();
                int widthX = metrics.stringWidth(x);
                int widthY = metrics.stringWidth(ny);
                int widthCat = metrics.stringWidth(textCat);
                if (this.getWidth() > (double)(widthX + widthY + widthCat)) {
                    g.drawString(textCat, (int)(this.getX() + (this.getWidth() - (double)widthCat) / 2.0), (int)this.getY() + textHeight);
                }
                g.drawString(x, (int)this.getX() + 2, (int)this.getY() + textHeight);
                g.drawString(ny, (int)(this.getX() + this.getWidth() - (double)widthY) - 2, (int)this.getY() + textHeight);
            }
        }

        public void setSelected(boolean b) {
            this.selected = b;
        }

        public boolean isSelected() {
            return this.selected;
        }
    }
}

