/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.gui.views;

import com.jacksay.sgarnish.assets.JckIconProvider;
import com.jacksay.sgarnish.i18n.JckResourceBundle;
import fr.unicaen.measure.gui.actions.ActionLoadFromText;
import fr.unicaen.measure.gui.model.STApplicationModel;
import fr.unicaen.measure.gui.views.STCorpusViewController;
import fr.unicaen.measure.gui.views.STCorpusViewPreview;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.sufflingplugin.ICorpusListenner;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;

public class STCorpusView
extends JPanel
implements ICorpusListenner {
    private JTextPane render;
    private JPanel renderPanel;
    private Box buttons;
    private STApplicationModel model;
    private JButton loadFromText;
    private ActionLoadFromText loadFromTextAction;

    public STCorpusView(STApplicationModel model, ActionLoadFromText a) {
        this.model = model;
        this.loadFromTextAction = a;
        this.setBorder(BorderFactory.createTitledBorder("Corpus"));
        this.setLayout(new GridLayout(1, 1));
        JTabbedPane tab = new JTabbedPane();
        this.buttons = Box.createHorizontalBox();
        this.loadFromText = new JButton("Load from textarea", JckIconProvider.getIcon((String)"refresh"));
        this.loadFromText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                STCorpusView.this.loadFromTextAction.load(STCorpusView.this.render.getText());
            }
        });
        this.buttons.add(this.loadFromText);
        this.render = new JTextPane();
        this.renderPanel = new JPanel();
        this.renderPanel.setLayout(new BorderLayout());
        this.renderPanel.add((Component)this.render, "Center");
        this.renderPanel.add((Component)this.buttons, "Last");
        STCorpusViewPreview preview = new STCorpusViewPreview(model.getCurrentEvaluationSimpleModel(), true);
        STCorpusViewController control = new STCorpusViewController(preview, model.getCurrentEvaluationSimpleModel());
        JPanel visual = new JPanel();
        visual.setLayout(new BorderLayout());
        visual.add((Component)control, "First");
        visual.add((Component)preview, "Center");
        tab.add(JckResourceBundle.get((String)"Preview"), visual);
        tab.add("CSV", this.renderPanel);
        this.add(tab);
        model.getCurrentEvaluationSimpleModel().addCorpusListener(this);
    }

    public void onCorpusChanged(ICorpus corpus) {
        System.out.println("STCorpusView:onCorpusChange()\n-----------------------------------------\n" + corpus + "\n");
        this.render.setText(corpus.getUnitSet().toString());
    }
}

