/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.gui.views;

import com.jacksay.sgarnish.assets.JckIconProvider;
import com.jacksay.sgarnish.i18n.JckResourceBundle;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.utils.CorpusUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class STCorpusImportCorpus
extends JDialog {
    public static int RESPONSE_CANCEL = 0;
    public static int RESPONSE_OK = 1;
    public static int DEFAULT_WIDTH = 450;
    public static int DEFAULT_HEIGHT = 200;
    public static final String FORMAT_CSV = "Predefined units format";
    public static final String FORMAT_GLOZZ = "Unitizing format";
    public static final String UNITS_SIZE_ONE = "Size of one";
    public static final String UNITS_SIZE_FILLED = "Filled";
    public static final String MISSING_VALUE_BLANK = "Leave blank";
    public static final String MISSING_VALUE_REPLACE = "Create unit";
    public static final String DEFAULT_VALUE_MISSING = "0";
    private int response = RESPONSE_CANCEL;
    private File importDirectory;
    private String format;
    private String unitSize;
    private String missing;
    private String missingValueReplaced;
    private File source;
    private Preferences prefs = Preferences.userNodeForPackage(STCorpusImportCorpus.class);
    private JTextField fieldMissingValue;
    private ICorpus importedCorpus;

    public STCorpusImportCorpus(Frame owner) {
        super(owner);
        this.setModal(true);
        this.initValues();
        this.initComponment();
    }

    private void initComponment() {
        JPanel main = new JPanel();
        main.setLayout(new BorderLayout());
        JPanel opt = new JPanel(new GridLayout(4, 1));
        JPanel sfs = new JPanel(new FlowLayout());
        sfs.setBorder(BorderFactory.createTitledBorder(JckResourceBundle.get((String)"Annotation file")));
        final JTextField tf = new JTextField();
        sfs.add(tf);
        tf.setEditable(false);
        tf.setColumns(20);
        JButton button = new JButton(JckResourceBundle.get((String)"Choose source file"));
        sfs.add(button);
        button.setIcon(JckIconProvider.getIcon((String)"folder_explore"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser(STCorpusImportCorpus.this.importDirectory);
                fc.setFileSelectionMode(0);
                if (fc.showOpenDialog(STCorpusImportCorpus.this.getOwner()) == 0) {
                    System.out.println("File selected : " + fc.getSelectedFile().toString());
                    tf.setText(fc.getSelectedFile().toString());
                    STCorpusImportCorpus.this.importDirectory = fc.getSelectedFile().getParentFile();
                    STCorpusImportCorpus.this.prefs.put("dir", STCorpusImportCorpus.this.importDirectory.getAbsolutePath().toString());
                    STCorpusImportCorpus.this.source = fc.getSelectedFile();
                }
            }
        });
        opt.add(sfs);
        JPanel f = new JPanel(new FlowLayout());
        f.setBorder(BorderFactory.createTitledBorder(JckResourceBundle.get((String)"Format")));
        ButtonGroup group = new ButtonGroup();
        JRadioButton radio = new JRadioButton(FORMAT_GLOZZ);
        group.add(radio);
        radio.setSelected(this.format.equals(FORMAT_GLOZZ));
        radio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                STCorpusImportCorpus.this.setFormat(STCorpusImportCorpus.FORMAT_GLOZZ);
            }
        });
        f.add(radio);
        radio = new JRadioButton(FORMAT_CSV);
        group.add(radio);
        radio.setSelected(this.format.equals(FORMAT_CSV));
        radio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                STCorpusImportCorpus.this.setFormat(STCorpusImportCorpus.FORMAT_CSV);
            }
        });
        f.add(radio);
        opt.add(f);
        JPanel io = new JPanel(new FlowLayout());
        io.setBorder(BorderFactory.createTitledBorder("Unit size"));
        group = new ButtonGroup();
        radio = new JRadioButton(UNITS_SIZE_ONE);
        group.add(radio);
        radio.setSelected(this.unitSize.equals(UNITS_SIZE_ONE));
        radio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                STCorpusImportCorpus.this.setUnitSize(STCorpusImportCorpus.UNITS_SIZE_ONE);
            }
        });
        io.add(radio);
        radio = new JRadioButton(UNITS_SIZE_FILLED);
        group.add(radio);
        radio.setSelected(this.unitSize.equals(UNITS_SIZE_FILLED));
        radio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                STCorpusImportCorpus.this.setUnitSize(STCorpusImportCorpus.UNITS_SIZE_FILLED);
            }
        });
        io.add(radio);
        JPanel miss = new JPanel(new FlowLayout());
        miss.setBorder(BorderFactory.createTitledBorder("Missing data"));
        group = new ButtonGroup();
        radio = new JRadioButton(MISSING_VALUE_BLANK);
        group.add(radio);
        radio.setSelected(this.missing.equals(MISSING_VALUE_BLANK));
        radio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                STCorpusImportCorpus.this.setMissing(STCorpusImportCorpus.MISSING_VALUE_BLANK);
                STCorpusImportCorpus.this.fieldMissingValue.setEnabled(false);
            }
        });
        miss.add(radio);
        radio = new JRadioButton(MISSING_VALUE_REPLACE);
        group.add(radio);
        radio.setSelected(this.missing.equals(MISSING_VALUE_REPLACE));
        radio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                STCorpusImportCorpus.this.setMissing(STCorpusImportCorpus.MISSING_VALUE_REPLACE);
                STCorpusImportCorpus.this.fieldMissingValue.setEnabled(true);
            }
        });
        miss.add(radio);
        this.fieldMissingValue = new JTextField(this.missingValueReplaced);
        this.fieldMissingValue.setEnabled(this.missing.equals(MISSING_VALUE_REPLACE));
        this.fieldMissingValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Default missing value changed !");
                STCorpusImportCorpus.this.setMissingValueReplaced(STCorpusImportCorpus.this.fieldMissingValue.getText());
            }
        });
        miss.add(new JLabel("Use value : "));
        this.fieldMissingValue.setColumns(8);
        miss.add(this.fieldMissingValue);
        main.add((Component)opt, "First");
        JPanel buttons = new JPanel();
        button = new JButton(JckResourceBundle.get((String)"cancel"));
        buttons.add(button);
        button.setIcon(JckIconProvider.getIcon((String)"cancel"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                STCorpusImportCorpus.this.dispose();
            }
        });
        button = new JButton(JckResourceBundle.get((String)"import"));
        buttons.add(button);
        button.setIcon(JckIconProvider.getIcon((String)"accept"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                STCorpusImportCorpus.this.importData();
            }
        });
        main.add((Component)buttons, "Last");
        this.setLayout(new GridLayout(1, 1));
        this.add(main);
    }

    public void setFormat(String s) {
        this.format = s;
        this.prefs.put("format", this.format);
    }

    public void setUnitSize(String s) {
        this.unitSize = s;
        this.prefs.put("unitSize", s);
    }

    public void setMissing(String s) {
        this.missing = s;
        this.prefs.put("missing", s);
    }

    public void setMissingValueReplaced(String s) {
        this.missingValueReplaced = s;
        this.prefs.put("missingValueReplaced", s);
    }

    public int display() {
        this.pack();
        this.setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
        return this.response;
    }

    public ICorpus getImportedCorpus() {
        return this.importedCorpus;
    }

    private void importData() {
        System.out.println("format : \t" + this.format);
        System.out.println("unitSize : \t" + this.unitSize);
        System.out.println("missing : \t" + this.missing);
        System.out.println("missingValueReplaced : \t" + this.missingValueReplaced);
        try {
            if (this.format.equals(FORMAT_GLOZZ)) {
                System.out.println("Format Glozz");
                this.importedCorpus = CorpusUtil.loadFromRichterFile((File)this.source);
                this.response = RESPONSE_OK;
            } else {
                this.importedCorpus = CorpusUtil.loadFromPrededinedUnitsFile((File)this.source);
            }
            this.response = RESPONSE_OK;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.response = RESPONSE_CANCEL;
            JOptionPane.showMessageDialog(this.getOwner(), e.getMessage(), "Import Error", 0);
        }
        this.dispose();
    }

    private void initValues() {
        this.importDirectory = new File(this.prefs.get("dir", System.getProperty("user.home")));
        System.out.println(this.importDirectory);
        this.format = this.prefs.get("format", FORMAT_GLOZZ);
        this.unitSize = this.prefs.get("unitSize", UNITS_SIZE_ONE);
        this.missing = this.prefs.get("missing", MISSING_VALUE_BLANK);
        this.missingValueReplaced = this.prefs.get("missingValueReplaced", DEFAULT_VALUE_MISSING);
    }
}

