/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.gui.model;

import com.jacksay.sgarnish.i18n.JckResourceBundle;
import fr.unicaen.measure.core.IMeasure;
import fr.unicaen.measure.gui.model.IAnnotationSetListenner;
import fr.unicaen.measure.gui.model.IMeasureListener;
import fr.unicaen.measure.model.CorpusImpl;
import fr.unicaen.measure.model.IAnnotationSet;
import fr.unicaen.measure.model.ICorpus;
import fr.unicaen.measure.model.IUnit;
import fr.unicaen.measure.sufflingplugin.ICorpusListenner;
import fr.unicaen.measure.sufflingplugin.ICorpusObservable;
import fr.unicaen.measure.sufflingplugin.IMeasurePlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class STEvaluationSimpleModel
implements ICorpusObservable {
    public static final int EVENT_ANNOTATIONS_CHANGED = 1;
    private static int experience_increment = 0;
    private IAnnotationSet<IUnit> annotations = null;
    private Collection<IMeasurePlugin> measures = new ArrayList<IMeasurePlugin>();
    private ICorpus corpus;
    private String name;
    private transient Collection<IAnnotationSetListenner> annotationSetListenners = new ArrayList<IAnnotationSetListenner>();
    private transient Collection<IMeasureListener> measureListenners = new ArrayList<IMeasureListener>();
    private transient Collection<ICorpusListenner> corpusListenners = new ArrayList<ICorpusListenner>();

    protected static int getNextEvaluationID() {
        return ++experience_increment;
    }

    public STEvaluationSimpleModel() {
        this.name = JckResourceBundle.get((String)"evaluation.name") + STEvaluationSimpleModel.getNextEvaluationID();
    }

    public void loadAnnotationSet(IAnnotationSet<IUnit> annotationSet) {
        System.out.println("loadAnnotationSet");
        this.annotations = annotationSet;
        int limit = 0;
        for (IUnit u : annotationSet.getAnnotations()) {
            limit = Math.max(limit, u.getEndIndex());
        }
        System.out.println("Corpus size : " + ++limit);
        this.corpus = new CorpusImpl(limit, this.annotations, 0);
        this.fireCorpusChange();
    }

    public ICorpus getCorpus() {
        return this.corpus;
    }

    public void addMeasure(IMeasurePlugin measure) {
        this.addMeasure(new IMeasurePlugin[]{measure});
    }

    public void addMeasure(IMeasurePlugin[] msr) {
        for (IMeasurePlugin m : msr) {
            try {
                IMeasurePlugin newMeasure = (IMeasurePlugin)m.getClass().newInstance();
                this.measures.add(newMeasure);
                newMeasure.setCorpusObservable((ICorpusObservable)this);
                this.fireMeasureAdded(newMeasure);
            }
            catch (Exception ex) {
                Logger.getLogger(STEvaluationSimpleModel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public Collection<IMeasurePlugin> getMeasures() {
        return this.measures;
    }

    public void addAnnotationSetListenner(IAnnotationSetListenner l) {
        this.annotationSetListenners.add(l);
    }

    public void removeAnnotationSetListenner(IAnnotationSetListenner l) {
        this.annotationSetListenners.remove(l);
    }

    protected void fireAnnotationSetChanged() {
        for (IAnnotationSetListenner l : this.annotationSetListenners) {
            l.fireAnnotationSetChanged(this.annotations);
        }
    }

    public void addMeasureSetListenner(IMeasureListener l) {
        this.measureListenners.add(l);
    }

    public void removeMeasureListenner(IMeasureListener l) {
        this.measureListenners.remove(l);
    }

    protected void fireMeasureAdded(IMeasurePlugin measurePlugin) {
        for (IMeasureListener l : this.measureListenners) {
            l.onMeasureAdded(measurePlugin);
        }
    }

    protected void fireMeasureRemoved(IMeasurePlugin measurePlugin) {
        for (IMeasureListener l : this.measureListenners) {
            l.onMeasureRemoved(measurePlugin);
        }
    }

    protected void fireMeasuresChanged() {
        for (IMeasureListener l : this.measureListenners) {
            l.fireMeasuresChanged();
        }
    }

    protected void fireMeasuresChanged(IMeasure m) {
        for (IMeasureListener l : this.measureListenners) {
            l.fireMeasureChanged(m);
        }
    }

    public void addCorpusListener(ICorpusListenner listenner) {
        this.corpusListenners.add(listenner);
    }

    public void removeCorpusListener(ICorpusListenner listenner) {
        this.corpusListenners.remove(listenner);
    }

    public void fireCorpusChange() {
        for (ICorpusListenner l : this.corpusListenners) {
            System.out.println(l);
            l.onCorpusChanged(this.getCorpus());
        }
    }

    public void loadCorpus(ICorpus corpusLoaded) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

