/*
 * Decompiled with CFR 0.152.
 */
package fr.unicaen.measure.gui.componements;

import fr.unicaen.measure.gui.componements.STMeasureComboBoxItem;
import fr.unicaen.measure.gui.model.STApplicationModel;
import fr.unicaen.measure.sufflingplugin.IMeasurePackPlugin;
import java.awt.Component;
import java.awt.Font;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;

public class STMeasuresComboBox
extends JComboBox
implements Observer {
    private STApplicationModel appModel;

    public STMeasuresComboBox(STApplicationModel app) {
        this.appModel = app;
        this.setRenderer(new STMeasuresComboBoxCellRenderer());
        this.updateModelCombo();
        this.appModel.addObserver(this);
    }

    protected final void updateModelCombo() {
        Object[] measures = new Object[this.appModel.getNbrMeasures() + this.appModel.getPlugins().size()];
        int i = 0;
        for (IMeasurePackPlugin plugin : this.appModel.getPlugins()) {
            measures[i++] = new Separator(plugin.getName() + ":");
            for (String nameMeasure : plugin.listMeasure()) {
                measures[i++] = new STMeasureComboBoxItem(nameMeasure, plugin);
            }
        }
        this.setModel(new STMeasuresComboBoxModel(measures));
    }

    @Override
    public void update(Observable o, Object o1) {
        if (o1.equals("onPluginsUpdated")) {
            this.updateModelCombo();
        }
    }

    private class Separator {
        private String text;

        public Separator(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return this.text;
        }
    }

    private class STMeasuresComboBoxCellRenderer
    extends DefaultListCellRenderer {
        private STMeasuresComboBoxCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (!(value instanceof Separator)) {
                this.setFont(new Font("Arial", 0, 12));
                return super.getListCellRendererComponent((JList<?>)list, "+" + value, index, isSelected, cellHasFocus);
            }
            this.setFont(new Font("Arial", 1, 12));
            JLabel label = new JLabel(value.toString());
            label.setText(value.toString());
            return label;
        }
    }

    private class STMeasuresComboBoxModel
    extends DefaultComboBoxModel {
        public STMeasuresComboBoxModel() {
            super(new Object[0]);
        }

        public STMeasuresComboBoxModel(Object[] measures) {
            super(measures);
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (!(anObject instanceof Separator)) {
                super.setSelectedItem(anObject);
            } else {
                int index = this.getIndexOf(anObject);
                super.setSelectedItem(STMeasuresComboBox.this.getItemAt(index + 1));
            }
        }
    }
}

