/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.lpsolver;

import java.util.ArrayList;
import lpsolve.LpSolve;
import lpsolve.LpSolveException;
import scpsolver.constraints.Constraint;
import scpsolver.constraints.LinearBiggerThanEqualsConstraint;
import scpsolver.constraints.LinearConstraint;
import scpsolver.constraints.LinearEqualsConstraint;
import scpsolver.constraints.LinearSmallerThanEqualsConstraint;
import scpsolver.lpsolver.LinearProgramSolver;
import scpsolver.lpsolver.SolverFactory;
import scpsolver.problems.LinearProgram;
import scpsolver.util.SparseVector;

public class LPSOLVESolver
implements LinearProgramSolver {
    private LpSolve solver = null;
    private long timeconstraint = 0L;

    private int[] transferIndexArray(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = nArray[i] + 1;
        }
        return nArray2;
    }

    private double[] transferDataArray(double[] dArray, int n) {
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i];
        }
        return dArray2;
    }

    private void addLinearConstraint(LinearConstraint linearConstraint, int n) {
        if (this.solver == null) {
            System.err.println("WARNING: Adding constraint to a non-existing problem");
            try {
                this.solver = LpSolve.makeLp(0, linearConstraint.getC().length);
            }
            catch (LpSolveException lpSolveException) {
                System.err.println("Can't instantiate solver:");
                System.err.println("Maybe some libraries are missing?");
                System.err.println(lpSolveException.getMessage());
                throw new RuntimeException("Could not instantiate LPSOLVESolver");
            }
        }
        SparseVector sparseVector = linearConstraint.getCSparse();
        try {
            this.solver.addConstraintex(sparseVector.getUsed(), sparseVector.getData(), this.transferIndexArray(sparseVector.getIndex(), sparseVector.getUsed()), n, linearConstraint.getT());
        }
        catch (LpSolveException lpSolveException) {
            System.err.println("Couldn't add constraint");
            System.err.println(lpSolveException.getMessage());
            throw new RuntimeException("Could not add constraint");
        }
    }

    public void addEqualsConstraint(LinearEqualsConstraint linearEqualsConstraint) {
        this.addLinearConstraint((LinearConstraint)linearEqualsConstraint, 3);
    }

    public void addLinearBiggerThanEqualsConstraint(LinearBiggerThanEqualsConstraint linearBiggerThanEqualsConstraint) {
        this.addLinearConstraint((LinearConstraint)linearBiggerThanEqualsConstraint, 2);
    }

    public void addLinearSmallerThanEqualsConstraint(LinearSmallerThanEqualsConstraint linearSmallerThanEqualsConstraint) {
        this.addLinearConstraint((LinearConstraint)linearSmallerThanEqualsConstraint, 1);
    }

    public void setTimeconstraint(long l) {
        this.timeconstraint = l;
    }

    public long getTimeconstraint() {
        return this.timeconstraint;
    }

    public String[] getLibraryNames() {
        return new String[]{"lpsolve55j"};
    }

    public String getName() {
        return "LPSOLVE";
    }

    public double[] solve(LinearProgram linearProgram) {
        try {
            int n;
            if (this.solver != null) {
                System.err.println("WARNING: overriding existing problem ...");
                this.solver.deleteLp();
                this.solver = null;
            }
            this.solver = LpSolve.makeLp(0, linearProgram.getDimension());
            if (linearProgram.isMinProblem()) {
                this.solver.setMinim();
            } else {
                this.solver.setMaxim();
            }
            this.solver.setVerbose(3);
            this.solver.setAddRowmode(true);
            double[] dArray = new double[linearProgram.getC().length + 1];
            System.arraycopy(linearProgram.getC(), 0, dArray, 1, linearProgram.getC().length);
            this.solver.setObjFn(dArray);
            for (Constraint constraint : linearProgram.getConstraints()) {
                if (constraint instanceof LinearEqualsConstraint) {
                    this.addEqualsConstraint((LinearEqualsConstraint)constraint);
                    continue;
                }
                if (constraint instanceof LinearBiggerThanEqualsConstraint) {
                    this.addLinearBiggerThanEqualsConstraint((LinearBiggerThanEqualsConstraint)constraint);
                    continue;
                }
                if (constraint instanceof LinearSmallerThanEqualsConstraint) {
                    this.addLinearSmallerThanEqualsConstraint((LinearSmallerThanEqualsConstraint)constraint);
                    continue;
                }
                throw new RuntimeException("Unexpected constraint type" + constraint.getName());
            }
            this.solver.setAddRowmode(false);
            if (!linearProgram.hasBounds()) {
                for (n = 0; n < linearProgram.getDimension(); ++n) {
                    this.solver.setUnbounded(n + 1);
                }
            } else {
                for (n = 0; n < linearProgram.getDimension(); ++n) {
                    this.solver.setBounds(n + 1, linearProgram.getLowerbound()[n], linearProgram.getUpperbound()[n]);
                }
            }
            boolean[] blArray = linearProgram.getIsinteger();
            for (int i = 0; i < blArray.length; ++i) {
                this.solver.setInt(i + 1, blArray[i]);
            }
            boolean[] blArray2 = linearProgram.getIsboolean();
            for (int i = 0; i < blArray2.length; ++i) {
                this.solver.setBinary(i + 1, blArray2[i]);
            }
            if (this.timeconstraint > 0L) {
                System.out.println("Setting time constraint to:" + this.timeconstraint + " seconds");
                this.solver.setTimeout(this.timeconstraint);
            }
            switch (this.solver.solve()) {
                case 0: {
                    break;
                }
                case -2: {
                    System.err.println("WARNING: ran out of memory during solving");
                    break;
                }
                case 1: {
                    System.err.println("WARNING: solution is suboptimal");
                    break;
                }
                case 2: {
                    System.err.println("WARNING: model is infeasible");
                    break;
                }
                case 3: {
                    System.err.println("WARNING: model is unbounded");
                    break;
                }
                case 4: {
                    System.err.println("WARNING: model is degenerate");
                    break;
                }
                case 5: {
                    System.err.println("WARNING: numerical failure happened");
                    break;
                }
                case 6: {
                    System.err.println("WARNING: solving aborted by user");
                    break;
                }
                case 7: {
                    System.err.println("WARNING: timeout occured");
                    break;
                }
                case 9: {
                    System.err.println("WARNING: model was already solved by presolving");
                    break;
                }
                case 10: {
                    System.err.println("WARNING: branch and bound method failed");
                    break;
                }
                case 11: {
                    System.err.println("WARNING: branch and bound stopped because of a break-at-first or a break-at-value");
                    break;
                }
                case 12: {
                    System.err.println("WARNING: a feasible branch and bound solution was found");
                    break;
                }
                case 13: {
                    System.err.println("WARNING: no feasible branch and bound solution was found");
                    break;
                }
                default: {
                    System.err.println("WARNING: something unexpected happened while trying to solve the problem");
                }
            }
            double[] dArray2 = this.solver.getPtrVariables();
            this.solver.deleteLp();
            this.solver = null;
            return dArray2;
        }
        catch (LpSolveException lpSolveException) {
            System.err.println("Can't instantiate solver:");
            System.err.println("Maybe some libraries are missing?");
            System.err.println(lpSolveException.getMessage());
            throw new RuntimeException("Could not instantiate LPSOLVESolver");
        }
    }

    public static void main(String[] stringArray) {
        Object object2;
        LinearProgram linearProgram = new LinearProgram(new double[]{10.0, 6.0, 4.0});
        linearProgram.addConstraint((LinearConstraint)new LinearSmallerThanEqualsConstraint(new double[]{1.0, 1.0, 1.0}, 320.0, "p"));
        linearProgram.addConstraint((LinearConstraint)new LinearSmallerThanEqualsConstraint(new double[]{10.0, 4.0, 5.0}, 650.0, "q"));
        linearProgram.addConstraint((LinearConstraint)new LinearBiggerThanEqualsConstraint(new double[]{2.0, 2.0, 6.0}, 100.0, "r1"));
        linearProgram.setLowerbound(new double[]{30.0, 0.0, 0.0});
        linearProgram.setInteger(0);
        linearProgram.setInteger(1);
        linearProgram.setInteger(2);
        LPSOLVESolver lPSOLVESolver = (LPSOLVESolver)SolverFactory.getSolver((String)"LPSOLVE");
        System.out.println(lPSOLVESolver.solve(linearProgram)[0]);
        double[] dArray = lPSOLVESolver.solve(linearProgram);
        ArrayList arrayList = linearProgram.getConstraints();
        for (Object object2 : arrayList) {
            if (!object2.isSatisfiedBy(dArray)) continue;
            System.out.println(object2.getName() + " satisfied");
        }
        linearProgram = new LinearProgram(new double[]{2.0, 0.0, 1.0, 0.5, 0.5});
        linearProgram.setMinProblem(Boolean.TRUE.booleanValue());
        linearProgram.setLowerbound(new double[]{1.0, 1.0, 1.0, 1.0, 1.0});
        linearProgram.addConstraint((LinearConstraint)new LinearBiggerThanEqualsConstraint(new double[]{0.5, 0.0, 0.0, 2.0, 0.0}, 2.0, "x_1 + x_4 >= 2"));
        linearProgram.addConstraint((LinearConstraint)new LinearSmallerThanEqualsConstraint(new double[]{0.0, 2.0, 0.0, 2.0, 1.0}, 5.0, "2 + x_4 + 0.5*x_5 <= 5"));
        linearProgram.addConstraint((LinearConstraint)new LinearBiggerThanEqualsConstraint(new double[]{0.0, 0.0, 3.0, 0.0, 10.0}, 16.0, "3*x_3 + 5*x_5 >= 16"));
        for (int i = 0; i < linearProgram.getDimension(); ++i) {
            linearProgram.setInteger(i);
        }
        lPSOLVESolver.setTimeconstraint(20);
        double[] dArray2 = lPSOLVESolver.solve(linearProgram);
        object2 = new double[]{1.0, 1.0, 2.0, 1.0, 1.0};
        for (int i = 0; i < linearProgram.getDimension() || i < ((Constraint)object2).length; ++i) {
            if (Math.abs(dArray2[i] - object2[i]) < 0.01) {
                System.out.println("Variable " + i + " erfolgreich gefunden!");
                continue;
            }
            System.out.println("ACHTUNG: Variable " + i + " nicht erfolgreich gefunden!");
        }
    }

    public void setTimeconstraint(int n) {
        System.out.println("setTimeconstraint not yet functional for LPSOLVE!");
    }
}

