/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.util.debugging;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import scpsolver.constraints.Constraint;
import scpsolver.constraints.LinearBiggerThanEqualsConstraint;
import scpsolver.constraints.LinearConstraint;
import scpsolver.constraints.LinearEqualsConstraint;
import scpsolver.constraints.LinearSmallerThanEqualsConstraint;
import scpsolver.lpsolver.LinearProgramSolver;
import scpsolver.lpsolver.SolverFactory;
import scpsolver.problems.ConstrainedProblem;
import scpsolver.problems.LinearProgram;
import scpsolver.problems.SolutionRenderable;
import scpsolver.util.SparseVector;

public class LPDebugger {
    int attemptcount = 0;
    JFrame mainframe = new JFrame();

    public LPDebugger(final LinearProgram linearProgram) {
        this.mainframe.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        final LinearProgram linearProgram2 = new LinearProgram(linearProgram);
        final ConstraintTableDataModel constraintTableDataModel = new ConstraintTableDataModel(linearProgram2);
        final JTable jTable = new JTable(constraintTableDataModel);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.add(jTable);
        this.mainframe.setTitle("Linear Program Debugger");
        this.mainframe.getContentPane().setLayout(new BorderLayout());
        jScrollPane.add(jTable);
        jScrollPane.setViewportView(jTable);
        this.mainframe.add((Component)jScrollPane, "Center");
        JScrollPane jScrollPane2 = new JScrollPane();
        final JTextArea jTextArea = new JTextArea(10, 20);
        jScrollPane2.add(jTextArea);
        jScrollPane2.setViewportView(jTextArea);
        JPanel jPanel = new JPanel();
        final JPanel jPanel2 = new JPanel();
        final JButton jButton = new JButton();
        jButton.setText("solve");
        final JButton jButton2 = new JButton();
        jButton2.setText("deactivate minimum infeasibile constraints");
        JLabel jLabel = new JLabel();
        final JTextField jTextField = new JTextField();
        LinearProgram linearProgram3 = LPDebugger.getFeasOptLP(linearProgram);
        LinearProgramSolver linearProgramSolver = SolverFactory.newDefault();
        double[] dArray = linearProgramSolver.solve(linearProgram3);
        double d = Double.NEGATIVE_INFINITY;
        for (int i = linearProgram2.getDimension(); i < dArray.length; ++i) {
            if (!(d < dArray[i])) continue;
            d = dArray[i];
        }
        jTextField.setText("" + Math.round(d));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTextArea.append("================================\nrelaxing constraints by minimization...\n");
                jButton2.setEnabled(false);
                LinearProgram linearProgram = LPDebugger.getFeasOptLPBinary(linearProgram2, Double.parseDouble(jTextField.getText()));
                LinearProgramSolver linearProgramSolver = SolverFactory.getSolver("CPLEX");
                double[] dArray = linearProgramSolver.solve(linearProgram);
                if (dArray != null) {
                    boolean bl = false;
                    double d = Double.NEGATIVE_INFINITY;
                    for (int i = linearProgram2.getDimension(); i < linearProgram2.getDimension() + linearProgram2.getConstraints().size() * 2; ++i) {
                        if (!(dArray[i] > 0.0)) continue;
                        int n = (i - linearProgram2.getDimension()) % linearProgram2.getConstraints().size();
                        constraintTableDataModel.constraintswitch[n] = true;
                        jTextArea.append("constraint \"" + linearProgram2.getConstraints().get(n).getName() + "\" deactivated. (correction: " + dArray[i] + ")\n");
                    }
                    jTextArea.append("obj.v.: " + linearProgram.evaluate(dArray) + "\n");
                } else {
                    jTextArea.append("System is infeasible.\n");
                    jPanel2.setBackground(Color.RED);
                }
                jTable.repaint();
                jButton2.setEnabled(true);
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ++LPDebugger.this.attemptcount;
                jTextArea.append("================================\nattempt " + LPDebugger.this.attemptcount + "\n");
                jButton.setEnabled(false);
                LinearProgram linearProgram3 = new LinearProgram(linearProgram2);
                ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
                for (int i = 0; i < constraintTableDataModel.constraintswitch.length; ++i) {
                    if (!constraintTableDataModel.constraintswitch[i].booleanValue()) {
                        arrayList.add(linearProgram2.getConstraints().get(i));
                        continue;
                    }
                    jTextArea.append("constraint \"" + linearProgram2.getConstraints().get(i).getName() + "\" deactivated.\n");
                }
                linearProgram3.setConstraints(arrayList);
                LinearProgramSolver linearProgramSolver = SolverFactory.getSolver("CPLEX");
                double[] dArray = linearProgramSolver.solve(linearProgram3);
                if (dArray != null) {
                    double d = linearProgram2.evaluate(dArray);
                    jTextArea.append("System is feasible. Objective value is: " + d + "\n");
                    jPanel2.setBackground(Color.GREEN);
                    if (linearProgram instanceof SolutionRenderable) {
                        String string = ((SolutionRenderable)((Object)linearProgram)).getSolutionRepresentation(dArray);
                        jTextArea.append(string);
                    }
                } else {
                    jTextArea.append("System is infeasible.\n");
                    jPanel2.setBackground(Color.RED);
                }
                jButton.setEnabled(true);
            }
        });
        jPanel2.setLayout(new BorderLayout());
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jLabel, "Center");
        jPanel2.add((Component)jScrollPane2, "South");
        jPanel2.add((Component)jButton, "East");
        jPanel2.add((Component)jButton2, "West");
        jPanel2.add((Component)jTextField, "Center");
        this.mainframe.getContentPane().add((Component)jPanel2, "South");
        this.mainframe.pack();
        this.mainframe.setVisible(true);
    }

    public static LinearProgram getFeasOptLP(LinearProgram linearProgram) {
        int n;
        ArrayList<Constraint> arrayList = linearProgram.getConstraints();
        double[] dArray = new double[arrayList.size() * 2 + linearProgram.getDimension()];
        double[] dArray2 = new double[arrayList.size() * 2 + linearProgram.getDimension()];
        if (linearProgram.hasBounds()) {
            for (n = 0; n < linearProgram.getDimension(); ++n) {
                dArray2[n] = linearProgram.getLowerbound()[n];
            }
        }
        for (n = linearProgram.getDimension(); n < dArray.length; ++n) {
            dArray2[n] = 0.0;
            dArray[n] = 1.0;
        }
        LinearProgram linearProgram2 = new LinearProgram(dArray);
        linearProgram2.setLowerbound(dArray2);
        for (int i = 0; i < arrayList.size(); ++i) {
            Constraint constraint = arrayList.get(i);
            LinearConstraint linearConstraint = (LinearConstraint)constraint;
            SparseVector sparseVector = linearConstraint.getCSparse();
            double d = linearConstraint.getT();
            SparseVector sparseVector2 = new SparseVector(arrayList.size() * 2, 2);
            sparseVector2.set(i, 1.0);
            sparseVector2.set(arrayList.size() + i, -1.0);
            sparseVector.grow(sparseVector2);
            System.out.println(sparseVector);
            if (constraint instanceof LinearSmallerThanEqualsConstraint) {
                linearProgram2.addConstraint(new LinearSmallerThanEqualsConstraint(sparseVector, d, constraint.getName()));
                continue;
            }
            if (constraint instanceof LinearBiggerThanEqualsConstraint) {
                linearProgram2.addConstraint(new LinearBiggerThanEqualsConstraint(sparseVector, d, constraint.getName()));
                continue;
            }
            if (!(constraint instanceof LinearEqualsConstraint)) continue;
            linearProgram2.addConstraint(new LinearEqualsConstraint(sparseVector, d, constraint.getName()));
        }
        boolean[] blArray = linearProgram.getIsinteger();
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            linearProgram2.setInteger(i);
        }
        boolean[] blArray2 = linearProgram.getIsboolean();
        for (int i = 0; i < blArray2.length; ++i) {
            if (!blArray2[i]) continue;
            linearProgram2.setBinary(i);
        }
        linearProgram2.setMinProblem(true);
        return linearProgram2;
    }

    public static LinearProgram getFeasOptLPBinary(LinearProgram linearProgram, double d) {
        int n;
        int n2;
        ArrayList<Constraint> arrayList = linearProgram.getConstraints();
        double[] dArray = new double[arrayList.size() * 2 + linearProgram.getDimension()];
        double[] dArray2 = new double[arrayList.size() * 2 + linearProgram.getDimension()];
        double[] dArray3 = new double[arrayList.size() * 2 + linearProgram.getDimension()];
        if (linearProgram.hasBounds()) {
            for (n2 = 0; n2 < linearProgram.getDimension(); ++n2) {
                dArray2[n2] = linearProgram.getLowerbound()[n2];
                dArray3[n2] = linearProgram.getUpperbound()[n2];
            }
        } else {
            for (n2 = 0; n2 < linearProgram.getDimension(); ++n2) {
                dArray2[n2] = -1.7976931348623157E308;
                dArray3[n2] = Double.MAX_VALUE;
            }
        }
        for (n2 = linearProgram.getDimension(); n2 < linearProgram.getDimension() + arrayList.size(); ++n2) {
            dArray2[n2] = -1.7976931348623157E308;
            dArray3[n2] = Double.MAX_VALUE;
            dArray[n2] = 0.0;
        }
        for (n2 = linearProgram.getDimension() + arrayList.size(); n2 < dArray.length; ++n2) {
            dArray2[n2] = 0.0;
            dArray3[n2] = 1.0;
            dArray[n2] = 1.0;
        }
        LinearProgram linearProgram2 = new LinearProgram(dArray);
        for (n = linearProgram.getDimension() + arrayList.size(); n < dArray.length; ++n) {
            linearProgram2.setBinary(n);
        }
        linearProgram2.setLowerbound(dArray2);
        for (n = 0; n < arrayList.size(); ++n) {
            Constraint constraint = arrayList.get(n);
            LinearConstraint linearConstraint = (LinearConstraint)constraint;
            SparseVector sparseVector = linearConstraint.getCSparse();
            double d2 = linearConstraint.getT();
            SparseVector sparseVector2 = new SparseVector(arrayList.size() * 2, 2);
            sparseVector2.set(n, 1.0);
            sparseVector.grow(sparseVector2);
            if (constraint instanceof LinearSmallerThanEqualsConstraint) {
                linearProgram2.addConstraint(new LinearSmallerThanEqualsConstraint(sparseVector, d2, constraint.getName()));
            } else if (constraint instanceof LinearBiggerThanEqualsConstraint) {
                linearProgram2.addConstraint(new LinearBiggerThanEqualsConstraint(sparseVector, d2, constraint.getName()));
            } else if (constraint instanceof LinearEqualsConstraint) {
                linearProgram2.addConstraint(new LinearEqualsConstraint(sparseVector, d2, constraint.getName()));
            }
            SparseVector sparseVector3 = new SparseVector(linearProgram2.getDimension(), 2);
            SparseVector sparseVector4 = new SparseVector(linearProgram2.getDimension(), 2);
            sparseVector3.set(linearProgram.getDimension() + n, 1.0);
            sparseVector3.set(linearProgram.getDimension() + arrayList.size() + n, d);
            linearProgram2.addConstraint(new LinearBiggerThanEqualsConstraint(sparseVector3, 0.0, "constraint " + n + " modified MAX"));
            sparseVector4.set(linearProgram.getDimension() + n, 1.0);
            sparseVector4.set(linearProgram.getDimension() + arrayList.size() + n, -d);
            linearProgram2.addConstraint(new LinearSmallerThanEqualsConstraint(sparseVector4, 0.0, "constraint " + n + "modified MIN"));
        }
        boolean[] blArray = linearProgram.getIsinteger();
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            linearProgram2.setInteger(i);
        }
        boolean[] blArray2 = linearProgram.getIsboolean();
        for (int i = 0; i < blArray2.length; ++i) {
            if (!blArray2[i]) continue;
            linearProgram2.setBinary(i);
        }
        linearProgram2.setMinProblem(true);
        return linearProgram2;
    }

    public static LinearProgram getFeasOptLPBinary(LinearProgram linearProgram, int n, double d) {
        Object object;
        Object object2;
        int n2;
        LinearProgram linearProgram2;
        int n3;
        ArrayList<Constraint> arrayList = linearProgram.getConstraints();
        double[] dArray = new double[linearProgram.getDimension() * 2];
        double[] dArray2 = new double[linearProgram.getDimension() * 2];
        double[] dArray3 = new double[linearProgram.getDimension() * 2];
        if (linearProgram.hasBounds()) {
            for (n3 = 0; n3 < linearProgram.getDimension(); ++n3) {
                dArray2[n3] = linearProgram.getLowerbound()[n3];
                dArray2[n3] = linearProgram.getUpperbound()[n3];
            }
        } else {
            for (n3 = 0; n3 < dArray.length; ++n3) {
                dArray2[n3] = -1.7976931348623157E308;
                dArray3[n3] = Double.MAX_VALUE;
            }
        }
        if (n == 0) {
            linearProgram2 = new LinearProgram(dArray);
        } else {
            SparseVector sparseVector = new SparseVector(linearProgram.getDimension() * 2, 2);
            linearProgram2 = new LinearProgram(sparseVector);
        }
        for (n2 = linearProgram.getDimension(); n2 < dArray.length; ++n2) {
            linearProgram2.setBinary(n2);
        }
        linearProgram2.setLowerbound(dArray2);
        linearProgram2.setUpperbound(dArray3);
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            object2 = arrayList.get(n2);
            object = (LinearConstraint)object2;
            SparseVector sparseVector = object.getCSparse();
            double d2 = object.getT();
            SparseVector sparseVector2 = new SparseVector(linearProgram.getDimension(), 2);
            sparseVector.grow(sparseVector2);
            if (object2 instanceof LinearSmallerThanEqualsConstraint) {
                linearProgram2.addConstraint(new LinearSmallerThanEqualsConstraint(sparseVector, d2, object2.getName()));
                continue;
            }
            if (object2 instanceof LinearBiggerThanEqualsConstraint) {
                linearProgram2.addConstraint(new LinearBiggerThanEqualsConstraint(sparseVector, d2, object2.getName()));
                continue;
            }
            if (!(object2 instanceof LinearEqualsConstraint)) continue;
            linearProgram2.addConstraint(new LinearEqualsConstraint(sparseVector, d2, object2.getName()));
        }
        for (n2 = 0; n2 < linearProgram.getDimension(); ++n2) {
            object2 = new SparseVector(linearProgram.getDimension() * 2, 4);
            object = new SparseVector(linearProgram.getDimension() * 2, 4);
            ((SparseVector)object2).set(n2, 1.0);
            ((SparseVector)object).set(n2, 1.0);
            ((SparseVector)object2).set(linearProgram.getDimension() + n2, d);
            ((SparseVector)object).set(linearProgram.getDimension() + n2, -d);
            linearProgram2.addConstraint(new LinearBiggerThanEqualsConstraint((SparseVector)object2, 0.0, "constraint " + n2 + "modified"));
            linearProgram2.addConstraint(new LinearSmallerThanEqualsConstraint((SparseVector)object, 0.0, "constraint " + n2 + "modified"));
        }
        if (n > 0) {
            linearProgram2.addConstraint(new LinearSmallerThanEqualsConstraint(dArray, (double)n, "maxvars"));
        }
        boolean[] blArray = linearProgram.getIsinteger();
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            linearProgram2.setInteger(i);
        }
        boolean[] blArray2 = linearProgram.getIsboolean();
        for (int i = 0; i < blArray2.length; ++i) {
            if (!blArray2[i]) continue;
            linearProgram2.setBinary(i);
        }
        linearProgram2.setMinProblem(true);
        return linearProgram2;
    }

    public static void main(String[] stringArray) {
        LinearProgram linearProgram = new LinearProgram(new double[]{3.19, 2.59, 2.29, 2.89, 1.89, 1.99, 1.99, 2.49});
        linearProgram.setMinProblem(Boolean.TRUE);
        linearProgram.addConstraint(new LinearSmallerThanEqualsConstraint(new double[]{60.0, 8.0, 8.0, 40.0, 15.0, 70.0, 25.0, 60.0}, 699.0, "Vitamin A"));
        linearProgram.addConstraint(new LinearBiggerThanEqualsConstraint(new double[]{60.0, 8.0, 8.0, 40.0, 15.0, 70.0, 25.0, 60.0}, 700.0, "Vitamin D"));
        linearProgram.addConstraint(new LinearBiggerThanEqualsConstraint(new double[]{20.0, 0.0, 10.0, 40.0, 35.0, 30.0, 50.0, 20.0}, 700.0, "Vitamin C"));
        linearProgram.addConstraint(new LinearSmallerThanEqualsConstraint(new double[]{10.0, 20.0, 15.0, 35.0, 15.0, 15.0, 25.0, 15.0}, 699.0, "Vitamin B1"));
        linearProgram.addConstraint(new LinearBiggerThanEqualsConstraint(new double[]{10.0, 20.0, 15.0, 35.0, 15.0, 15.0, 25.0, 15.0}, 700.0, "Vitamin B12"));
        linearProgram.addConstraint(new LinearBiggerThanEqualsConstraint(new double[]{15.0, 20.0, 10.0, 10.0, 15.0, 15.0, 15.0, 10.0}, 700.0, "Vitamin B14"));
        linearProgram.addConstraint(new LinearSmallerThanEqualsConstraint(new double[]{60.0, 8.0, 8.0, 40.0, 15.0, 70.0, 25.0, 60.0}, 100.0, "Vitamin Z"));
        linearProgram.addConstraint(new LinearBiggerThanEqualsConstraint(new double[]{60.0, 8.0, 8.0, 40.0, 15.0, 70.0, 25.0, 60.0}, 400.0, "Vitamin O"));
        linearProgram.addConstraint(new LinearBiggerThanEqualsConstraint(new double[]{20.0, 0.0, 10.0, 40.0, 35.0, 30.0, 50.0, 20.0}, 435.0, "Vitamin I"));
        linearProgram.addConstraint(new LinearSmallerThanEqualsConstraint(new double[]{10.0, 20.0, 15.0, 35.0, 15.0, 15.0, 25.0, 15.0}, 699.0, "Vitamin B21"));
        linearProgram.addConstraint(new LinearBiggerThanEqualsConstraint(new double[]{10.0, 20.0, 15.0, 35.0, 15.0, 15.0, 25.0, 15.0}, 1000.0, "Vitamin B2"));
        LinearProgram linearProgram2 = LPDebugger.getFeasOptLP(linearProgram);
        LinearProgramSolver linearProgramSolver = SolverFactory.getSolver("GLPK");
        linearProgram.setLowerbound(new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0});
        LPDebugger lPDebugger = new LPDebugger(linearProgram);
    }

    class ConstraintTableDataModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 171619054654841854L;
        ConstrainedProblem lp;
        Boolean[] constraintswitch;

        public ConstraintTableDataModel(ConstrainedProblem constrainedProblem) {
            this.lp = constrainedProblem;
            this.constraintswitch = new Boolean[constrainedProblem.getConstraints().size()];
            for (int i = 0; i < this.constraintswitch.length; ++i) {
                this.constraintswitch[i] = new Boolean(false);
            }
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.lp.getConstraints().size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.lp.getConstraints().get(n).getName();
            }
            if (n2 == 1) {
                return this.lp.getConstraints().get(n).getRHS();
            }
            return this.constraintswitch[n];
        }

        public Class<? extends Object> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 2;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "constraint name";
                }
                case 1: {
                    return "RHS";
                }
                case 2: {
                    return "deactivate";
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 2) {
                this.constraintswitch[n] = (Boolean)object;
            }
            this.fireTableCellUpdated(n, n2);
        }
    }
}

