/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import scpsolver.util.Matrix;
import scpsolver.util.NonZeroElementIterator;
import scpsolver.util.SparseMatrix;
import scpsolver.util.SparseVectorNonZeroElementIterator;

public class SparseVector
implements Matrix {
    double[] data;
    int[] index;
    int used;
    int size;
    boolean linevector;

    public double[] getData() {
        return this.data;
    }

    public void setData(double[] dArray) {
        this.data = dArray;
    }

    public int[] getIndex() {
        return this.index;
    }

    public void setIndex(int[] nArray) {
        this.index = nArray;
    }

    public int getUsed() {
        return this.used;
    }

    public void setUsed(int n) {
        this.used = n;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public void grow(int n, boolean bl) {
        this.size = n;
        if (!bl) {
            int n2 = 0;
            while (n2 < this.used) {
                int n3 = n2++;
                this.index[n3] = this.index[n3] + (n - this.size);
            }
        }
    }

    public void grow(SparseVector sparseVector) {
        SparseVectorNonZeroElementIterator sparseVectorNonZeroElementIterator = new SparseVectorNonZeroElementIterator(sparseVector);
        int n = this.size;
        this.size += sparseVector.size;
        while (sparseVectorNonZeroElementIterator.hasNext()) {
            double d = sparseVectorNonZeroElementIterator.next();
            int n2 = sparseVectorNonZeroElementIterator.getActualj();
            this.set(n2 + n, d);
        }
    }

    @Override
    public Matrix transpose() {
        SparseVector sparseVector = new SparseVector(this);
        sparseVector.linevector = !this.linevector;
        return sparseVector;
    }

    public SparseVector(int n, int n2) {
        this.data = new double[n2];
        this.index = new int[n2];
        for (int i = 0; i < this.index.length; ++i) {
            this.index[i] = Integer.MAX_VALUE;
        }
        this.used = 0;
        this.size = n;
        this.linevector = false;
    }

    public SparseVector(SparseVector sparseVector) {
        this.data = (double[])sparseVector.data.clone();
        this.index = (int[])sparseVector.index.clone();
        this.used = sparseVector.used;
        this.size = sparseVector.size;
        this.linevector = sparseVector.linevector;
    }

    public SparseVector(double[] dArray) {
        this.data = new double[dArray.length];
        this.index = new int[dArray.length];
        this.used = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == 0.0) continue;
            this.data[this.used] = dArray[i];
            this.index[this.used] = i;
            ++this.used;
        }
        double[] dArray2 = new double[this.used];
        int[] nArray = new int[this.used];
        System.arraycopy(this.data, 0, dArray2, 0, this.used);
        System.arraycopy(this.index, 0, nArray, 0, this.used);
        this.data = dArray2;
        this.index = nArray;
        this.size = dArray.length;
        this.linevector = false;
    }

    public SparseVector(int[] nArray, double[] dArray) {
        this.setIndex(nArray);
        this.setData(dArray);
        this.setSize(dArray.length);
        this.setUsed(dArray.length);
        this.linevector = false;
    }

    public SparseVector(Matrix matrix) {
        if (matrix instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)matrix;
            this.data = (double[])sparseVector.data.clone();
            this.index = (int[])sparseVector.index.clone();
            this.used = sparseVector.used;
            this.size = sparseVector.size;
            this.linevector = sparseVector.linevector;
        } else {
            NonZeroElementIterator nonZeroElementIterator = matrix.getNonZeroElementIterator();
            while (nonZeroElementIterator.hasNext()) {
                this.set(nonZeroElementIterator.getActuali(), nonZeroElementIterator.getActualj());
            }
        }
    }

    public SparseVector clone() {
        return new SparseVector(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.index.length; ++i) {
            stringBuffer.append("[" + this.index[i] + "," + this.data[i] + "]");
        }
        return stringBuffer.toString();
    }

    public int getIndex(int n) {
        int n2 = Arrays.binarySearch(this.index, n);
        if (n2 >= 0) {
            if (n2 < this.used && this.index[n2] == n) {
                return n2;
            }
        } else {
            n2 = -n2 - 1;
        }
        int[] nArray = this.index;
        double[] dArray = this.data;
        if (++this.used >= this.data.length) {
            int n3 = this.data.length != 0 ? Math.min(this.data.length << 1, this.size) : 1;
            nArray = new int[n3];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = Integer.MAX_VALUE;
            }
            dArray = new double[n3];
            System.arraycopy(this.index, 0, nArray, 0, n2);
            System.arraycopy(this.data, 0, dArray, 0, n2);
        }
        if (n2 != this.used) {
            try {
                System.arraycopy(this.index, n2, nArray, n2 + 1, this.used - n2 - 1);
                System.arraycopy(this.data, n2, dArray, n2 + 1, this.used - n2 - 1);
            }
            catch (Exception exception) {
                System.out.println(this.index.length + " " + nArray.length + "  " + n2 + " " + this.used);
                exception.printStackTrace();
                System.exit(0);
            }
        }
        nArray[n2] = n;
        dArray[n2] = 0.0;
        this.index = nArray;
        this.data = dArray;
        return n2;
    }

    public void set(int n, double d) {
        int n2 = this.getIndex(n);
        this.data[n2] = d;
    }

    public double get(int n) {
        int n2 = Arrays.binarySearch(this.index, n);
        if (n2 >= 0) {
            return this.data[n2];
        }
        return 0.0;
    }

    public double[] get() {
        double[] dArray = new double[this.size];
        for (int i = 0; i < this.used; ++i) {
            dArray[this.index[i]] = this.data[i];
        }
        return dArray;
    }

    public double dot(SparseVector sparseVector) {
        int n;
        double d = 0.0;
        int[] nArray = this.index;
        int n2 = 0;
        int[] nArray2 = sparseVector.getIndex();
        boolean bl = nArray[n2] >= nArray2[n = 0];
        int n3 = sparseVector.getUsed();
        while (n2 < this.used && n < n3) {
            boolean bl2 = bl = nArray[n2] >= nArray2[n];
            if (nArray[n2] == nArray2[n]) {
                d += this.data[n2] * sparseVector.data[n];
                ++n2;
                continue;
            }
            if (bl) {
                ++n;
                continue;
            }
            ++n2;
        }
        return d;
    }

    @Override
    public SparseVector plus(Matrix matrix) {
        SparseVector sparseVector = new SparseVector(this);
        if (matrix instanceof SparseVector) {
            SparseVector sparseVector2 = (SparseVector)matrix;
            int[] nArray = sparseVector2.getIndex();
            for (int i = 0; i < sparseVector2.getUsed(); ++i) {
                sparseVector.set(nArray[i], this.get(nArray[i]) + sparseVector2.data[i]);
            }
            return sparseVector;
        }
        for (int i = 0; i < this.getRowNum(); ++i) {
            for (int j = 0; j < this.getColNum(); ++j) {
                sparseVector.set(i, j, sparseVector.get(i, j) + matrix.get(i, j));
            }
        }
        return sparseVector;
    }

    public double dotdumb(SparseVector sparseVector) {
        double[] dArray = sparseVector.get();
        return this.dot(dArray);
    }

    public double dot(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < this.used; ++i) {
            d += this.data[i] * dArray[this.index[i]];
        }
        return d;
    }

    public SparseVector times(double d) {
        SparseVector sparseVector = new SparseVector(this);
        int n = 0;
        while (n < sparseVector.data.length) {
            int n2 = n++;
            sparseVector.data[n2] = sparseVector.data[n2] * d;
        }
        return sparseVector;
    }

    @Override
    public double get(int n, int n2) {
        if (this.linevector) {
            if (n != 0 || this.size <= n2) {
                System.out.println("out of bounds " + n + " " + n2);
            }
            return this.get(n2);
        }
        if (n2 != 0 || this.size <= n) {
            System.out.println("out of bounds " + n + " " + n2 + " " + this.size);
        }
        return this.get(n);
    }

    @Override
    public int getColNum() {
        return this.linevector ? this.size : 1;
    }

    @Override
    public int getRowNum() {
        return this.linevector ? 1 : this.size;
    }

    @Override
    public Matrix times(Matrix matrix) {
        if (this.getColNum() != matrix.getRowNum()) {
            System.out.print("Matrix dimensons must agree " + this.getRowNum() + " " + this.getColNum() + " " + matrix.getRowNum() + " " + matrix.getColNum());
            return null;
        }
        Matrix matrix2 = null;
        if (matrix instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)matrix;
            if (this.linevector == sparseVector.linevector) {
                matrix2 = this.linevector ? new SparseVector(new double[]{this.data[0], sparseVector.data[0]}) : this.times(sparseVector.data[0]);
            } else if (this.linevector) {
                System.out.println("1xn * nx1 => 1x1, equals dot-product");
                matrix2 = new SparseVector(new double[]{this.dotdumb(sparseVector)});
            } else {
                matrix2 = new SparseMatrix(this.getRowNum(), matrix.getColNum());
                for (int i = 0; i < this.used; ++i) {
                    for (int j = 0; j < sparseVector.used; ++j) {
                        matrix2.set(this.index[i], sparseVector.index[j], this.data[i] * sparseVector.data[j]);
                    }
                }
            }
        } else if (matrix instanceof SparseMatrix) {
            SparseMatrix sparseMatrix = (SparseMatrix)matrix;
            if (this.linevector) {
                matrix2 = new SparseVector(sparseMatrix.getColNum(), this.used);
                SparseMatrix sparseMatrix2 = (SparseMatrix)sparseMatrix.transpose();
                Iterator<Map.Entry<Integer, SparseVector>> iterator = sparseMatrix2.vvectorlist.entrySet().iterator();
                ((SparseVector)matrix2).linevector = true;
                while (iterator.hasNext()) {
                    Map.Entry<Integer, SparseVector> entry = iterator.next();
                    int n = entry.getKey();
                    SparseVector sparseVector = entry.getValue();
                    matrix2.set(0, n, this.dot(sparseVector));
                }
            } else {
                matrix2 = this.times(sparseMatrix.vvectorlist.get(0));
            }
        }
        return matrix2;
    }

    @Override
    public void set(int n, int n2, double d) {
        if (this.linevector) {
            if (n != 0 || this.size <= n2) {
                System.out.println("out of bounds " + n + " " + n2);
            }
            this.set(n2, d);
        } else {
            if (n2 != 0 || this.size <= n) {
                System.out.println("out of bounds " + n + " " + n2);
            }
            this.set(n, d);
        }
    }

    public SparseVector add(SparseVector sparseVector) {
        SparseVector sparseVector2 = new SparseVector(sparseVector);
        for (int i = 0; i < this.size; ++i) {
            sparseVector2.set(i, sparseVector2.get(i) + this.get(i));
        }
        return sparseVector2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SparseVector)) {
            throw new IllegalArgumentException("Illegal Argument: object isn't of type SparseVector");
        }
        return this.equals((SparseVector)object);
    }

    public boolean equals(SparseVector sparseVector) {
        if (this.size != sparseVector.getSize()) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (!(Math.abs(this.get(i) - sparseVector.get(i)) > 1.0E-4)) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        Random random = new Random();
        int n3 = n2 = 400;
        int n4 = n2;
        int n5 = n2;
        int n6 = n2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (n = 0; n < n3 * n4; ++n) {
            arrayList.add(n);
            arrayList2.add(n);
        }
        n = 0;
        int n7 = 0;
        SparseMatrix sparseMatrix = new SparseMatrix(n3, n4);
        SparseMatrix sparseMatrix2 = new SparseMatrix(n5, n6);
        double[][] dArray = new double[n3][n4];
        double[][] dArray2 = new double[n5][n6];
        for (int i = 1; i < 100; ++i) {
            int n8;
            double d;
            int n9;
            int n10;
            Integer n11;
            int n12;
            double[][] dArray3 = new double[n3][n6];
            int n13 = (int)Math.round((double)(n3 * n4) * (double)i / 100.0);
            while (n < n13) {
                n12 = random.nextInt(arrayList.size());
                n11 = (Integer)arrayList.get(n12);
                arrayList.remove(n11);
                n10 = n11 / n4;
                n9 = n11 % n3;
                d = random.nextDouble();
                sparseMatrix.set(n10, n9, d);
                dArray[n10][n9] = d;
                ++n;
            }
            while (n7 < n13) {
                n12 = random.nextInt(arrayList2.size());
                n11 = (Integer)arrayList2.get(n12);
                arrayList2.remove(n11);
                n10 = n11 / n6;
                n9 = n11 % n5;
                d = random.nextDouble();
                sparseMatrix2.set(n10, n9, d);
                dArray2[n10][n9] = d;
                ++n7;
            }
            long l = System.currentTimeMillis();
            for (n10 = 0; n10 < n3; ++n10) {
                for (n9 = 0; n9 < n6; ++n9) {
                    d = 0.0;
                    for (n8 = 0; n8 < n4; ++n8) {
                        d += dArray[n10][n8] * dArray2[n8][n9];
                    }
                    dArray3[n10][n9] = d;
                }
            }
            l = System.currentTimeMillis() - l;
            long l2 = System.currentTimeMillis();
            Matrix matrix = sparseMatrix.times(sparseMatrix2);
            l2 = System.currentTimeMillis() - l2;
            System.out.println(n13 + " " + l2 + " " + l);
            for (int j = 0; j < n3; ++j) {
                for (n8 = 0; n8 < n6; ++n8) {
                    if (dArray3[j][n8] == matrix.get(j, n8)) continue;
                    System.out.println("Error in " + j + " " + n8 + " : " + dArray3[j][n8] + " " + matrix.get(j, n8));
                    System.exit(0);
                }
            }
        }
    }

    @Override
    public NonZeroElementIterator getNonZeroElementIterator() {
        return new SparseVectorNonZeroElementIterator(this);
    }
}

