/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.util;

import java.util.Iterator;
import java.util.Map;
import scpsolver.util.NonZeroElementIterator;
import scpsolver.util.SparseMatrix;
import scpsolver.util.SparseVector;
import scpsolver.util.SparseVectorNonZeroElementIterator;

public class SparseMatrixNonZeroElementIterator
implements NonZeroElementIterator {
    SparseMatrix m;
    Iterator<Map.Entry<Integer, SparseVector>> entryiterator;
    SparseVectorNonZeroElementIterator actualrowit;
    int i;
    int j;
    int index;

    public SparseMatrixNonZeroElementIterator(SparseMatrix sparseMatrix) {
        this.m = sparseMatrix;
        this.entryiterator = sparseMatrix.vvectorlist.entrySet().iterator();
    }

    @Override
    public int getActuali() {
        return this.i;
    }

    @Override
    public int getActualj() {
        return this.j;
    }

    @Override
    public boolean hasNext() {
        if (this.entryiterator.hasNext()) {
            return true;
        }
        return this.actualrowit.hasNext();
    }

    @Override
    public Double next() {
        if (this.actualrowit == null || !this.actualrowit.hasNext()) {
            Map.Entry<Integer, SparseVector> entry = this.entryiterator.next();
            this.i = entry.getKey();
            this.actualrowit = new SparseVectorNonZeroElementIterator(entry.getValue());
        }
        double d = this.actualrowit.next();
        this.j = this.actualrowit.getActualj();
        return d;
    }

    @Override
    public void remove() {
    }

    public static void main(String[] stringArray) {
        SparseMatrix sparseMatrix = new SparseMatrix(1000, 1000);
        sparseMatrix.set(23, 42, 3.14);
        sparseMatrix.set(42, 23, 121.14);
        SparseMatrixNonZeroElementIterator sparseMatrixNonZeroElementIterator = new SparseMatrixNonZeroElementIterator(sparseMatrix);
        while (sparseMatrixNonZeroElementIterator.hasNext()) {
            double d = (Double)sparseMatrixNonZeroElementIterator.next();
            System.out.println(d + " " + sparseMatrixNonZeroElementIterator.getActuali() + " " + sparseMatrixNonZeroElementIterator.getActualj());
        }
    }
}

