/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Map;
import scpsolver.util.Matrix;
import scpsolver.util.NonSparseMatrix;
import scpsolver.util.NonZeroElementIterator;
import scpsolver.util.SparseMatrixNonZeroElementIterator;
import scpsolver.util.SparseVector;

public class SparseMatrix
implements Matrix {
    HashMap<Integer, SparseVector> vvectorlist;
    int rownum;
    int colnum;
    int initrowdim = 4;

    public SparseMatrix(int n, int n2) {
        this.rownum = n;
        this.colnum = n2;
        this.initrowdim = 4;
        this.vvectorlist = new HashMap();
    }

    public SparseMatrix(int n, int n2, int n3) {
        this.rownum = n;
        this.colnum = n2;
        this.initrowdim = n3;
        this.vvectorlist = new HashMap();
    }

    public static SparseMatrix readMTX(String string) {
        try {
            FileReader fileReader = new FileReader(string);
            StreamTokenizer streamTokenizer = new StreamTokenizer(new BufferedReader(fileReader));
            streamTokenizer.commentChar(37);
            streamTokenizer.nextToken();
            int n = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            int n2 = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            SparseMatrix sparseMatrix = new SparseMatrix(n, n2);
            int n3 = streamTokenizer.nextToken();
            while (n3 != -1) {
                int n4 = (int)streamTokenizer.nval;
                streamTokenizer.nextToken();
                int n5 = (int)streamTokenizer.nval;
                streamTokenizer.nextToken();
                double d = streamTokenizer.nval;
                sparseMatrix.set(n4, n5, d);
                n3 = streamTokenizer.nextToken();
            }
            return sparseMatrix;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public SparseMatrix(SparseMatrix sparseMatrix) {
        this.rownum = sparseMatrix.rownum;
        this.colnum = sparseMatrix.colnum;
        this.vvectorlist = new HashMap();
        for (Map.Entry<Integer, SparseVector> entry : sparseMatrix.vvectorlist.entrySet()) {
            int n = entry.getKey();
            SparseVector sparseVector = entry.getValue();
            this.vvectorlist.put(n, sparseVector.clone());
        }
    }

    public SparseMatrix clone() {
        return new SparseMatrix(this);
    }

    public SparseMatrix(double[][] dArray) {
        this.set(dArray);
    }

    public void set(double[][] dArray) {
        this.vvectorlist = new HashMap();
        for (int i = 0; i < dArray.length; ++i) {
            this.vvectorlist.put(i, new SparseVector(dArray[i]));
        }
        this.rownum = dArray.length;
        this.colnum = dArray[0].length;
    }

    @Override
    public double get(int n, int n2) {
        if (!this.vvectorlist.containsKey(n)) {
            return 0.0;
        }
        return this.vvectorlist.get(n).get(n2);
    }

    @Override
    public void set(int n, int n2, double d) {
        SparseVector sparseVector = this.vvectorlist.get(n);
        if (sparseVector == null) {
            sparseVector = this.initRow(n);
        }
        sparseVector.set(n2, d);
    }

    private SparseVector initRow(int n) {
        SparseVector sparseVector = new SparseVector(this.getColNum(), this.initrowdim);
        this.vvectorlist.put(n, sparseVector);
        return sparseVector;
    }

    @Override
    public int getRowNum() {
        return this.rownum;
    }

    @Override
    public int getColNum() {
        return this.colnum;
    }

    @Override
    public Matrix transpose() {
        SparseMatrix sparseMatrix = new SparseMatrix(this.getColNum(), this.getRowNum());
        for (Map.Entry<Integer, SparseVector> entry : this.vvectorlist.entrySet()) {
            int n = entry.getKey();
            SparseVector sparseVector = entry.getValue();
            int[] nArray = sparseVector.getIndex();
            double[] dArray = sparseVector.getData();
            for (int i = 0; i < sparseVector.getUsed(); ++i) {
                sparseMatrix.set(nArray[i], n, dArray[i]);
            }
        }
        return sparseMatrix;
    }

    @Override
    public Matrix times(Matrix matrix) {
        Matrix matrix2;
        block8: {
            block7: {
                matrix2 = null;
                if (!(matrix instanceof SparseMatrix)) break block7;
                SparseMatrix sparseMatrix = (SparseMatrix)matrix.transpose();
                if (this.getSparsity() < 0.2) {
                    matrix2 = new SparseMatrix(this.getRowNum(), matrix.getColNum());
                    for (Map.Entry<Integer, SparseVector> entry : this.vvectorlist.entrySet()) {
                        int n = entry.getKey();
                        SparseVector sparseVector = entry.getValue();
                        for (Map.Entry<Integer, SparseVector> entry2 : sparseMatrix.vvectorlist.entrySet()) {
                            int n2 = entry2.getKey();
                            SparseVector sparseVector2 = entry2.getValue();
                            matrix2.set(n, n2, sparseVector.dot(sparseVector2));
                        }
                    }
                } else {
                    NonSparseMatrix nonSparseMatrix = this.getNonSparseMatrix();
                    NonSparseMatrix nonSparseMatrix2 = ((SparseMatrix)matrix).getNonSparseMatrix();
                    matrix2 = nonSparseMatrix.times(nonSparseMatrix2);
                }
                break block8;
            }
            if (!(matrix instanceof SparseVector)) break block8;
            SparseVector sparseVector = (SparseVector)matrix;
            if (sparseVector.linevector) {
                matrix2 = this.vvectorlist.get(0).times(sparseVector);
            } else {
                matrix2 = new SparseVector(this.getRowNum(), 4);
                for (Map.Entry<Integer, SparseVector> entry : this.vvectorlist.entrySet()) {
                    int n = entry.getKey();
                    SparseVector sparseVector3 = entry.getValue();
                    matrix2.set(n, 0, sparseVector3.dot(sparseVector));
                }
            }
        }
        return matrix2;
    }

    @Override
    public Matrix plus(Matrix matrix) {
        SparseMatrix sparseMatrix = this.clone();
        if (matrix instanceof SparseMatrix) {
            SparseMatrix sparseMatrix2 = (SparseMatrix)matrix;
            for (Map.Entry<Integer, SparseVector> entry : sparseMatrix2.vvectorlist.entrySet()) {
                int n = entry.getKey();
                SparseVector sparseVector = entry.getValue();
                SparseVector sparseVector2 = sparseMatrix.vvectorlist.get(n);
                if (sparseVector2 != null) {
                    sparseVector2.add(sparseVector);
                    continue;
                }
                sparseMatrix.vvectorlist.put(n, sparseVector.clone());
            }
        } else {
            for (int i = 0; i < this.rownum; ++i) {
                for (int j = 0; j < this.colnum; ++j) {
                    sparseMatrix.set(i, j, sparseMatrix.get(i, j) + matrix.get(i, j));
                }
            }
        }
        return sparseMatrix;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SparseMatrix)) {
            throw new IllegalArgumentException("Illegal argument: object isn't of type SparseMatrix");
        }
        return this.equals((SparseMatrix)object);
    }

    public boolean equals(SparseMatrix sparseMatrix) {
        if (this.getRowNum() != sparseMatrix.getRowNum() || this.getColNum() != sparseMatrix.getColNum()) {
            return false;
        }
        for (int i = 0; i < this.getRowNum(); ++i) {
            for (int j = 0; j < this.getColNum(); ++j) {
                if (!(Math.abs(this.get(i, j) - sparseMatrix.get(i, j)) > 1.0E-4)) continue;
                return false;
            }
        }
        return true;
    }

    public SparseMatrix submatrix(int n, int n2) {
        SparseMatrix sparseMatrix = new SparseMatrix(n2 - n, n2 - n);
        for (Map.Entry<Integer, SparseVector> entry : this.vvectorlist.entrySet()) {
            int n3 = entry.getKey();
            if (n > n3 || n3 >= n2) continue;
            SparseVector sparseVector = entry.getValue();
            int[] nArray = sparseVector.getIndex();
            double[] dArray = sparseVector.getData();
            for (int i = 0; i < sparseVector.getUsed(); ++i) {
                if (n > nArray[i] || nArray[i] >= n2) continue;
                sparseMatrix.set(n3 - n, i - n, dArray[i]);
            }
        }
        return sparseMatrix;
    }

    public Matrix add(Matrix matrix) {
        if (!(matrix instanceof SparseMatrix)) {
            throw new IllegalArgumentException("Adding matrices is yet only supported for SparseMatrices");
        }
        SparseMatrix sparseMatrix = new SparseMatrix((SparseMatrix)matrix);
        for (Map.Entry<Integer, SparseVector> entry : this.vvectorlist.entrySet()) {
            int n = entry.getKey();
            if (!sparseMatrix.vvectorlist.containsKey(n)) {
                sparseMatrix.vvectorlist.put(n, new SparseVector(entry.getValue()));
                continue;
            }
            sparseMatrix.vvectorlist.put(n, entry.getValue().add(sparseMatrix.vvectorlist.get(n)));
        }
        return sparseMatrix;
    }

    public void grow(int n, int n2) {
        if (this.rownum != n || this.colnum != n) {
            boolean bl = n2 == 3 || n2 == 4;
            for (Map.Entry<Integer, SparseVector> entry : this.vvectorlist.entrySet()) {
                entry.getValue().grow(n, bl);
            }
            this.rownum = n;
            this.colnum = n;
        }
    }

    public void grow(Matrix matrix, int n) {
        if (!(matrix instanceof SparseMatrix)) {
            throw new IllegalArgumentException("Matrix-growing is yet only supported for SparseMatrices");
        }
        SparseMatrix sparseMatrix = new SparseMatrix((SparseMatrix)matrix);
        if (n == 1) {
            for (Map.Entry<Integer, SparseVector> entry : sparseMatrix.vvectorlist.entrySet()) {
                this.vvectorlist.put(entry.getKey() + this.colnum, new SparseVector(entry.getValue()));
            }
            this.colnum += sparseMatrix.colnum;
        } else if (n == 2) {
            for (Map.Entry<Integer, SparseVector> entry : this.vvectorlist.entrySet()) {
                this.vvectorlist.put(entry.getKey() + this.colnum, entry.getValue());
            }
            for (Map.Entry<Integer, SparseVector> entry : sparseMatrix.vvectorlist.entrySet()) {
                this.vvectorlist.put(entry.getKey(), new SparseVector(entry.getValue()));
            }
            this.colnum += sparseMatrix.colnum;
        } else if (n == 3) {
            // empty if block
        }
    }

    public int getNumberOfNonZeroElements() {
        int n = 0;
        for (SparseVector sparseVector : this.vvectorlist.values()) {
            n += sparseVector.getUsed();
        }
        return n;
    }

    public double getSparsity() {
        return (double)this.getNumberOfNonZeroElements() / (double)(this.getRowNum() * this.getColNum());
    }

    @Override
    public NonZeroElementIterator getNonZeroElementIterator() {
        return new SparseMatrixNonZeroElementIterator(this);
    }

    public int getNumberOfNonZeroRows() {
        return this.vvectorlist.size();
    }

    public NonSparseMatrix getNonSparseMatrix() {
        double[][] dArray = new double[this.getRowNum()][this.getColNum()];
        for (Map.Entry<Integer, SparseVector> entry : this.vvectorlist.entrySet()) {
            dArray[entry.getKey().intValue()] = entry.getValue().get();
        }
        return new NonSparseMatrix(dArray);
    }
}

