/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.util;

import scpsolver.util.Matrix;
import scpsolver.util.NonZeroElementIterator;

public class NonSparseMatrix
implements Matrix {
    double[][] m;

    public NonSparseMatrix(double[][] dArray) {
        this.m = dArray;
    }

    @Override
    public double get(int n, int n2) {
        return this.m[n][n2];
    }

    @Override
    public int getColNum() {
        return this.m[0].length;
    }

    @Override
    public NonZeroElementIterator getNonZeroElementIterator() {
        return null;
    }

    @Override
    public int getRowNum() {
        return this.m.length;
    }

    @Override
    public Matrix plus(Matrix matrix) {
        return null;
    }

    @Override
    public void set(int n, int n2, double d) {
        this.m[n][n2] = d;
    }

    @Override
    public Matrix times(Matrix matrix) {
        double[][] dArray = new double[this.getRowNum()][matrix.getColNum()];
        for (int i = 0; i < this.getRowNum(); ++i) {
            for (int j = 0; j < matrix.getColNum(); ++j) {
                double d = 0.0;
                for (int k = 0; k < this.getColNum(); ++k) {
                    d += this.m[i][k] * matrix.get(k, j);
                }
                dArray[i][j] = d;
            }
        }
        return new NonSparseMatrix(dArray);
    }

    @Override
    public Matrix transpose() {
        double[][] dArray = new double[this.getColNum()][this.getRowNum()];
        for (int i = 0; i < this.getRowNum(); ++i) {
            for (int j = 0; j < this.getColNum(); ++j) {
                dArray[j][i] = this.m[i][j];
            }
        }
        return new NonSparseMatrix(this.m);
    }
}

