/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.qpsolver;

import java.util.ArrayList;
import scpsolver.constraints.Constraint;
import scpsolver.constraints.LinearBiggerThanEqualsConstraint;
import scpsolver.constraints.LinearSmallerThanEqualsConstraint;
import scpsolver.lpsolver.SolverFactory;
import scpsolver.problems.ConstrainedProblem;
import scpsolver.problems.MathematicalProgram;
import scpsolver.qpsolver.QuadraticProgramSolver;
import scpsolver.util.Matrix;
import scpsolver.util.SparseMatrix;
import scpsolver.util.SparseVector;

public class QuadraticProgram
extends MathematicalProgram
implements ConstrainedProblem {
    Matrix Q;

    public Matrix getQ() {
        return this.Q;
    }

    public void setQ(Matrix matrix) {
        this.Q = matrix;
    }

    public QuadraticProgram(Matrix matrix, SparseVector sparseVector) {
        this.Q = matrix;
        this.c = sparseVector;
        this.isinteger = new boolean[this.getDimension()];
    }

    public QuadraticProgram(double[][] dArray, double[] dArray2) {
        this.constraints = new ArrayList();
        this.setQ(dArray);
        this.c = new SparseVector(dArray2);
        this.isinteger = new boolean[this.getDimension()];
    }

    public QuadraticProgram(double[][] dArray) {
        this.constraints = new ArrayList();
        this.setQ(dArray);
        this.c = new SparseVector(dArray.length, 1);
        this.isinteger = new boolean[this.getDimension()];
    }

    @Override
    public double evaluate(double[] dArray) {
        SparseVector sparseVector = new SparseVector(dArray);
        Matrix matrix = sparseVector.transpose().times(this.Q).times(sparseVector);
        matrix = ((SparseVector)matrix).times(0.5);
        Matrix matrix2 = this.c.transpose().times(sparseVector);
        System.out.println("Here:" + matrix2.get(0, 0));
        Matrix matrix3 = matrix.plus(matrix2);
        return matrix3.get(0, 0);
    }

    public void setQ(double[][] dArray) {
        this.Q = new SparseMatrix(dArray);
    }

    public boolean addConstraint(Constraint constraint) {
        return this.constraints.add(constraint);
    }

    @Override
    public boolean isFeasable(double[] dArray) {
        for (Constraint constraint : this.constraints) {
            if (constraint.isSatisfiedBy(dArray)) continue;
            return false;
        }
        return true;
    }

    public ArrayList<Constraint> getViolatedContraints(double[] dArray) {
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
        for (Constraint constraint : this.constraints) {
            if (constraint.isSatisfiedBy(dArray)) continue;
            arrayList.add(constraint);
        }
        return arrayList;
    }

    @Override
    public int getDimension() {
        return this.c.getSize();
    }

    @Override
    public ArrayList<Constraint> getConstraints() {
        return this.constraints;
    }

    @Override
    public String getName() {
        return "Quadratic Progam";
    }

    @Override
    public boolean isMinProblem() {
        return this.minproblem;
    }

    @Override
    public void setMinProblem(boolean bl) {
        this.minproblem = bl;
    }

    public static void main(String[] stringArray) {
        QuadraticProgram quadraticProgram = new QuadraticProgram(new double[][]{{-1.0, 0.0}, {0.0, -1.0}}, new double[]{0.0, 0.0});
        quadraticProgram.addConstraint(new LinearSmallerThanEqualsConstraint(new double[]{3.0, 16.0}, 20.0, "A"));
        quadraticProgram.addConstraint(new LinearBiggerThanEqualsConstraint(new double[]{1.0, 0.0}, 2.0, "B"));
        quadraticProgram.addConstraint(new LinearBiggerThanEqualsConstraint(new double[]{1.0, 0.0}, 2.0, "B"));
        quadraticProgram.setMinProblem(false);
        QuadraticProgramSolver quadraticProgramSolver = (QuadraticProgramSolver)((Object)SolverFactory.newDefault());
        double[] dArray = quadraticProgramSolver.solve(quadraticProgram);
        for (int i = 0; i < dArray.length; ++i) {
            System.out.println(i + " " + dArray[i]);
        }
    }
}

