/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.problems;

import java.util.ArrayList;
import scpsolver.constraints.Constraint;
import scpsolver.constraints.LinearConstraint;
import scpsolver.constraints.StochasticConstraint;
import scpsolver.problems.ConstrainedProblem;
import scpsolver.problems.LinearProgram;
import scpsolver.problems.MathematicalProgram;
import scpsolver.util.SparseVector;

public class StochasticProgram
extends MathematicalProgram
implements ConstrainedProblem {
    private double[] probabilities;
    private SparseVector[] scenarios;

    public StochasticProgram(double[] dArray, double[] dArray2, double[][] dArray3) {
        this.minproblem = false;
        this.constraints = new ArrayList();
        this.c = new SparseVector(dArray);
        this.probabilities = dArray2;
        this.scenarios = new SparseVector[dArray3.length];
        for (int i = 0; i < dArray3.length; ++i) {
            this.scenarios[i] = new SparseVector(dArray3[i]);
        }
    }

    public StochasticProgram(SparseVector sparseVector, double[] dArray, SparseVector[] sparseVectorArray) {
        this.minproblem = false;
        this.constraints = new ArrayList();
        this.c = sparseVector;
        this.probabilities = dArray;
        this.scenarios = sparseVectorArray;
    }

    public boolean addConstraint(LinearConstraint linearConstraint) {
        return this.constraints.add(linearConstraint);
    }

    public boolean addConstraint(StochasticConstraint stochasticConstraint) {
        return this.constraints.add(stochasticConstraint);
    }

    @Override
    public ArrayList<Constraint> getConstraints() {
        return this.constraints;
    }

    @Override
    public void setUpperbound(double[] dArray) {
        double[] dArray2 = new double[this.c.getSize() + this.probabilities.length * this.scenarios[0].getSize()];
        System.arraycopy(dArray, 0, dArray2, 0, this.c.getSize());
        for (int i = 0; i < this.scenarios.length; ++i) {
            System.arraycopy(dArray, this.c.getSize(), dArray2, this.c.getSize() + i * this.scenarios[i].getSize(), this.scenarios[i].getSize());
        }
        super.setUpperbound(dArray2);
    }

    @Override
    public void setLowerbound(double[] dArray) {
        double[] dArray2 = new double[this.c.getSize() + this.probabilities.length * this.scenarios[0].getSize()];
        System.arraycopy(dArray, 0, dArray2, 0, this.c.getSize());
        for (int i = 0; i < this.scenarios.length; ++i) {
            System.arraycopy(dArray, this.c.getSize(), dArray2, this.c.getSize() + i * this.scenarios[i].getSize(), this.scenarios[i].getSize());
        }
        super.setLowerbound(dArray2);
    }

    @Override
    public boolean isFeasable(double[] dArray) {
        for (Constraint constraint : this.constraints) {
            if (constraint instanceof LinearConstraint) {
                double[] dArray2 = new double[this.c.getSize()];
                System.arraycopy(dArray, 0, dArray2, 0, this.c.getSize());
                if (constraint.isSatisfiedBy(dArray2)) continue;
                return false;
            }
            if (!(constraint instanceof StochasticConstraint) || constraint.isSatisfiedBy(dArray)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double evaluate(double[] dArray) {
        double[][] dArrayArray = new double[this.probabilities.length][];
        for (int i = 0; i < dArrayArray.length; ++i) {
            System.arraycopy(dArray, this.c.getSize() + i * this.scenarios[i].getSize(), dArrayArray[i], 0, this.scenarios[i].getSize());
        }
        double[] dArray2 = new double[this.c.getSize()];
        System.arraycopy(dArray, 0, dArray2, 0, this.c.getSize());
        double d = this.c.dot(dArray2);
        for (int i = 0; i < dArrayArray.length; ++i) {
            d += this.probabilities[i] * this.scenarios[i].dot(dArrayArray[i]);
        }
        return d;
    }

    @Override
    public String getName() {
        return "Stochastic Program";
    }

    public LinearProgram getExtensiveForm() {
        int n = this.scenarios[0].getSize();
        double[] dArray = new double[this.c.getSize() + this.probabilities.length * n];
        System.arraycopy(this.c.get(), 0, dArray, 0, this.c.getSize());
        for (int i = 0; i < this.probabilities.length; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray[this.c.getSize() + i * n + j] = this.probabilities[i] * this.scenarios[i].get(j);
            }
        }
        LinearProgram linearProgram = new LinearProgram(dArray);
        for (Constraint constraint : this.constraints) {
            if (constraint instanceof LinearConstraint) {
                linearProgram.addConstraint((LinearConstraint)constraint);
                continue;
            }
            if (!(constraint instanceof StochasticConstraint)) continue;
            for (LinearConstraint linearConstraint : ((StochasticConstraint)constraint).getExtensiveForm()) {
                linearProgram.addConstraint(linearConstraint);
            }
        }
        linearProgram.setLowerbound(this.getLowerbound());
        linearProgram.setUpperbound(this.getUpperbound());
        linearProgram.setMinProblem(this.isMinProblem());
        return linearProgram;
    }
}

