/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.problems;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import scpsolver.constraints.Constraint;
import scpsolver.constraints.LinearEqualsConstraint;
import scpsolver.constraints.LinearSmallerThanEqualsConstraint;
import scpsolver.lpsolver.LinearProgramSolver;
import scpsolver.lpsolver.SolverFactory;
import scpsolver.problems.LinearProgram;

public class QuadraticAssignmentProblem {
    double[][] A;
    double[][] B;
    double[][] C;

    public QuadraticAssignmentProblem(double[][] dArray, double[][] dArray2) {
        this.A = dArray;
        this.B = dArray2;
        this.C = new double[dArray.length][dArray.length];
    }

    public QuadraticAssignmentProblem(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        this.A = dArray;
        this.B = dArray2;
        this.C = dArray3;
    }

    public double evaluate(int[][] nArray) {
        int n;
        int n2;
        double d = 0.0;
        int n3 = this.getDimension();
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        d += this.A[n2][i] * this.B[n][j] * (double)nArray[n2][n] * (double)nArray[i][j];
                    }
                }
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                d += this.C[n2][n] * (double)nArray[n2][n];
            }
        }
        return d;
    }

    public QuadraticAssignmentProblem(String string) {
        try {
            int n;
            String[] stringArray;
            int n2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = "";
            string2 = bufferedReader.readLine();
            int n3 = Integer.parseInt(string2.trim());
            this.A = new double[n3][n3];
            this.B = new double[n3][n3];
            this.C = new double[n3][n3];
            bufferedReader.readLine();
            for (n2 = 0; n2 < n3; ++n2) {
                string2 = bufferedReader.readLine().trim();
                stringArray = string2.split("\\s+");
                for (n = 0; n < stringArray.length; ++n) {
                    this.A[n2][n] = Double.parseDouble(stringArray[n].trim());
                    System.out.print(this.A[n2][n] + " ");
                }
                System.out.println();
                for (n = stringArray.length; n < n3; ++n) {
                    this.A[n2][n] = Double.POSITIVE_INFINITY;
                    System.out.println("assymetry in flow matrix");
                }
            }
            bufferedReader.readLine();
            for (n2 = 0; n2 < n3; ++n2) {
                string2 = bufferedReader.readLine().trim();
                stringArray = string2.split("\\s+");
                for (n = 0; n < stringArray.length; ++n) {
                    this.B[n2][n] = Double.parseDouble(stringArray[n].trim());
                    System.out.print(this.B[n2][n] + " ");
                }
                System.out.println();
                for (n = stringArray.length; n < n3; ++n) {
                    this.B[n2][n] = Double.POSITIVE_INFINITY;
                    System.out.println("assymetry in distance matrix");
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
            }
        }
        catch (Exception exception) {
            System.out.print("Cannot read line in file " + string);
            exception.printStackTrace();
        }
    }

    public double[][] getA() {
        return this.A;
    }

    public void setA(double[][] dArray) {
        this.A = dArray;
    }

    public double[][] getB() {
        return this.B;
    }

    public void setB(double[][] dArray) {
        this.B = dArray;
    }

    public int getDimension() {
        return this.A.length;
    }

    public LinearProgram getAdamJohnsonLinearization() {
        int n = this.getDimension();
        double[] dArray = new double[n * n + n * n * n * n];
        for (int i = 0; i < n * n; ++i) {
            dArray[i] = 1.0;
        }
        LinearProgram linearProgram = new LinearProgram(dArray);
        linearProgram.setMinProblem(true);
        return null;
    }

    public LinearProgram getKaufmannBroeckxLinearization() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.getDimension();
        double[] dArray = new double[2 * n5 * n5];
        for (n4 = 0; n4 < n5 * n5; ++n4) {
            dArray[n4] = 1.0;
        }
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 < n5; ++n3) {
                dArray[n5 * n5 + n4 * n5 + n3] = this.C[n4][n3];
            }
        }
        LinearProgram linearProgram = new LinearProgram(dArray);
        linearProgram.setMinProblem(true);
        for (n3 = n5 * n5; n3 < dArray.length; ++n3) {
            linearProgram.setBinary(n3);
        }
        for (n3 = 0; n3 < n5; ++n3) {
            double[] dArray2 = (double[])this.A[n3].clone();
            Arrays.sort(dArray2);
            for (n2 = 0; n2 < n5; ++n2) {
                double[] dArray3 = (double[])this.B[n2].clone();
                Arrays.sort(dArray3);
                double d = 0.0;
                for (int i = 0; i < dArray3.length; ++i) {
                    d += dArray2[i] * dArray3[i];
                }
                double d2 = d;
                double[] dArray4 = new double[dArray.length];
                dArray4[n3 * n5 + n2] = -1.0;
                dArray4[n5 * n5 + n3 * n5 + n2] = d2;
                for (int i = 0; i < n5; ++i) {
                    for (int j = 0; j < n5; ++j) {
                        int n6 = n5 * n5 + i * n5 + j;
                        dArray4[n6] = dArray4[n6] + this.A[n3][i] * this.B[n2][j];
                    }
                }
                System.out.println(n3 + " " + n2 + ":" + d2);
                linearProgram.addConstraint(new LinearSmallerThanEqualsConstraint(dArray4, d2, "special u_" + n3 + "_" + n2));
            }
        }
        double[] dArray5 = new double[dArray.length];
        for (n = 0; n < this.getDimension(); ++n) {
            for (n2 = 0; n2 < this.getDimension(); ++n2) {
                dArray5[n * n5 + n2] = 0.0;
            }
        }
        linearProgram.setLowerbound(dArray5);
        for (n = 0; n < this.getDimension(); ++n) {
            double[] dArray6 = new double[dArray.length];
            for (int i = 0; i < this.getDimension(); ++i) {
                dArray6[n5 * n5 + n * n5 + i] = 1.0;
            }
            linearProgram.addConstraint(new LinearEqualsConstraint(dArray6, 1.0, "x_" + n + "j"));
        }
        for (n = 0; n < this.getDimension(); ++n) {
            double[] dArray7 = new double[dArray.length];
            for (int i = 0; i < this.getDimension(); ++i) {
                dArray7[n5 * n5 + i * n5 + n] = 1.0;
            }
            linearProgram.addConstraint(new LinearEqualsConstraint(dArray7, 1.0, "x_i" + n));
        }
        return linearProgram;
    }

    public LinearProgram getPlanatscherContraintHeurstic(double d, double d2) {
        int n;
        int n2;
        int n3;
        int n4 = this.getDimension();
        double[] dArray = new double[n4 * n4];
        for (int i = 0; i < n4; ++i) {
            for (n3 = 0; n3 < n4; ++n3) {
                dArray[i * n4 + n3] = this.C[i][n3];
            }
        }
        LinearProgram linearProgram = new LinearProgram(dArray);
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                linearProgram.setBinary(n3 * n4 + n2);
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                if (!(this.A[n3][n2] > d)) continue;
                for (n = 0; n < n4; ++n) {
                    for (int i = 0; i < n4; ++i) {
                        if (!(this.B[n][i] > d2)) continue;
                        double[] dArray2 = new double[n4 * n4];
                        dArray2[n3 * n4 + i] = 1.0;
                        dArray2[n2 * n4 + n] = 1.0;
                        LinearSmallerThanEqualsConstraint linearSmallerThanEqualsConstraint = new LinearSmallerThanEqualsConstraint(dArray2, 1.0, "crossing " + n3 + " (" + "," + n + "),(" + n2 + "," + i + ")");
                        linearProgram.addConstraint(linearSmallerThanEqualsConstraint);
                    }
                }
            }
        }
        for (n3 = 0; n3 < this.getDimension(); ++n3) {
            double[] dArray3 = new double[dArray.length];
            for (n = 0; n < this.getDimension(); ++n) {
                dArray3[n3 * n4 + n] = 1.0;
            }
            linearProgram.addConstraint(new LinearEqualsConstraint(dArray3, 1.0, "x_" + n3 + "j"));
        }
        for (n3 = 0; n3 < this.getDimension(); ++n3) {
            double[] dArray4 = new double[dArray.length];
            for (n = 0; n < this.getDimension(); ++n) {
                dArray4[n * n4 + n3] = 1.0;
            }
            linearProgram.addConstraint(new LinearEqualsConstraint(dArray4, 1.0, "x_i" + n3));
        }
        double[] dArray5 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray5[i] = 0.0;
        }
        linearProgram.setLowerbound(dArray5);
        linearProgram.setMinProblem(true);
        return linearProgram;
    }

    public static void main(String[] stringArray) {
        int n;
        QuadraticAssignmentProblem quadraticAssignmentProblem = new QuadraticAssignmentProblem("/home/planatsc/Desktop/nug12.dat");
        LinearProgram linearProgram = quadraticAssignmentProblem.getKaufmannBroeckxLinearization();
        LinearProgramSolver linearProgramSolver = SolverFactory.newDefault();
        double[] dArray = linearProgramSolver.solve(linearProgram);
        int n2 = quadraticAssignmentProblem.getDimension();
        int[][] nArray = new int[n2][n2];
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                nArray[n][i] = (int)dArray[n2 * n2 + n * n2 + i];
                if (nArray[n][i] != 1) continue;
                System.out.print(n + 1 + "=>" + (i + 1) + " (" + dArray[n2 * n2 + n * n2 + i] + ", ");
                System.out.println(dArray[n * n2 + i] + ")");
            }
        }
        for (n = 0; n < n2; ++n) {
            double[] dArray2 = (double[])quadraticAssignmentProblem.A[n].clone();
            Arrays.sort(dArray2);
            for (int i = 0; i < n2; ++i) {
                nArray[n][i] = (int)dArray[n2 * n2 + n * n2 + i];
                if (nArray[n][i] != 1) continue;
                double[] dArray3 = (double[])quadraticAssignmentProblem.B[i].clone();
                Arrays.sort(dArray3);
                double d = 0.0;
                for (int j = 0; j < dArray3.length; ++j) {
                    d += dArray2[j] * dArray3[j];
                }
                double d2 = d;
                double d3 = 0.0;
                for (int j = 0; j < n2; ++j) {
                    for (int k = 0; k < n2; ++k) {
                        d3 += quadraticAssignmentProblem.A[n][j] * quadraticAssignmentProblem.B[n][k] * (double)nArray[j][k];
                    }
                }
                System.out.println(d2 + " + " + d3 + " - " + dArray[n * n2 + i] + " <= " + d2);
            }
        }
        ArrayList<Constraint> arrayList = linearProgram.getConstraints();
        for (Constraint constraint : arrayList) {
            if (constraint.isSatisfiedBy(dArray)) continue;
            System.out.println(constraint.getName() + " not satisfied!");
        }
        System.out.println();
        System.out.println("optimum: " + quadraticAssignmentProblem.evaluate(nArray));
    }
}

