/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.problems;

import java.util.ArrayList;
import scpsolver.constraints.Constraint;
import scpsolver.util.Matrix;
import scpsolver.util.SparseVector;

public abstract class MathematicalProgram {
    protected SparseVector c;
    protected ArrayList<Constraint> constraints = new ArrayList();
    protected boolean[] isinteger;
    protected boolean[] isboolean;
    protected boolean minproblem;
    protected double[] upperbound;
    protected double[] lowerbound;

    public void setInteger(int n) {
        this.getIsinteger()[n] = true;
    }

    public void setContinous(int n) {
        this.getIsinteger()[n] = false;
    }

    public double[] getC() {
        return this.c.get();
    }

    public void setC(Matrix matrix) {
        this.c = new SparseVector(matrix);
        this.isinteger = new boolean[this.c.getRowNum()];
        this.isboolean = new boolean[this.c.getRowNum()];
    }

    public int getDimension() {
        return this.c.getRowNum();
    }

    public boolean isMIP() {
        if (this.getIsinteger() == null) {
            return false;
        }
        for (int i = 0; i < this.getIsinteger().length; ++i) {
            if (!this.getIsinteger()[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isMinProblem() {
        return this.minproblem;
    }

    public void setMinProblem(boolean bl) {
        this.minproblem = bl;
    }

    public boolean hasBounds() {
        return this.lowerbound != null && this.upperbound != null;
    }

    public double[] getLowerbound() {
        return this.lowerbound;
    }

    public void setLowerbound(double[] dArray) {
        this.lowerbound = dArray;
        if (this.upperbound == null) {
            this.setUpperbound(MathematicalProgram.makeDoubleArray(dArray.length, Double.MAX_VALUE));
        }
    }

    public double[] getUpperbound() {
        return this.upperbound;
    }

    public static double[] makeDoubleArray(int n, double d) {
        double[] dArray = new double[n];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = d;
        }
        return dArray;
    }

    public void setUpperbound(double[] dArray) {
        this.upperbound = dArray;
        if (this.lowerbound == null) {
            this.setLowerbound(MathematicalProgram.makeDoubleArray(dArray.length, -1.7976931348623157E308));
        }
    }

    public void setIsinteger(boolean[] blArray) {
        this.isinteger = blArray;
    }

    public boolean[] getIsinteger() {
        return this.isinteger;
    }

    public boolean[] getIsboolean() {
        return this.isboolean;
    }
}

