/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.problems;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import scpsolver.constraints.Constraint;
import scpsolver.constraints.Convertable;
import scpsolver.constraints.LinearBiggerThanEqualsConstraint;
import scpsolver.constraints.LinearConstraint;
import scpsolver.constraints.LinearSmallerThanEqualsConstraint;
import scpsolver.lpsolver.LinearProgramSolver;
import scpsolver.lpsolver.SolverFactory;
import scpsolver.problems.ConstrainedProblem;
import scpsolver.problems.MathematicalProgram;
import scpsolver.util.SparseVector;

public class LinearProgram
extends MathematicalProgram
implements ConstrainedProblem {
    HashMap<String, Integer> indexmap;

    public void setBinary(int n) {
        this.isboolean[n] = true;
        this.isinteger[n] = true;
    }

    public LinearProgram() {
        this.minproblem = false;
        this.constraints = new ArrayList();
    }

    public LinearProgram(double[] dArray) {
        this.minproblem = false;
        this.constraints = new ArrayList();
        this.c = new SparseVector(dArray);
        this.isinteger = new boolean[dArray.length];
        this.isboolean = new boolean[dArray.length];
    }

    public LinearProgram(SparseVector sparseVector) {
        this.minproblem = false;
        this.constraints = new ArrayList();
        this.c = sparseVector;
        this.isinteger = new boolean[sparseVector.getSize()];
        this.isboolean = new boolean[sparseVector.getSize()];
    }

    public LinearProgram(LinearProgram linearProgram) {
        this.minproblem = linearProgram.minproblem;
        this.isinteger = (boolean[])linearProgram.isinteger.clone();
        this.isboolean = (boolean[])linearProgram.isboolean.clone();
        this.c = linearProgram.c.clone();
        this.constraints = (ArrayList)linearProgram.constraints.clone();
        if (linearProgram.hasBounds()) {
            this.upperbound = (double[])linearProgram.upperbound.clone();
            this.lowerbound = (double[])linearProgram.lowerbound.clone();
        }
    }

    public void setConstraints(ArrayList<Constraint> arrayList) {
        this.constraints = arrayList;
    }

    public boolean addConstraint(LinearConstraint linearConstraint) {
        return this.constraints.add(linearConstraint);
    }

    public boolean addConstraints(ArrayList<LinearConstraint> arrayList) {
        return this.constraints.addAll(arrayList);
    }

    @Override
    public boolean isFeasable(double[] dArray) {
        for (Constraint constraint : this.constraints) {
            if (constraint.isSatisfiedBy(dArray)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ArrayList<Constraint> getConstraints() {
        return this.constraints;
    }

    @Override
    public double evaluate(double[] dArray) {
        return this.c.dot(dArray);
    }

    @Override
    public String getName() {
        return "Linear Program";
    }

    public StringBuffer convertToCPLEX() {
        if (this.indexmap == null) {
            // empty if block
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\\ This file is autogenerated by the SCPSolver framework\n");
        stringBuffer.append("\\ Modify at your own risk\n\n");
        stringBuffer.append(this.minproblem ? "MINIMIZE\n" : "MAXIMIZE\n");
        stringBuffer.append(" obj:");
        for (int i = 0; i < this.getC().length; ++i) {
            Object object = new BigDecimal(this.getC()[i]);
            if (((BigDecimal)object).signum() < 0) {
                stringBuffer.append(" -");
            } else if (i > 0) {
                stringBuffer.append(" + ");
            } else if (i == 0) {
                stringBuffer.append(" ");
            }
            if (((BigDecimal)object).abs().intValue() != 1) {
                stringBuffer.append(((BigDecimal)object).abs().toString());
            }
            stringBuffer.append(" x" + i);
        }
        stringBuffer.append("\n");
        stringBuffer.append("SUBJECT TO\n");
        for (Object object : this.constraints) {
            stringBuffer.append(((Convertable)object).convertToCPLEX());
        }
        if (this.hasBounds()) {
            stringBuffer.append("Bounds\n");
            for (int i = 0; i < this.upperbound.length; ++i) {
                if (this.lowerbound[i] == -1.7976931348623157E308) {
                    stringBuffer.append(" -infinity");
                } else {
                    stringBuffer.append(" " + this.lowerbound[i]);
                }
                stringBuffer.append(" <= x" + i + " <= ");
                if (this.upperbound[i] == Double.MAX_VALUE) {
                    stringBuffer.append("+infinity\n");
                    continue;
                }
                stringBuffer.append(this.upperbound[i] + "\n");
            }
        }
        boolean bl = false;
        for (int i = 0; i < this.isinteger.length; ++i) {
            if (this.isinteger[i] && !bl) {
                stringBuffer.append("GENERAL\n");
                bl = true;
            }
            if (!this.isinteger[i]) continue;
            stringBuffer.append(" x" + i + "\n");
        }
        if (bl) {
            stringBuffer.append("\n");
        }
        stringBuffer.append("END\n");
        return stringBuffer;
    }

    public HashMap<String, Integer> getIndexmap() {
        return this.indexmap;
    }

    public void setIndexmap(HashMap<String, Integer> hashMap) {
        this.indexmap = hashMap;
    }

    public static void main(String[] stringArray) {
        LinearProgram linearProgram = new LinearProgram(new double[]{10.0, 6.0, 4.0});
        linearProgram.addConstraint(new LinearSmallerThanEqualsConstraint(new double[]{1.0, 1.0, 1.0}, 320.0, "p"));
        linearProgram.addConstraint(new LinearSmallerThanEqualsConstraint(new double[]{10.0, 4.0, 5.0}, 650.0, "q"));
        linearProgram.addConstraint(new LinearBiggerThanEqualsConstraint(new double[]{2.0, -2.0, 6.0}, 100.0, "r1"));
        linearProgram.setLowerbound(new double[]{30.0, 0.0, 0.0});
        linearProgram.setInteger(2);
        System.out.print(linearProgram.convertToCPLEX());
        System.out.println();
        linearProgram = new LinearProgram(new double[]{25.0, 30.0});
        linearProgram.addConstraint(new LinearSmallerThanEqualsConstraint(new double[]{0.005, 0.007142857142857143}, 40.0, "Time"));
        linearProgram.setLowerbound(new double[]{0.0, 0.0});
        linearProgram.setUpperbound(new double[]{6000.0, 4000.0});
        linearProgram.setInteger(0);
        linearProgram.setInteger(1);
        System.out.println();
        LinearProgramSolver linearProgramSolver = SolverFactory.getSolver("GLPK");
        linearProgramSolver.solve(linearProgram);
        System.out.println("Abs von -2.0: " + Math.abs(-2.0));
        System.out.println("Signum von -2.0: " + Math.signum(-2.0));
    }
}

