/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.problems;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import scpsolver.constraints.LinearBiggerThanEqualsConstraint;
import scpsolver.constraints.LinearEqualsConstraint;
import scpsolver.constraints.LinearSmallerThanEqualsConstraint;
import scpsolver.lpsolver.LinearProgramSolver;
import scpsolver.lpsolver.SolverFactory;
import scpsolver.problems.LPSolution;
import scpsolver.problems.LPWizardConstraint;
import scpsolver.problems.LinearProgram;
import scpsolver.util.SparseVector;

public class LPWizard {
    ArrayList<String> variables = new ArrayList();
    ArrayList<Double> weights = new ArrayList();
    boolean minProblem = true;
    HashMap<String, HashSet<String>> vargroups = new HashMap();
    HashMap<String, LPWizardConstraint> constraints = new HashMap();
    HashMap<String, HashSet<LPWizardConstraint>> constraintgroups = new HashMap();
    HashSet<String> integervariables = new HashSet();
    HashSet<String> booleanvariables = new HashSet();
    boolean allvariablesinteger = false;

    public boolean isMinProblem() {
        return this.minProblem;
    }

    public void setMinProblem(boolean bl) {
        this.minProblem = bl;
    }

    public LPWizard plus(String string, double d) {
        int n = this.variables.indexOf(string);
        if (n == -1) {
            this.variables.add(string);
            this.weights.add(d);
        } else {
            this.weights.set(n, d);
        }
        return this;
    }

    public LPWizard plus(String string, double d, String string2) {
        if (this.vargroups.containsKey(string2)) {
            this.vargroups.get(string2).add(string);
        } else {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string);
            this.vargroups.put(string2, hashSet);
        }
        return this.plus(string, d);
    }

    public LPWizard plus(String string) {
        return this.plus(string, 1.0);
    }

    public LPWizard plus(String string, String string2) {
        return this.plus(string, 1.0, string2);
    }

    public LPWizardConstraint addConstraint(String string, double d, String string2) {
        byte by = 0;
        if (string2.equalsIgnoreCase("<=")) {
            by = 0;
        }
        if (string2.equalsIgnoreCase(">=")) {
            by = 1;
        }
        if (string2.equalsIgnoreCase("=")) {
            by = 2;
        }
        LPWizardConstraint lPWizardConstraint = new LPWizardConstraint(by, d, this);
        this.constraints.put(string, lPWizardConstraint);
        return lPWizardConstraint;
    }

    public void addAlternative(String string, String string2) {
        this.addConstraint(string + "VS" + string2, 1.0, "=").plus(string).plus(string2).setAllVariablesBoolean();
        this.addConstraint(string + "VS" + "not" + string, 1.0, "=").plus(string).plus("not_" + string).setAllVariablesBoolean();
        this.addConstraint(string2 + "VS" + "not" + string2, 1.0, "=").plus(string2).plus("not_" + string2).setAllVariablesBoolean();
    }

    public void setBoolean(String string) {
        this.booleanvariables.add(string);
    }

    public void setInteger(String string) {
        this.integervariables.add(string);
    }

    public void setAllVariablesInteger() {
        this.allvariablesinteger = true;
    }

    public LPSolution solve(LinearProgramSolver linearProgramSolver) {
        LinearProgram linearProgram = this.getLP();
        double[] dArray = linearProgramSolver.solve(linearProgram);
        LPSolution lPSolution = new LPSolution(dArray, linearProgram);
        return lPSolution;
    }

    public LPSolution solve() {
        return this.solve(SolverFactory.newDefault());
    }

    public LinearProgram getLP() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.variables);
        for (LPWizardConstraint lPWizardConstraint : this.constraints.values()) {
            hashSet.addAll(lPWizardConstraint.variables);
        }
        HashMap hashMap = new HashMap();
        int n = 0;
        for (String object2 : hashSet) {
            hashMap.put(object2, n++);
        }
        int n2 = hashSet.size();
        SparseVector sparseVector = new SparseVector(n2, this.variables.size());
        for (int linearProgram = 0; linearProgram < this.variables.size(); ++linearProgram) {
            sparseVector.set((Integer)hashMap.get(this.variables.get(linearProgram)), this.weights.get(linearProgram));
        }
        LinearProgram linearProgram = new LinearProgram(sparseVector);
        linearProgram.setIndexmap(hashMap);
        for (Map.Entry<String, LPWizardConstraint> entry : this.constraints.entrySet()) {
            LPWizardConstraint lPWizardConstraint = entry.getValue();
            String string = entry.getKey();
            SparseVector sparseVector2 = new SparseVector(n2, lPWizardConstraint.variables.size());
            for (int i = 0; i < lPWizardConstraint.variables.size(); ++i) {
                sparseVector2.set((Integer)hashMap.get(lPWizardConstraint.variables.get(i)), lPWizardConstraint.weights.get(i));
            }
            switch (lPWizardConstraint.type) {
                case 0: {
                    linearProgram.addConstraint(new LinearBiggerThanEqualsConstraint(sparseVector2, lPWizardConstraint.t, string));
                    break;
                }
                case 1: {
                    linearProgram.addConstraint(new LinearSmallerThanEqualsConstraint(sparseVector2, lPWizardConstraint.t, string));
                    break;
                }
                case 2: {
                    linearProgram.addConstraint(new LinearEqualsConstraint(sparseVector2, lPWizardConstraint.t, string));
                    break;
                }
            }
        }
        if (this.allvariablesinteger) {
            this.integervariables.addAll(this.variables);
        }
        for (String string : this.integervariables) {
            linearProgram.setInteger((Integer)hashMap.get(string));
        }
        for (String string : this.booleanvariables) {
            linearProgram.setBinary((Integer)hashMap.get(string));
        }
        linearProgram.setMinProblem(this.minProblem);
        return linearProgram;
    }

    public static void main(String[] stringArray) {
        LPWizard lPWizard = new LPWizard();
        lPWizard.plus("Wheat", 226.0).plus("Rye", 198.0);
        lPWizard.addConstraint("Area", 50.0, ">=").plus("Wheat", 0.15).plus("Rye", 0.2).setAllVariablesBoolean();
        lPWizard.addConstraint("Labour", 5000.0, ">=").plus("Wheat", 80.0).plus("Rye", 50.0);
        lPWizard.addConstraint("positiveW", 1.0, "<=").plus("Wheat");
        lPWizard.addConstraint("positiveR", 1.0, "<=").plus("Rye");
        lPWizard.addAlternative("wheatbarn_1", "wheatbarn_2");
        lPWizard.addConstraint("storewheat", 0.0, "<=").plus("wheatbarn_1", 30.0).plus("wheatbarn_2", 6.0).plus("Wheat", -1.0);
        lPWizard.addConstraint("storerye", 0.0, "<=").plus("not_wheatbarn_1", 30.0).plus("not_wheatbarn_2", 65.0).plus("Rye", -1.0);
        lPWizard.setMinProblem(false);
        LPSolution lPSolution = lPWizard.solve();
        System.out.println(lPSolution);
    }
}

