/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.problems;

import java.util.HashMap;
import java.util.Map;
import scpsolver.problems.LinearProgram;

public class LPSolution {
    double[] solution;
    HashMap<String, Integer> indexmap;
    LinearProgram lp;

    public LPSolution(double[] dArray, LinearProgram linearProgram) {
        this.solution = dArray;
        this.lp = linearProgram;
        this.indexmap = linearProgram.indexmap;
    }

    public double getDouble(String string) {
        return this.solution[this.indexmap.get(string)];
    }

    public long getInteger(String string) {
        return Math.round(this.solution[this.indexmap.get(string)]);
    }

    public boolean getBoolean(String string) {
        return this.solution[this.indexmap.get(string)] > 0.5;
    }

    public double getObjectiveValue() {
        return this.lp.evaluate(this.solution);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry<String, Integer> entry : this.indexmap.entrySet()) {
            stringBuffer.append(entry.getKey() + "\t" + this.solution[entry.getValue()] + "\n");
        }
        stringBuffer.append("Objective Value \t" + this.getObjectiveValue() + "\n");
        return stringBuffer.toString();
    }
}

