/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.lpsolver;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scpsolver.constraints.LinearSmallerThanEqualsConstraint;
import scpsolver.lpsolver.LinearProgramSolver;
import scpsolver.problems.LinearProgram;

public class SolverFactory {
    private static ServiceLoader<LinearProgramSolver> loader = null;
    private static int DEBUG = 0;

    private SolverFactory() {
    }

    public static LinearProgramSolver newDefault() {
        if (loader == null) {
            SolverFactory.debug("First call to the solver factory - trying to load the service providers ... done", 2);
            loader = ServiceLoader.load(LinearProgramSolver.class);
        } else {
            SolverFactory.debug("Subsequent call to the solver factory - service providers already loaded", 2);
        }
        LinearProgramSolver linearProgramSolver = null;
        try {
            Iterator<LinearProgramSolver> iterator = loader.iterator();
            while (linearProgramSolver == null && iterator.hasNext()) {
                linearProgramSolver = iterator.next();
                SolverFactory.debug("Checking solver: " + linearProgramSolver.getName(), 0);
                if (SolverFactory.loadLibraries(linearProgramSolver.getLibraryNames())) continue;
                linearProgramSolver = null;
            }
            if (linearProgramSolver == null) {
                SolverFactory.debug("No service provider found!", 0);
            } else {
                SolverFactory.debug("Returning the following solver: " + linearProgramSolver.getName(), 0);
                SolverFactory.debug("More available service providers: ", 1);
                while (iterator.hasNext()) {
                    SolverFactory.debug(iterator.next().getName(), 1);
                }
                SolverFactory.debug("End of service providers list!", 1);
            }
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            linearProgramSolver = null;
            serviceConfigurationError.printStackTrace();
        }
        return linearProgramSolver;
    }

    public static LinearProgramSolver getSolver(String string) {
        if (loader == null) {
            SolverFactory.debug("First call to the solver factory - trying to load the service providers ... done", 2);
            loader = ServiceLoader.load(LinearProgramSolver.class);
        } else {
            SolverFactory.debug("Subsequent call to the solver factory - service providers already loaded", 2);
        }
        LinearProgramSolver linearProgramSolver = null;
        SolverFactory.debug("Solvers found:", 2);
        for (LinearProgramSolver linearProgramSolver2 : loader) {
            SolverFactory.debug(linearProgramSolver2.getName(), 2);
        }
        try {
            Iterator<LinearProgramSolver> iterator = loader.iterator();
            while (linearProgramSolver == null && iterator.hasNext()) {
                linearProgramSolver = iterator.next();
                if (!string.equals(linearProgramSolver.getName())) {
                    linearProgramSolver = null;
                    continue;
                }
                SolverFactory.debug("Found solver: " + string, 0);
                if (linearProgramSolver.getLibraryNames() == null || SolverFactory.loadLibraries(linearProgramSolver.getLibraryNames())) continue;
                linearProgramSolver = null;
            }
            if (linearProgramSolver == null) {
                SolverFactory.debug("Could not find specific solver: " + string, 0);
                SolverFactory.debug("Returning new default solver ...", 0);
                linearProgramSolver = SolverFactory.newDefault();
            }
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            linearProgramSolver = null;
            serviceConfigurationError.printStackTrace();
        }
        return linearProgramSolver;
    }

    private static boolean loadLibraries(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        boolean bl = true;
        for (String string : stringArray) {
            bl = bl && SolverFactory.loadLibrary(string);
        }
        if (!bl) {
            SolverFactory.debug("Could not load all necessary libraries", 0);
        }
        return bl;
    }

    private static boolean loadLibrary(String string) {
        String string2 = SolverFactory.modifyLibname(string);
        SolverFactory.debug("Trying to load library: " + string2, 1);
        try {
            System.loadLibrary(string2);
            SolverFactory.debug("Regular library load succesful", 1);
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            SolverFactory.debug("Regular loading failed. Trying to extract library from jar-file", 1);
            try {
                String string3 = System.getProperty("file.separator");
                String string4 = System.getProperty("path.separator");
                String string5 = System.getProperty("java.class.path");
                String string6 = System.mapLibraryName(string2);
                SolverFactory.debug("Checking paths and filenames:", 2);
                SolverFactory.debug("Full library name is: " + string6 + " " + string2, 2);
                if (string6.endsWith(".dylib")) {
                    string6 = "lib" + string2 + ".jnilib";
                    SolverFactory.debug("Full library changed to: " + string6 + " " + string2, 2);
                }
                SolverFactory.debug("java.class.path is: " + string5, 2);
                Pattern pattern = Pattern.compile(".*jar");
                String[] stringArray = string5.split(string4);
                SolverFactory.debug(stringArray.length + " files in classpath", 2);
                Pattern pattern2 = Pattern.compile(".*" + string6);
                InputStream inputStream = null;
                for (String string7 : stringArray) {
                    if (string7 == null || !pattern.matcher(string7).matches()) continue;
                    SolverFactory.debug("Checking " + string7, 2);
                    try {
                        ZipFile zipFile = new ZipFile(string7);
                        Enumeration<? extends ZipEntry> object = zipFile.entries();
                        while (object.hasMoreElements() && inputStream == null) {
                            ZipEntry zipEntry = object.nextElement();
                            if (!pattern2.matcher(zipEntry.getName()).matches()) continue;
                            SolverFactory.debug("FOUND!!!", 2);
                            inputStream = zipFile.getInputStream(zipEntry);
                        }
                        SolverFactory.debug("Finished " + string7, 2);
                    }
                    catch (Exception exception) {
                        SolverFactory.debug("An " + exception.getMessage() + " exception occured while trying to open as a ZIP-File.", 2);
                    }
                    if (inputStream == null) continue;
                    SolverFactory.debug("File found in " + string7, 2);
                    break;
                }
                if (inputStream == null) {
                    SolverFactory.debug("Could not find required library: " + string2, 0);
                    return false;
                }
                string6 = System.mapLibraryName(string2);
                String string8 = System.getProperty("java.library.path");
                SolverFactory.debug("java.library.path is: " + (String)string8, 2);
                if (string8 != null && string8.length() > 0) {
                    String[] stringArray2;
                    SolverFactory.debug("java.library.path seems to contain valid paths", 2);
                    for (String string7 : stringArray2 = string8.split(string4)) {
                        String string9 = string7 + string3 + string6;
                        if (!SolverFactory.writeInStreamToFile(inputStream, string9)) continue;
                        SolverFactory.debug("Wrote library to library path: " + string9, 1);
                        System.loadLibrary(string2);
                        return true;
                    }
                } else {
                    SolverFactory.debug("java.library.path contains no valid paths", 2);
                }
                String[] stringArray3 = new String[]{System.getProperty("user.dir"), System.getProperty("java.io.tmpdir")};
                for (String string10 : stringArray3) {
                    String string11 = string10 + string3 + string6;
                    if (!SolverFactory.writeInStreamToFile(inputStream, string11)) continue;
                    SolverFactory.debug("Wrote library to regular path: " + string11, 1);
                    System.load(string11);
                    return true;
                }
                return false;
            }
            catch (Exception exception) {
                System.err.println("An error occured while searching for the library in the solver module:");
                exception.printStackTrace();
                return false;
            }
        }
    }

    private static boolean writeInStreamToFile(InputStream inputStream, String string) {
        try {
            int n;
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) >= 0) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
            bufferedOutputStream.close();
            SolverFactory.debug("Copied file successfully to: " + string, 2);
            return true;
        }
        catch (IOException iOException) {
            SolverFactory.debug("Failed to write file to: " + string, 1);
            return false;
        }
    }

    private static String modifyLibname(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (System.getProperty("sun.arch.data.model") != null) {
            if (System.getProperty("sun.arch.data.model").equalsIgnoreCase("64")) {
                stringBuilder.append("_x64");
                SolverFactory.debug("64-bit detected", 2);
            }
        } else if (System.getProperty("os.arch.data.model") != null) {
            if (System.getProperty("os.arch.data.model").equalsIgnoreCase("64")) {
                stringBuilder.append("_x64");
                SolverFactory.debug("64-bit detected", 2);
            }
        } else if (System.getProperty("os.arch") != null) {
            if (System.getProperty("os.arch").indexOf("64") > -1) {
                stringBuilder.append("_x64");
                SolverFactory.debug("64-bit detected", 2);
            }
            System.err.println("NOTE: SolverFactory tried to detect library name modifications,");
            System.err.println("but is not sure if all was detected correctly. If the method");
            System.err.println("continues to fail write an email stating all your system properties");
            System.err.println("to: hannes.planatscher@googlemail.com");
        }
        return stringBuilder.toString();
    }

    private static void debug(String string, int n) {
        if (n < DEBUG) {
            System.err.print("DEBUG: ");
            for (int i = 0; i < n; ++i) {
                System.err.print("    ");
            }
            System.err.println(string);
        }
    }

    public static void main(String[] stringArray) {
        LinearProgram linearProgram = new LinearProgram(new double[]{25.0, 30.0});
        linearProgram.addConstraint(new LinearSmallerThanEqualsConstraint(new double[]{0.005, 0.007142857142857143}, 40.0, "Time"));
        linearProgram.setLowerbound(new double[]{0.0, 0.0});
        linearProgram.setUpperbound(new double[]{6000.0, 4000.0});
        linearProgram.setInteger(0);
        linearProgram.setInteger(1);
        LinearProgramSolver linearProgramSolver = SolverFactory.newDefault();
        double[] dArray = linearProgramSolver.solve(linearProgram);
        System.out.println("Solved with: " + linearProgramSolver.getName());
        double[] dArray2 = new double[]{6000.0, 1400.0};
        for (int i = 0; i < dArray.length; ++i) {
            if (!(Math.abs(dArray2[i] - dArray[i]) > 0.001)) continue;
            System.out.println("WRONG RESULTS - but still, it works ;-)");
        }
        System.out.println("New method invocation!");
        LinearProgramSolver linearProgramSolver2 = SolverFactory.getSolver("GLPK");
        linearProgramSolver2.solve(linearProgram);
        System.out.println("What is going on here?");
        linearProgramSolver2 = SolverFactory.getSolver("CPLEX");
        System.out.println("Got solver CPLEX - trying to solve ...");
        linearProgramSolver2.solve(linearProgram);
        System.out.println("Solved with: " + linearProgramSolver2.getName());
    }
}

