/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.infeas;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import scpsolver.constraints.Constraint;
import scpsolver.constraints.LinearBiggerThanEqualsConstraint;
import scpsolver.constraints.LinearConstraint;
import scpsolver.constraints.LinearSmallerThanEqualsConstraint;
import scpsolver.lpsolver.LinearProgramSolver;
import scpsolver.lpsolver.SolverFactory;
import scpsolver.problems.LinearProgram;
import scpsolver.util.SparseVector;
import scpsolver.util.debugging.LPDebugger;

public class LibLinearFile {
    String filename;
    ArrayList<SparseVector> features = new ArrayList();
    ArrayList<Double> labels = new ArrayList();

    public LibLinearFile(String string, int n) {
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                SparseVector sparseVector = new SparseVector(n + 1, 2);
                sparseVector.set(n, 1.0);
                String[] stringArray = string2.split("\\s");
                double d = Double.parseDouble(stringArray[0]);
                this.labels.add(d);
                for (int i = 1; i < stringArray.length; ++i) {
                    String[] stringArray2 = stringArray[i].split(":");
                    sparseVector.set(Integer.parseInt(stringArray2[0]), Double.parseDouble(stringArray2[1]));
                }
                this.features.add(sparseVector);
                string2 = bufferedReader.readLine();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public ArrayList<LinearConstraint> getConstraints(double d) {
        ArrayList<LinearConstraint> arrayList = new ArrayList<LinearConstraint>();
        for (int i = 0; i < this.features.size(); ++i) {
            if (this.labels.get(i) < 0.5) {
                arrayList.add(new LinearSmallerThanEqualsConstraint(this.features.get(i), -d, "negative label " + i));
                continue;
            }
            arrayList.add(new LinearBiggerThanEqualsConstraint(this.features.get(i), d, "positive label " + i));
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        int n;
        Object object;
        Object object2;
        int n2 = 4096;
        double d = 1.0;
        SparseVector sparseVector = new SparseVector(n2 + 1, 2);
        LinearProgram linearProgram = new LinearProgram(sparseVector);
        for (int i = 0; i < stringArray.length; ++i) {
            object2 = stringArray[i];
            object = new LibLinearFile((String)object2, n2);
            linearProgram.addConstraints(((LibLinearFile)object).getConstraints(d));
            System.out.println("Anzahl: " + linearProgram.getConstraints().size());
        }
        LinearProgramSolver linearProgramSolver = SolverFactory.getSolver("LPSOLVE");
        object2 = linearProgramSolver.solve(LPDebugger.getFeasOptLPBinary(linearProgram, 0, 10.0));
        object = new double[linearProgram.getDimension()];
        System.arraycopy(object2, 0, object, 0, ((Object)object).length);
        for (n = 0; n < ((Object)object2).length; ++n) {
            if (!(Math.abs((double)object2[n]) > 0.0)) continue;
            System.out.println(n + " " + (double)object2[n]);
        }
        for (n = linearProgram.getDimension(); n < ((Object)object2).length; ++n) {
            if (!(object2[n] > 0.99)) continue;
            System.out.println(n + "\t" + (double)object2[n]);
        }
        for (Constraint constraint : linearProgram.getConstraints()) {
            if (constraint.isSatisfiedBy((double[])object)) continue;
            System.out.println(constraint.getName() + " not satisfied!!");
        }
    }
}

