/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import scpsolver.graph.Graph;
import scpsolver.graph.Node;

public class Shingling {
    private int lmax;
    private int[] s;
    private int[] c;
    private long[][] random_a;
    private long[][] random_b;
    private final long prime = 4394966321L;

    public Shingling(int n, int[] nArray, int[] nArray2) {
        this.lmax = n;
        this.s = nArray;
        this.c = nArray2;
        this.random_a = new long[n + 1][];
        this.random_b = new long[n + 1][];
        for (int i = 0; i <= n; ++i) {
            this.random_a[i] = new long[this.c[i] - 1];
            this.random_b[i] = new long[this.c[i] - 1];
        }
        Random random = new Random();
        for (int i = 0; i <= n; ++i) {
            for (int j = 0; j < this.c[i] - 1; ++j) {
                this.random_a[i][j] = Math.abs(random.nextLong()) % 4394966321L;
                this.random_b[i][j] = Math.abs(random.nextLong()) % 4394966321L;
            }
        }
    }

    public static void main(String[] stringArray) {
        int[] nArray = new int[]{3, 4, 4, 4};
        int[] nArray2 = new int[]{50, 50, 50, 50};
        Shingling shingling = new Shingling(1, nArray, nArray2);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        Node node = new Node("A");
        Node node2 = new Node("B");
        Node node3 = new Node("C");
        Node node4 = new Node("D");
        Node node5 = new Node("E");
        Node node6 = new Node("F");
        Node node7 = new Node("G");
        Node node8 = new Node("H");
        arrayList.add(node2);
        arrayList2.add(node);
        arrayList.add(node3);
        arrayList2.add(node3);
        arrayList.add(node4);
        arrayList2.add(node4);
        arrayList.add(node5);
        arrayList2.add(node5);
        arrayList.add(node6);
        arrayList2.add(node6);
        arrayList.add(node7);
        arrayList2.add(node7);
        arrayList.add(node8);
        arrayList2.add(node8);
        int[] nArray3 = shingling.shingle(arrayList, nArray[1], nArray2[1], 0);
        int[] nArray4 = shingling.shingle(arrayList2, nArray[1], nArray2[1], 0);
        System.out.println("Shingle1");
        for (int n : nArray3) {
            System.out.println(n);
        }
        System.out.println("Shingle2");
        for (int n : nArray4) {
            System.out.println(n);
        }
    }

    public Graph denseSubgraph(Graph graph) {
        ArrayList<Node> arrayList = new ArrayList<Node>(graph.getNodes().values());
        ArrayList<ArrayList<Node>> arrayList2 = this.RecursiveShingle(0, arrayList, arrayList);
        Graph graph2 = new Graph();
        for (ArrayList<Node> arrayList3 : arrayList2) {
            for (Node node : arrayList3) {
                for (Node node2 : node.getActiveAdjacentNodes()) {
                    graph2.addEdgeSecure(node.getLabel(), node2.getLabel());
                }
            }
        }
        return graph2;
    }

    private ArrayList<ArrayList<Node>> RecursiveShingle(int n, ArrayList<Node> arrayList, ArrayList<Node> arrayList2) {
        System.out.println("Step into Recursive Shingle");
        if (n == this.lmax) {
            return this.unionFind(arrayList, arrayList2);
        }
        HashMap<int[], Node> hashMap = new HashMap<int[], Node>();
        System.out.println("Reached Shingle Step");
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (Node node : arrayList) {
            int[] nArray = this.shingle(node.getActiveAdjacentNodes(), this.s[n + 1], this.c[n + 1], n);
            Arrays.sort(nArray);
            hashMap.put(nArray, node);
            for (Iterator<ArrayList<Node>> iterator : (Iterator<ArrayList<Node>>)nArray) {
                arrayList3.add(Integer.valueOf(iterator));
            }
        }
        System.out.println("Reached V' Producing Step");
        Graph graph = new Graph();
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            Iterator<ArrayList<Node>> iterator2 = new ArrayList();
            for (Object object : hashMap.keySet()) {
                if (!Arrays.asList(object).contains(n2)) continue;
                ((ArrayList)((Object)iterator2)).add((ArrayList<Node>)hashMap.get(object));
                System.out.println("-Shingle overlapping detected");
            }
            Iterator<Object> iterator3 = ((ArrayList)((Object)iterator2)).iterator();
            while (iterator3.hasNext()) {
                Object object;
                object = (Node)iterator3.next();
                graph.addEdgeSecure(Integer.valueOf(n2).toString(), ((Node)object).getLabel());
            }
        }
        System.out.println("Reached Clustering Step");
        ArrayList<ArrayList<Node>> arrayList4 = this.RecursiveShingle(n + 1, new ArrayList<Node>(graph.getNodes().values()), arrayList);
        if (n == 0) {
            return arrayList4;
        }
        System.out.println("Reached Recursive Step");
        ArrayList<ArrayList<Node>> arrayList5 = new ArrayList<ArrayList<Node>>();
        for (ArrayList<Node> arrayList6 : arrayList4) {
            for (Node node : arrayList6) {
                arrayList5.add(node.getActiveAdjacentNodes());
                System.out.println("adding " + node.getLabel() + " and adjacent nodes");
            }
        }
        return arrayList5;
    }

    public int[] shingle(ArrayList<Node> arrayList, int n, int n2, int n3) {
        if (arrayList.size() < n) {
            n = arrayList.size();
        }
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            for (Node node : arrayList) {
                arrayList2.add((this.random_a[n3][i] * (long)node.getLabel().hashCode() + this.random_b[n3][i]) % 4394966321L);
            }
            nArray[i] = Math.abs(this.concat(this.min(n, arrayList2)).hashCode());
        }
        return nArray;
    }

    private ArrayList<ArrayList<Node>> unionFind(ArrayList<Node> arrayList, ArrayList<Node> arrayList2) {
        ArrayList<Object> arrayList3;
        System.out.println("-Step into unionFind");
        ArrayList<ArrayList<Node>> arrayList4 = new ArrayList<ArrayList<Node>>();
        for (Node node : arrayList2) {
            arrayList3 = new ArrayList<Node>();
            arrayList3.add(node);
            arrayList4.add(arrayList3);
        }
        for (Node node : arrayList) {
            ArrayList arrayList5;
            Object object2;
            arrayList3 = node.getActiveAdjacentNodes();
            ArrayList<ArrayList> arrayList6 = new ArrayList<ArrayList>();
            for (Object object2 : arrayList3) {
                arrayList5 = this.find(arrayList4, (Node)object2);
                arrayList6.add(arrayList5);
                arrayList4.remove(arrayList5);
            }
            ArrayList arrayList7 = new ArrayList();
            object2 = arrayList6.iterator();
            while (object2.hasNext()) {
                arrayList5 = (ArrayList)object2.next();
                for (Node node2 : arrayList5) {
                    arrayList7.add(node2);
                }
            }
            arrayList4.add(arrayList7);
        }
        return arrayList4;
    }

    private ArrayList<Node> find(ArrayList<ArrayList<Node>> arrayList, Node node) {
        for (ArrayList<Node> arrayList2 : arrayList) {
            for (Node node2 : arrayList2) {
                if (!node2.equals(node) && node2.getLabel() != node.getLabel()) continue;
                return arrayList2;
            }
        }
        return null;
    }

    private long[] min(int n, ArrayList<Long> arrayList) {
        arrayList = (ArrayList)arrayList.clone();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.getSmallest(arrayList);
        }
        return lArray;
    }

    private long getSmallest(ArrayList<Long> arrayList) {
        long l = arrayList.get(0);
        for (long l2 : arrayList) {
            if (l2 >= l) continue;
            l = l2;
        }
        arrayList.remove(l);
        return l;
    }

    private String concat(long[] lArray) {
        String string = "";
        long[] lArray2 = lArray;
        int n = lArray2.length;
        for (int i = 0; i < n; ++i) {
            Long l = lArray2[i];
            string = string + l.toString();
        }
        return string;
    }

    private boolean proof(int[] nArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int n : nArray) {
            arrayList.add(n);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            int n = (Integer)arrayList.get(0);
            arrayList.remove(0);
            if (!arrayList.contains(n)) continue;
            return false;
        }
        return true;
    }
}

