/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import scpsolver.graph.CardinalityComparator;
import scpsolver.graph.Edge;

public class Node
implements Comparable<Node> {
    String label;
    private ArrayList<Edge> edgeList;
    private boolean debug = false;
    Comparator<Node> comparator;

    public void setComparator(Comparator<Node> comparator) {
        this.comparator = comparator;
    }

    public Node(String string) {
        this.setLabel(string);
        this.edgeList = new ArrayList();
        this.comparator = new CardinalityComparator();
    }

    public Edge addEdgeto(Node node) {
        return new Edge(this, node);
    }

    public boolean equals(Object object) {
        if (object instanceof Node) {
            return ((Node)object).getLabel().equals(this.label);
        }
        return super.equals(object);
    }

    public Edge addEdgeto(Node node, String string) {
        Edge edge = this.addEdgeto(node);
        edge.setLabel(string);
        return edge;
    }

    public void addEdge(Edge edge) {
        if (edge.node1 == this || edge.node2 == this) {
            this.edgeList.add(edge);
            if (this.debug) {
                System.out.println("Edge added:" + edge);
            }
        } else {
            System.out.println(edge + " does not contain this node " + this);
        }
    }

    public ArrayList<Node> getAdjacentNodes() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Edge edge : this.edgeList) {
            if (edge.node1 == this) {
                arrayList.add(edge.node2);
                continue;
            }
            arrayList.add(edge.node1);
        }
        return arrayList;
    }

    public ArrayList<Node> getActiveAdjacentNodes() {
        HashSet<Node> hashSet = new HashSet<Node>();
        for (Edge edge : this.edgeList) {
            if (!edge.isActive()) continue;
            if (edge.node1 == this) {
                hashSet.add(edge.node2);
                continue;
            }
            hashSet.add(edge.node1);
        }
        return new ArrayList<Node>(hashSet);
    }

    public ArrayList<Node> getOutboundNodes() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Edge edge : this.edgeList) {
            if (!edge.isActive() || edge.node1 != this) continue;
            arrayList.add(edge.node2);
        }
        return arrayList;
    }

    public ArrayList<Node> getInboundNodes() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Edge edge : this.edgeList) {
            if (!edge.isActive() || edge.node2 != this) continue;
            arrayList.add(edge.node1);
        }
        return arrayList;
    }

    public ArrayList<Edge> getEdgeList() {
        return this.edgeList;
    }

    public void removeAllEdges() {
        while (this.getCardinality() != 0) {
            if (this.debug) {
                System.out.println("Edge removed:" + this.edgeList.get(0));
            }
            this.edgeList.get(0).removeEdge();
        }
    }

    public void deactivateAllEdges() {
        for (Edge edge : this.edgeList) {
            edge.setActive(false);
        }
    }

    public void activateAllEdges() {
        for (Edge edge : this.edgeList) {
            edge.setActive(true);
        }
    }

    public String toString() {
        return this.label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public int getCardinality() {
        return this.edgeList.size();
    }

    public int getActiveCardinality() {
        int n = 0;
        for (Edge edge : this.edgeList) {
            if (!edge.isActive()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int compareTo(Node node) {
        return this.comparator.compare(this, node);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public Comparator<Node> getComparator() {
        return this.comparator;
    }

    public void setEdgeList(ArrayList<Edge> arrayList) {
        this.edgeList = arrayList;
    }

    public boolean equals(Node node) {
        return this.label.equals(node.getLabel());
    }

    public static void main(String[] stringArray) {
        Node node = new Node("Node 1");
        Node node2 = new Node("Node 2");
        Node node3 = new Node("Node 3");
        Node node4 = new Node("Node 4");
        node.addEdgeto(node4);
        node4.addEdgeto(node2);
        node2.addEdgeto(node3);
        HashSet<Node> hashSet = new HashSet<Node>();
        if (hashSet.add(node)) {
            System.out.println(node + " ADDED" + node.getCardinality());
        }
        if (hashSet.add(node2)) {
            System.out.println(node2 + " ADDED" + node2.getCardinality());
        }
        if (hashSet.add(node3)) {
            System.out.println(node3 + " ADDED" + node3.getCardinality());
        }
        if (hashSet.add(node4)) {
            System.out.println(node4 + " ADDED" + node4.getCardinality());
        }
        System.out.println(Collections.max(hashSet));
        node2.addEdgeto(node3);
        System.out.println(Collections.max(hashSet));
    }
}

