/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.graph;

import java.util.Random;
import scpsolver.graph.Graph;
import scpsolver.util.SparseMatrix;

public class GraphMiner {
    private Random random = new Random();

    public static Graph getGraph(SparseMatrix sparseMatrix) {
        Graph graph = new Graph();
        for (int i = 0; i < sparseMatrix.getRowNum(); ++i) {
            for (int j = 0; j < sparseMatrix.getColNum(); ++j) {
                if (sparseMatrix.get(i, j) == 0.0 || i == j || graph.hasEdge(Integer.valueOf(i).toString(), Integer.valueOf(j).toString()) || graph.hasEdge(Integer.valueOf(j).toString(), Integer.valueOf(i).toString())) continue;
                graph.addEdgeSecure(Integer.valueOf(i).toString(), Integer.valueOf(j).toString());
            }
        }
        return graph;
    }

    public Graph createRandomGraph(int n) {
        SparseMatrix sparseMatrix = this.createRandomMatrix(n);
        return GraphMiner.getGraph(sparseMatrix);
    }

    public SparseMatrix createRandomMatrix(int n) {
        SparseMatrix sparseMatrix = new SparseMatrix(n, n);
        for (int i = 0; i < sparseMatrix.getRowNum(); ++i) {
            for (int j = 0; j < sparseMatrix.getColNum(); ++j) {
                sparseMatrix.set(i, j, this.randomInt(n));
            }
        }
        return sparseMatrix;
    }

    private double randomInt(int n) {
        if (this.random.nextInt() % n / 2 == 0) {
            return 1.0;
        }
        return 0.0;
    }
}

