/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.graph;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import scpsolver.graph.Edge;
import scpsolver.graph.GraphInterface;
import scpsolver.graph.Node;
import scpsolver.util.SparseMatrix;

public class Graph
implements GraphInterface {
    private HashMap<String, Node> nodes = new HashMap();

    @Override
    public HashMap<String, Node> getNodes() {
        return this.nodes;
    }

    @Override
    public Node getNode(String string) {
        return this.nodes.get(string);
    }

    public Edge getEdge(String string, String string2) {
        if (!this.hasEdge(string, string2) && !this.hasEdge(string2, string)) {
            throw new RuntimeException("Edge not found: " + string + " , " + string2);
        }
        Node node = this.nodes.get(string);
        Node node2 = this.nodes.get(string2);
        for (Edge edge : node.getEdgeList()) {
            if (!edge.getNode1().equals(node2) && !edge.getNode2().equals(node2)) continue;
            return edge;
        }
        throw new RuntimeException("unexpected error searching for edge");
    }

    public Graph() {
    }

    private Graph(Graph graph) {
        this.addGraph(graph);
    }

    public Graph clone() {
        return new Graph(this);
    }

    public void reset() {
        for (Node node : this.nodes.values()) {
            node.activateAllEdges();
        }
    }

    public Node addNode(Node node) {
        Node node2 = this.nodes.get(node.getLabel());
        if (node2 == null) {
            this.nodes.put(node.getLabel(), node);
            node2 = node;
        }
        return node2;
    }

    public void addGraph(Graph graph) {
        for (Node node : graph.getNodes().values()) {
            this.addNode(new Node(node.getLabel()));
        }
        for (Node node : graph.getNodes().values()) {
            ArrayList<Edge> arrayList = node.getEdgeList();
            for (Edge edge : arrayList) {
                if (edge.getNode1() != node) continue;
                Edge edge2 = this.addEdgeSecure(edge.node1.getLabel(), edge.node2.getLabel());
                edge2.setLabel(new String(edge.getLabel()));
                edge2.setWeight(edge.getWeight());
                edge2.setProperties(new Hashtable<String, String>(edge.getProperties()));
            }
        }
    }

    private HashSet<Node> getComponent(Node node, HashSet<Node> hashSet) {
        for (Node node2 : node.getActiveAdjacentNodes()) {
            if (!hashSet.add(node2)) continue;
            this.getComponent(node2, hashSet);
        }
        return hashSet;
    }

    public HashSet<Node> getComponent(Node node) {
        HashSet<Node> hashSet = new HashSet<Node>();
        hashSet.add(node);
        return this.getComponent(node, hashSet);
    }

    private HashSet<Node> getComponentDL(Node node, HashSet<Node> hashSet, HashSet<Node> hashSet2, int n) {
        for (Node node2 : node.getActiveAdjacentNodes()) {
            if (!hashSet.add(node2)) continue;
            if (n > 100) {
                hashSet2.add(node2);
            }
            this.getComponentDL(node2, hashSet, hashSet2, n + 1);
        }
        return hashSet;
    }

    public HashSet<Node> getComponentDL(Node node, HashSet<Node> hashSet) {
        if (hashSet.add(node)) {
            HashSet<Node> hashSet2 = new HashSet<Node>();
            this.getComponentDL(node, hashSet, hashSet2, 0);
            for (Node node2 : hashSet2) {
                this.getComponentDL(node2, hashSet);
            }
        }
        return hashSet;
    }

    public ArrayList<HashSet<Node>> getAllComponentsDL() {
        ArrayList<HashSet<Node>> arrayList = new ArrayList<HashSet<Node>>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>(this.getNodes().values());
        while (!arrayList2.isEmpty()) {
            HashSet<Node> hashSet = new HashSet<Node>();
            this.getComponentDL(arrayList2.get(0), hashSet);
            arrayList.add(hashSet);
            arrayList2.removeAll(hashSet);
        }
        return arrayList;
    }

    public ArrayList<HashSet<Node>> getAllComponents() {
        ArrayList<HashSet<Node>> arrayList = new ArrayList<HashSet<Node>>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>(this.getNodes().values());
        while (!arrayList2.isEmpty()) {
            HashSet<Node> hashSet = this.getComponent(arrayList2.get(0));
            arrayList.add(hashSet);
            arrayList2.removeAll(hashSet);
        }
        return arrayList;
    }

    public void removeNode(Node node) {
        node.removeAllEdges();
        this.nodes.remove(node.getLabel());
    }

    public void removeEdge(Edge edge) {
        int n;
        Node node = this.nodes.get(edge.getNode1().getLabel());
        Node node2 = this.nodes.get(edge.getNode2().getLabel());
        for (n = 0; n < node.getEdgeList().size(); ++n) {
            if (!node.getEdgeList().get(n).toNormalizedString().equals(edge.toNormalizedString())) continue;
            node.getEdgeList().remove(n);
            break;
        }
        for (n = 0; n < node2.getEdgeList().size(); ++n) {
            if (!node2.getEdgeList().get(n).toNormalizedString().equals(edge.toNormalizedString())) continue;
            node2.getEdgeList().remove(n);
            break;
        }
        node2.getEdgeList().remove(edge);
    }

    public void removeCards() {
        ArrayList<Node> arrayList = this.getNodeWithCardinality(0, 0);
        for (Node node : arrayList) {
            this.removeNode(node);
        }
    }

    public boolean isEmpty() {
        return this.getNodes().isEmpty();
    }

    @Override
    public int getNumberNodes() {
        return this.nodes.size();
    }

    public int getNumberEdges() {
        int n = 0;
        for (Node node : this.nodes.values()) {
            n += node.getCardinality();
        }
        return n / 2;
    }

    @Override
    public boolean hasEdge(String string, String string2) {
        if (!this.nodes.containsKey(string)) {
            return false;
        }
        if (!this.nodes.containsKey(string2)) {
            return false;
        }
        Node node = this.nodes.get(string);
        Node node2 = this.nodes.get(string2);
        return node.getOutboundNodes().contains(node2);
    }

    public Edge addEdgeSecure(String string, String string2, boolean bl) {
        Node node = this.addNode(new Node(string));
        Node node2 = this.addNode(new Node(string2));
        if (bl) {
            return node2.addEdgeto(node);
        }
        return node.addEdgeto(node2);
    }

    @Override
    public Edge addEdgeSecure(String string, String string2) {
        return this.addEdgeSecure(string, string2, false);
    }

    public Edge addEdgeSecure(String string, String string2, String string3, boolean bl) {
        Edge edge = this.addEdgeSecure(string, string2, bl);
        edge.setLabel(string3);
        return edge;
    }

    public String toGML() {
        StringBuffer stringBuffer = new StringBuffer();
        Hashtable<Node, Integer> hashtable = new Hashtable<Node, Integer>();
        stringBuffer.append("graph [ \n comment \"no comment\"  \n directed 1  \n id 42  \n label \"Graph\"\n");
        int n = 1;
        int n2 = 0;
        for (Node node : this.getNodes().values()) {
            if (node.getCardinality() == 0) {
                System.out.println(node.getLabel() + " has  card");
            }
            if (node.getCardinality() <= n2) continue;
            stringBuffer.append("node [ \n id " + n + "\n label \"" + node.getLabel() + "\"\n");
            stringBuffer.append("]\n");
            hashtable.put(node, n);
            ++n;
        }
        for (Node node : this.getNodes().values()) {
            if (node.getCardinality() <= n2) continue;
            for (Edge edge : node.getEdgeList()) {
                if (edge.getNode1() != node) continue;
                stringBuffer.append("edge [\n source " + hashtable.get(edge.node1) + "\n target " + hashtable.get(edge.node2) + "\n label \"" + edge.getLabel() + "\"\n graphics\n[\n\tfill\t\"#000000\"\n\ttargetArrow\t\"standard\"\n\t]\n  ]\n");
            }
        }
        return stringBuffer.toString();
    }

    public String toGMLwithGrouping(ArrayList<HashSet<Node>> arrayList, ArrayList<String> arrayList2) {
        StringBuffer stringBuffer = new StringBuffer();
        Hashtable<Node, Integer> hashtable = new Hashtable<Node, Integer>();
        stringBuffer.append("graph [ \n comment \"no comment\"  \n directed 1  \n id 42  \n label \"Graph\"\n");
        int n = 1;
        Hashtable<Node, Integer> hashtable2 = new Hashtable<Node, Integer>();
        for (HashSet<Node> object : arrayList) {
            for (Node node : object) {
                hashtable2.put(node, n);
            }
            ++n;
        }
        int n2 = 1;
        for (String string : arrayList2) {
            stringBuffer.append("node [ \n id " + n2 + "\n label \"" + string + "\"\n");
            stringBuffer.append("\t\tgraphics \n\t\t[ \n\t\t\ttype\t\"roundrectangle\" \n\t\t\tfill\t\"#CAECFF84\" \n\t\t\toutline\t\"#666699\" \n\t\t\toutlineStyle\t\"dotted\" \n\t\t\ttopBorderInset\t0.0 \n\t\t\tbottomBorderInset\t0.0 \n\t\t\tleftBorderInset\t0.0 \n\t\t\trightBorderInset\t0.0 \n\t\t] \n\t\tLabelGraphics \n\t\t[ \n\t\t\ttext\t\"" + string + "\" \n" + "\t\t\tfill\t\"#99CCFF\" \n" + "\t\t\tfontSize\t15 \n" + "\t\t\tfontName\t\"Dialog\" \n" + "\t\t\talignment\t\"right\" \n" + "\t\t\tautoSizePolicy\t\"node_width\" \n" + "\t\t\tanchor\t\"t\" \n" + "\t\t\tborderDistance\t0.0 \n" + "\t\t] \n" + "\t\tisGroup\t1 \n");
            stringBuffer.append("]\n");
            ++n2;
        }
        int n3 = 0;
        for (Node node : this.getNodes().values()) {
            if (node.getCardinality() == 0) {
                System.out.println(node.getLabel() + " has  card");
            }
            if (node.getCardinality() <= n3) continue;
            stringBuffer.append("node [ \n id " + n2 + "\n label \"" + node.getLabel() + "\"\n");
            if (hashtable2.containsKey(node)) {
                stringBuffer.append(" gid " + hashtable2.get(node) + "\n");
            }
            stringBuffer.append("]\n");
            hashtable.put(node, n2);
            ++n2;
        }
        for (Node node : this.getNodes().values()) {
            if (node.getCardinality() <= n3) continue;
            for (Edge edge : node.getEdgeList()) {
                if (edge.getNode1() != node) continue;
                stringBuffer.append("edge [\n source " + hashtable.get(edge.node1) + "\n target " + hashtable.get(edge.node2) + "\n label \"" + edge.getLabel() + "\"\n");
                stringBuffer.append(" graphics [\n");
                Hashtable<String, String> hashtable3 = edge.getProperties();
                if (hashtable3 != null) {
                    for (String string : hashtable3.keySet()) {
                        String string2 = hashtable3.get(string);
                        try {
                            int n4 = Integer.parseInt(string2);
                            stringBuffer.append("\t" + string + "\t" + n4 + "\n");
                        }
                        catch (Exception exception) {
                            stringBuffer.append("\t" + string + "\t\"" + string2 + "\"\n");
                        }
                    }
                }
                stringBuffer.append("\ttargetArrow\t\"standard\"\n]");
                stringBuffer.append("\n  ]\n");
            }
        }
        return stringBuffer.toString();
    }

    public String toMTX() {
        StringBuffer stringBuffer = new StringBuffer();
        Hashtable<Node, Integer> hashtable = new Hashtable<Node, Integer>();
        int n = 1;
        int n2 = 0;
        int n3 = this.getNumberNodes();
        int n4 = this.getNumberEdges();
        stringBuffer.append(n3 + "\t" + n3 + "\t" + n4 + "\n");
        for (Node node : this.getNodes().values()) {
            if (node.getCardinality() <= n2) continue;
            hashtable.put(node, n);
            ++n;
        }
        for (Node node : this.getNodes().values()) {
            if (node.getCardinality() <= n2) continue;
            for (Edge edge : node.getEdgeList()) {
                if (edge.getNode1() != node) continue;
                stringBuffer.append("\t" + hashtable.get(edge.getNode1()) + "\t" + hashtable.get(edge.getNode2()) + "\t1.0\n");
            }
        }
        return stringBuffer.toString();
    }

    public ArrayList<Node> getNodeWithCardinality(int n, int n2) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : this.nodes.values()) {
            int n3 = node.getCardinality();
            if (n3 < n || n3 > n2) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    public ArrayList<Node> getNodeWithActiveCardinality(int n, int n2) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : this.nodes.values()) {
            int n3 = node.getActiveCardinality();
            if (n3 < n || n3 > n2) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    public void toGML(String string) {
        try {
            FileWriter fileWriter = new FileWriter(new File(string));
            fileWriter.write(this.toGML());
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            System.out.println("Could not write GML-file " + string + " because" + exception.getMessage());
        }
    }

    public void toGML(String string, ArrayList<HashSet<Node>> arrayList, ArrayList<String> arrayList2) {
        try {
            FileWriter fileWriter = new FileWriter(new File(string));
            fileWriter.write(this.toGMLwithGrouping(arrayList, arrayList2));
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            System.out.println("Could not write GML-file " + string + " because" + exception.getMessage());
        }
    }

    public ArrayList<Node> getNodeSet(String string) {
        String[] stringArray;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (String string2 : stringArray = string.split(" ")) {
            if (!this.nodes.containsKey(string2)) continue;
            arrayList.add(this.nodes.get(string2));
        }
        return arrayList;
    }

    public ArrayList<Node> getNodeSetPipe(String string) {
        String[] stringArray;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (String string2 : stringArray = string.split("\n")) {
            if (!this.nodes.containsKey(string2)) continue;
            arrayList.add(this.nodes.get(string2));
        }
        return arrayList;
    }

    public SparseMatrix getAdjMatrix() {
        return this.getAdjMatrix(new ArrayList<Node>(this.getNodes().values()));
    }

    public SparseMatrix getAdjMatrix(ArrayList<Node> arrayList) {
        SparseMatrix sparseMatrix = new SparseMatrix(arrayList.size(), arrayList.size());
        HashMap<Node, Integer> hashMap = new HashMap<Node, Integer>();
        int n = 0;
        for (Node node : arrayList) {
            hashMap.put(node, n++);
        }
        for (Node node : arrayList) {
            ArrayList<Node> arrayList2 = node.getActiveAdjacentNodes();
            int n2 = (Integer)hashMap.get(node);
            for (Node node2 : arrayList2) {
                Integer n3 = (Integer)hashMap.get(node2);
                if (n3 == null) continue;
                sparseMatrix.set(n2, n3, 1.0);
            }
        }
        return sparseMatrix;
    }

    public void activateAllEdges() {
        for (Node node : this.getNodes().values()) {
            node.activateAllEdges();
        }
    }

    public static void main(String[] stringArray) {
        Graph graph = new Graph();
        graph.addEdgeSecure("A", "U");
        graph.addEdgeSecure("U", "A");
        graph.addEdgeSecure("B", "X");
        graph.addEdgeSecure("B", "Y");
        graph.addEdgeSecure("C", "X");
        graph.addEdgeSecure("D", "Z");
        graph.addEdgeSecure("E", "Y");
        graph.addEdgeSecure("F", "K");
        graph.addEdgeSecure("F", "O");
        graph.addEdgeSecure("D", "X");
        graph.clone();
    }
}

