/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.graph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import scpsolver.graph.DenseSubgraphExtractor;
import scpsolver.graph.DenseSubgraphExtractorTest;
import scpsolver.graph.Graph;
import scpsolver.graph.Node;

public class GlobalDenseSubgraphExtractor
extends DenseSubgraphExtractor {
    private HashMap<Node, Integer> charges;
    private ArrayList<Node> ordering;
    private double[] densities;
    private int[] nodes;

    public GlobalDenseSubgraphExtractor() {
    }

    public GlobalDenseSubgraphExtractor(String string) {
        this.fileurl = string;
    }

    public Graph denseLargeSubgraph(Graph graph, int n) throws IOException {
        int n2;
        int n3;
        this.coreOrdering(graph);
        int n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            n4 += this.charges.get(this.ordering.get(n3)).intValue();
        }
        this.nodes = new int[graph.getNumberNodes() - n];
        this.densities = new double[graph.getNumberNodes() - n];
        n3 = 0;
        for (n2 = n; n2 < graph.getNumberNodes(); ++n2) {
            this.nodes[n3] = n2;
            this.densities[n3++] = GlobalDenseSubgraphExtractor.computeDensity(n4 += this.charges.get(this.ordering.get(n2)).intValue(), n2 + 1);
        }
        n2 = 0;
        double d = 0.0;
        for (int i = 0; i < this.densities.length; ++i) {
            if (!(this.densities[i] > d)) continue;
            d = this.densities[i];
            n2 = i;
        }
        n2 += n;
        Graph graph2 = graph.clone();
        for (int i = graph.getNumberNodes() - 1; i >= n2; --i) {
            graph2.removeNode(graph2.getNode(this.ordering.get(i).getLabel()));
        }
        if (this.fileurl != "") {
            this.writeNodeDensities(this.fileurl + "_andersen_plotdata.txt");
            ArrayList<Graph> arrayList = DenseSubgraphExtractor.getConnectedComponents(graph2);
            if (arrayList.size() > 1) {
                DenseSubgraphExtractorTest.writeDensities(arrayList, this.fileurl + "_andersen_subgraph_densities.txt");
            }
        }
        return graph2;
    }

    public Graph denseLargeSubgraph(Graph graph) throws IOException {
        return this.denseLargeSubgraph(graph, 0);
    }

    public ArrayList<Graph> denseLargeSubgraphParted(Graph graph, int n) throws IOException {
        return GlobalDenseSubgraphExtractor.getConnectedComponents(this.denseLargeSubgraph(graph, n));
    }

    public ArrayList<Graph> denseLargeSubgraphParted(Graph graph) throws IOException {
        return GlobalDenseSubgraphExtractor.getConnectedComponents(this.denseLargeSubgraph(graph));
    }

    public void coreOrdering(Graph graph) {
        this.charges = new HashMap();
        Graph graph2 = graph.clone();
        int n = 0;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        while (!graph2.isEmpty()) {
            Node node = this.getSmallest(new ArrayList<Node>(graph2.getNodes().values()));
            int n2 = node.getActiveCardinality();
            Node node2 = new Node(node.getLabel());
            node2.setEdgeList(node.getEdgeList());
            this.charges.put(node2, n2);
            n += n2;
            arrayList.add(0, node2);
            graph2.removeNode(node);
        }
        this.ordering = arrayList;
    }

    private Node getSmallest(ArrayList<Node> arrayList) {
        Node node = arrayList.get(0);
        for (Node node2 : arrayList) {
            if (node2.getActiveCardinality() >= node.getActiveCardinality()) continue;
            node = node2;
        }
        return node;
    }

    public ArrayList<Node> getOrdering() {
        return this.ordering;
    }

    public void setOrdering(ArrayList<Node> arrayList) {
        this.ordering = arrayList;
    }

    public HashMap<Node, Integer> getCharges() {
        return this.charges;
    }

    public void setCharges(HashMap<Node, Integer> hashMap) {
        this.charges = hashMap;
    }

    public void writeNodeDensities(String string) throws IOException {
        this.toRFile(string, "Nodes Density\n", this.nodes, this.densities);
    }

    public double[] getDensities() {
        return this.densities;
    }

    public int[] getNodes() {
        return this.nodes;
    }
}

