/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.graph;

import java.util.Arrays;
import java.util.Hashtable;
import scpsolver.graph.Node;

public class Edge {
    Node node1;
    Node node2;
    boolean active;
    String label;
    int weight;
    Hashtable<String, String> properties;

    public void setProperty(String string, String string2) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(string, string2);
    }

    public String getProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(string);
    }

    public Hashtable<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Hashtable<String, String> hashtable) {
        this.properties = hashtable;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int n) {
        this.weight = n;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public Edge(Node node, Node node2) {
        this.setNode1(node);
        this.setNode2(node2);
        node.addEdge(this);
        node2.addEdge(this);
        this.label = "";
        this.active = true;
    }

    public Node getNode1() {
        return this.node1;
    }

    public void setNode1(Node node) {
        this.node1 = node;
    }

    public Node getNode2() {
        return this.node2;
    }

    public void setNode2(Node node) {
        this.node2 = node;
    }

    public String toString() {
        return "(" + this.node1.getLabel() + "-" + this.label + " -> " + this.node2.getLabel() + ")";
    }

    public void removeEdge() {
        this.node1.getEdgeList().remove(this);
        this.node2.getEdgeList().remove(this);
    }

    public boolean equals(Edge edge) {
        return this.toNormalizedString().equals(edge.toNormalizedString());
    }

    public String[] getNodeLabels() {
        Object[] objectArray = new String[]{this.node1.getLabel(), this.node2.getLabel()};
        Arrays.sort(objectArray);
        return objectArray;
    }

    public String toNormalizedString() {
        String[] stringArray = this.getNodeLabels();
        String string = stringArray[0];
        String string2 = stringArray[1];
        return "(" + string + " --> " + string2 + ")";
    }
}

