/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.graph;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import javax.swing.JFrame;
import javax.swing.JPanel;
import scpsolver.graph.ReverseCuthillMcKee;
import scpsolver.util.NonZeroElementIterator;
import scpsolver.util.SparseMatrix;

public class DotPlot {
    public void dotPlot(SparseMatrix sparseMatrix) {
        JFrame jFrame = new JFrame("Dot Plot");
        jFrame.setSize(500, 500);
        jFrame.add(new SparseDrawingPanel(sparseMatrix));
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        DotPlot dotPlot = new DotPlot();
        ReverseCuthillMcKee reverseCuthillMcKee = new ReverseCuthillMcKee();
        dotPlot.dotPlot(SparseMatrix.readMTX(stringArray[0]));
    }

    class SparseDrawingPanel
    extends JPanel {
        private static final long serialVersionUID = -9144254916888457063L;
        SparseMatrix m;

        public SparseDrawingPanel(SparseMatrix sparseMatrix) {
            this.m = sparseMatrix;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n = this.m.getRowNum();
            int n2 = this.m.getColNum();
            int n3 = this.getSize().width;
            int n4 = this.getSize().height;
            BufferedImage bufferedImage = new BufferedImage(n3, n4, 10);
            int n5 = n2 > n3 ? n2 / n3 + 1 : 1;
            int n6 = n > n4 ? n / n4 + 1 : 1;
            byte[][] byArray = new byte[n4][n3];
            NonZeroElementIterator nonZeroElementIterator = this.m.getNonZeroElementIterator();
            while (nonZeroElementIterator.hasNext()) {
                nonZeroElementIterator.next();
                try {
                    byArray[nonZeroElementIterator.getActuali() / n6][nonZeroElementIterator.getActualj() / n5] = -1;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            }
            WritableRaster writableRaster = bufferedImage.getRaster();
            for (int i = 0; i < byArray.length; ++i) {
                for (int j = 0; j < byArray[i].length; ++j) {
                    writableRaster.setSample(j, i, 0, 255 - byArray[i][j]);
                }
            }
            graphics.drawImage(bufferedImage, 0, 0, this);
        }
    }

    class DrawingPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        Image img;

        public DrawingPanel(Image image) {
            this.img = image;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.drawImage(this.img, 0, 0, this.getSize().width, this.getSize().height, this);
        }
    }
}

